# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BatchLanguageTranslationDetails(object):
    """
    The documents details for translation call.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BatchLanguageTranslationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param alias:
            The value to assign to the alias property of this BatchLanguageTranslationDetails.
        :type alias: str

        :param endpoint_id:
            The value to assign to the endpoint_id property of this BatchLanguageTranslationDetails.
        :type endpoint_id: str

        :param no_translate:
            The value to assign to the no_translate property of this BatchLanguageTranslationDetails.
        :type no_translate: list[str]

        :param compartment_id:
            The value to assign to the compartment_id property of this BatchLanguageTranslationDetails.
        :type compartment_id: str

        :param target_language_code:
            The value to assign to the target_language_code property of this BatchLanguageTranslationDetails.
        :type target_language_code: str

        :param documents:
            The value to assign to the documents property of this BatchLanguageTranslationDetails.
        :type documents: list[oci.ai_language.models.TextDocument]

        """
        self.swagger_types = {
            'alias': 'str',
            'endpoint_id': 'str',
            'no_translate': 'list[str]',
            'compartment_id': 'str',
            'target_language_code': 'str',
            'documents': 'list[TextDocument]'
        }
        self.attribute_map = {
            'alias': 'alias',
            'endpoint_id': 'endpointId',
            'no_translate': 'noTranslate',
            'compartment_id': 'compartmentId',
            'target_language_code': 'targetLanguageCode',
            'documents': 'documents'
        }
        self._alias = None
        self._endpoint_id = None
        self._no_translate = None
        self._compartment_id = None
        self._target_language_code = None
        self._documents = None

    @property
    def alias(self):
        """
        Gets the alias of this BatchLanguageTranslationDetails.
        Unique name to identify an endpoint to be used for inferencing


        :return: The alias of this BatchLanguageTranslationDetails.
        :rtype: str
        """
        return self._alias

    @alias.setter
    def alias(self, alias):
        """
        Sets the alias of this BatchLanguageTranslationDetails.
        Unique name to identify an endpoint to be used for inferencing


        :param alias: The alias of this BatchLanguageTranslationDetails.
        :type: str
        """
        self._alias = alias

    @property
    def endpoint_id(self):
        """
        Gets the endpoint_id of this BatchLanguageTranslationDetails.
        The endpoint that has to be used for inferencing.


        :return: The endpoint_id of this BatchLanguageTranslationDetails.
        :rtype: str
        """
        return self._endpoint_id

    @endpoint_id.setter
    def endpoint_id(self, endpoint_id):
        """
        Sets the endpoint_id of this BatchLanguageTranslationDetails.
        The endpoint that has to be used for inferencing.


        :param endpoint_id: The endpoint_id of this BatchLanguageTranslationDetails.
        :type: str
        """
        self._endpoint_id = endpoint_id

    @property
    def no_translate(self):
        """
        Gets the no_translate of this BatchLanguageTranslationDetails.
        List of words not to be translated


        :return: The no_translate of this BatchLanguageTranslationDetails.
        :rtype: list[str]
        """
        return self._no_translate

    @no_translate.setter
    def no_translate(self, no_translate):
        """
        Sets the no_translate of this BatchLanguageTranslationDetails.
        List of words not to be translated


        :param no_translate: The no_translate of this BatchLanguageTranslationDetails.
        :type: list[str]
        """
        self._no_translate = no_translate

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this BatchLanguageTranslationDetails.
        The `OCID`__ of the compartment that calls the API, inference will be served from pre trained model

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this BatchLanguageTranslationDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this BatchLanguageTranslationDetails.
        The `OCID`__ of the compartment that calls the API, inference will be served from pre trained model

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this BatchLanguageTranslationDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def target_language_code(self):
        """
        Gets the target_language_code of this BatchLanguageTranslationDetails.
        Language code supported
        Arabic - ar
        Brazilian Portuguese -  pt-BR
        Canadian French - fr-CA
        Croatian - hr
        Czech - cs
        Danish - da
        Dutch - nl
        English - en
        Finnish - fi
        French - fr
        German - de
        Greek - el
        Hebrew - he
        Hungarian - hu
        Italian - it
        Japanese - ja
        Korean - ko
        Norwegian - no
        Polish - pl
        Portuguese - pt
        Romanian - ro
        Russian - ru
        Simplified Chinese - zh-CN
        Slovak - sk
        Slovenian - sl
        Spanish - es
        Swedish - sv
        Thai - th
        Traditional Chinese - zh-TW
        Turkish - tr
        Vietnamese - vi


        :return: The target_language_code of this BatchLanguageTranslationDetails.
        :rtype: str
        """
        return self._target_language_code

    @target_language_code.setter
    def target_language_code(self, target_language_code):
        """
        Sets the target_language_code of this BatchLanguageTranslationDetails.
        Language code supported
        Arabic - ar
        Brazilian Portuguese -  pt-BR
        Canadian French - fr-CA
        Croatian - hr
        Czech - cs
        Danish - da
        Dutch - nl
        English - en
        Finnish - fi
        French - fr
        German - de
        Greek - el
        Hebrew - he
        Hungarian - hu
        Italian - it
        Japanese - ja
        Korean - ko
        Norwegian - no
        Polish - pl
        Portuguese - pt
        Romanian - ro
        Russian - ru
        Simplified Chinese - zh-CN
        Slovak - sk
        Slovenian - sl
        Spanish - es
        Swedish - sv
        Thai - th
        Traditional Chinese - zh-TW
        Turkish - tr
        Vietnamese - vi


        :param target_language_code: The target_language_code of this BatchLanguageTranslationDetails.
        :type: str
        """
        self._target_language_code = target_language_code

    @property
    def documents(self):
        """
        **[Required]** Gets the documents of this BatchLanguageTranslationDetails.
        List of documents for translation.


        :return: The documents of this BatchLanguageTranslationDetails.
        :rtype: list[oci.ai_language.models.TextDocument]
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """
        Sets the documents of this BatchLanguageTranslationDetails.
        List of documents for translation.


        :param documents: The documents of this BatchLanguageTranslationDetails.
        :type: list[oci.ai_language.models.TextDocument]
        """
        self._documents = documents

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
