# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SdkLanguageOptionalParametersAllowedValue(object):
    """
    Allowed value object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SdkLanguageOptionalParametersAllowedValue object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this SdkLanguageOptionalParametersAllowedValue.
        :type name: str

        :param description:
            The value to assign to the description property of this SdkLanguageOptionalParametersAllowedValue.
        :type description: str

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description'
        }
        self._name = None
        self._description = None

    @property
    def name(self):
        """
        Gets the name of this SdkLanguageOptionalParametersAllowedValue.
        Name of the allowed value.


        :return: The name of this SdkLanguageOptionalParametersAllowedValue.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SdkLanguageOptionalParametersAllowedValue.
        Name of the allowed value.


        :param name: The name of this SdkLanguageOptionalParametersAllowedValue.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this SdkLanguageOptionalParametersAllowedValue.
        Description for the allowed value.


        :return: The description of this SdkLanguageOptionalParametersAllowedValue.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this SdkLanguageOptionalParametersAllowedValue.
        Description for the allowed value.


        :param description: The description of this SdkLanguageOptionalParametersAllowedValue.
        :type: str
        """
        self._description = description

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
