# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .monitor_configuration import MonitorConfiguration
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FtpMonitorConfiguration(MonitorConfiguration):
    """
    Request configuration details for the FTP monitor type.
    """

    #: A constant which can be used with the ftp_protocol property of a FtpMonitorConfiguration.
    #: This constant has a value of "FTP"
    FTP_PROTOCOL_FTP = "FTP"

    #: A constant which can be used with the ftp_protocol property of a FtpMonitorConfiguration.
    #: This constant has a value of "FTPS"
    FTP_PROTOCOL_FTPS = "FTPS"

    #: A constant which can be used with the ftp_protocol property of a FtpMonitorConfiguration.
    #: This constant has a value of "SFTP"
    FTP_PROTOCOL_SFTP = "SFTP"

    #: A constant which can be used with the ftp_request_type property of a FtpMonitorConfiguration.
    #: This constant has a value of "LIST"
    FTP_REQUEST_TYPE_LIST = "LIST"

    #: A constant which can be used with the ftp_request_type property of a FtpMonitorConfiguration.
    #: This constant has a value of "UPLOAD"
    FTP_REQUEST_TYPE_UPLOAD = "UPLOAD"

    #: A constant which can be used with the ftp_request_type property of a FtpMonitorConfiguration.
    #: This constant has a value of "DOWNLOAD"
    FTP_REQUEST_TYPE_DOWNLOAD = "DOWNLOAD"

    def __init__(self, **kwargs):
        """
        Initializes a new FtpMonitorConfiguration object with values from keyword arguments. The default value of the :py:attr:`~oci.apm_synthetics.models.FtpMonitorConfiguration.config_type` attribute
        of this class is ``FTP_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_type:
            The value to assign to the config_type property of this FtpMonitorConfiguration.
            Allowed values for this property are: "BROWSER_CONFIG", "SCRIPTED_BROWSER_CONFIG", "REST_CONFIG", "SCRIPTED_REST_CONFIG", "NETWORK_CONFIG", "DNS_SERVER_CONFIG", "DNS_TRACE_CONFIG", "DNSSEC_CONFIG", "FTP_CONFIG", "SQL_CONFIG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type config_type: str

        :param is_failure_retried:
            The value to assign to the is_failure_retried property of this FtpMonitorConfiguration.
        :type is_failure_retried: bool

        :param dns_configuration:
            The value to assign to the dns_configuration property of this FtpMonitorConfiguration.
        :type dns_configuration: oci.apm_synthetics.models.DnsConfiguration

        :param ftp_protocol:
            The value to assign to the ftp_protocol property of this FtpMonitorConfiguration.
            Allowed values for this property are: "FTP", "FTPS", "SFTP", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type ftp_protocol: str

        :param ftp_request_type:
            The value to assign to the ftp_request_type property of this FtpMonitorConfiguration.
            Allowed values for this property are: "LIST", "UPLOAD", "DOWNLOAD", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type ftp_request_type: str

        :param is_active_mode:
            The value to assign to the is_active_mode property of this FtpMonitorConfiguration.
        :type is_active_mode: bool

        :param ftp_basic_authentication_details:
            The value to assign to the ftp_basic_authentication_details property of this FtpMonitorConfiguration.
        :type ftp_basic_authentication_details: oci.apm_synthetics.models.BasicAuthenticationDetails

        :param download_size_limit_in_bytes:
            The value to assign to the download_size_limit_in_bytes property of this FtpMonitorConfiguration.
        :type download_size_limit_in_bytes: int

        :param upload_file_size_in_bytes:
            The value to assign to the upload_file_size_in_bytes property of this FtpMonitorConfiguration.
        :type upload_file_size_in_bytes: int

        :param network_configuration:
            The value to assign to the network_configuration property of this FtpMonitorConfiguration.
        :type network_configuration: oci.apm_synthetics.models.NetworkConfiguration

        :param verify_response_codes:
            The value to assign to the verify_response_codes property of this FtpMonitorConfiguration.
        :type verify_response_codes: list[str]

        :param verify_response_content:
            The value to assign to the verify_response_content property of this FtpMonitorConfiguration.
        :type verify_response_content: str

        """
        self.swagger_types = {
            'config_type': 'str',
            'is_failure_retried': 'bool',
            'dns_configuration': 'DnsConfiguration',
            'ftp_protocol': 'str',
            'ftp_request_type': 'str',
            'is_active_mode': 'bool',
            'ftp_basic_authentication_details': 'BasicAuthenticationDetails',
            'download_size_limit_in_bytes': 'int',
            'upload_file_size_in_bytes': 'int',
            'network_configuration': 'NetworkConfiguration',
            'verify_response_codes': 'list[str]',
            'verify_response_content': 'str'
        }
        self.attribute_map = {
            'config_type': 'configType',
            'is_failure_retried': 'isFailureRetried',
            'dns_configuration': 'dnsConfiguration',
            'ftp_protocol': 'ftpProtocol',
            'ftp_request_type': 'ftpRequestType',
            'is_active_mode': 'isActiveMode',
            'ftp_basic_authentication_details': 'ftpBasicAuthenticationDetails',
            'download_size_limit_in_bytes': 'downloadSizeLimitInBytes',
            'upload_file_size_in_bytes': 'uploadFileSizeInBytes',
            'network_configuration': 'networkConfiguration',
            'verify_response_codes': 'verifyResponseCodes',
            'verify_response_content': 'verifyResponseContent'
        }
        self._config_type = None
        self._is_failure_retried = None
        self._dns_configuration = None
        self._ftp_protocol = None
        self._ftp_request_type = None
        self._is_active_mode = None
        self._ftp_basic_authentication_details = None
        self._download_size_limit_in_bytes = None
        self._upload_file_size_in_bytes = None
        self._network_configuration = None
        self._verify_response_codes = None
        self._verify_response_content = None
        self._config_type = 'FTP_CONFIG'

    @property
    def ftp_protocol(self):
        """
        Gets the ftp_protocol of this FtpMonitorConfiguration.
        FTP protocol type.

        Allowed values for this property are: "FTP", "FTPS", "SFTP", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The ftp_protocol of this FtpMonitorConfiguration.
        :rtype: str
        """
        return self._ftp_protocol

    @ftp_protocol.setter
    def ftp_protocol(self, ftp_protocol):
        """
        Sets the ftp_protocol of this FtpMonitorConfiguration.
        FTP protocol type.


        :param ftp_protocol: The ftp_protocol of this FtpMonitorConfiguration.
        :type: str
        """
        allowed_values = ["FTP", "FTPS", "SFTP"]
        if not value_allowed_none_or_none_sentinel(ftp_protocol, allowed_values):
            ftp_protocol = 'UNKNOWN_ENUM_VALUE'
        self._ftp_protocol = ftp_protocol

    @property
    def ftp_request_type(self):
        """
        Gets the ftp_request_type of this FtpMonitorConfiguration.
        FTP monitor request type.

        Allowed values for this property are: "LIST", "UPLOAD", "DOWNLOAD", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The ftp_request_type of this FtpMonitorConfiguration.
        :rtype: str
        """
        return self._ftp_request_type

    @ftp_request_type.setter
    def ftp_request_type(self, ftp_request_type):
        """
        Sets the ftp_request_type of this FtpMonitorConfiguration.
        FTP monitor request type.


        :param ftp_request_type: The ftp_request_type of this FtpMonitorConfiguration.
        :type: str
        """
        allowed_values = ["LIST", "UPLOAD", "DOWNLOAD"]
        if not value_allowed_none_or_none_sentinel(ftp_request_type, allowed_values):
            ftp_request_type = 'UNKNOWN_ENUM_VALUE'
        self._ftp_request_type = ftp_request_type

    @property
    def is_active_mode(self):
        """
        Gets the is_active_mode of this FtpMonitorConfiguration.
        If enabled, Active mode will be used for the FTP connection. Not supported for SFTP protocol.


        :return: The is_active_mode of this FtpMonitorConfiguration.
        :rtype: bool
        """
        return self._is_active_mode

    @is_active_mode.setter
    def is_active_mode(self, is_active_mode):
        """
        Sets the is_active_mode of this FtpMonitorConfiguration.
        If enabled, Active mode will be used for the FTP connection. Not supported for SFTP protocol.


        :param is_active_mode: The is_active_mode of this FtpMonitorConfiguration.
        :type: bool
        """
        self._is_active_mode = is_active_mode

    @property
    def ftp_basic_authentication_details(self):
        """
        Gets the ftp_basic_authentication_details of this FtpMonitorConfiguration.

        :return: The ftp_basic_authentication_details of this FtpMonitorConfiguration.
        :rtype: oci.apm_synthetics.models.BasicAuthenticationDetails
        """
        return self._ftp_basic_authentication_details

    @ftp_basic_authentication_details.setter
    def ftp_basic_authentication_details(self, ftp_basic_authentication_details):
        """
        Sets the ftp_basic_authentication_details of this FtpMonitorConfiguration.

        :param ftp_basic_authentication_details: The ftp_basic_authentication_details of this FtpMonitorConfiguration.
        :type: oci.apm_synthetics.models.BasicAuthenticationDetails
        """
        self._ftp_basic_authentication_details = ftp_basic_authentication_details

    @property
    def download_size_limit_in_bytes(self):
        """
        Gets the download_size_limit_in_bytes of this FtpMonitorConfiguration.
        Download size limit in Bytes, at which to stop the transfer. Maximum download size limit is 5 MiB.


        :return: The download_size_limit_in_bytes of this FtpMonitorConfiguration.
        :rtype: int
        """
        return self._download_size_limit_in_bytes

    @download_size_limit_in_bytes.setter
    def download_size_limit_in_bytes(self, download_size_limit_in_bytes):
        """
        Sets the download_size_limit_in_bytes of this FtpMonitorConfiguration.
        Download size limit in Bytes, at which to stop the transfer. Maximum download size limit is 5 MiB.


        :param download_size_limit_in_bytes: The download_size_limit_in_bytes of this FtpMonitorConfiguration.
        :type: int
        """
        self._download_size_limit_in_bytes = download_size_limit_in_bytes

    @property
    def upload_file_size_in_bytes(self):
        """
        Gets the upload_file_size_in_bytes of this FtpMonitorConfiguration.
        File upload size in Bytes, at which to stop the transfer. Maximum upload size is 5 MiB.


        :return: The upload_file_size_in_bytes of this FtpMonitorConfiguration.
        :rtype: int
        """
        return self._upload_file_size_in_bytes

    @upload_file_size_in_bytes.setter
    def upload_file_size_in_bytes(self, upload_file_size_in_bytes):
        """
        Sets the upload_file_size_in_bytes of this FtpMonitorConfiguration.
        File upload size in Bytes, at which to stop the transfer. Maximum upload size is 5 MiB.


        :param upload_file_size_in_bytes: The upload_file_size_in_bytes of this FtpMonitorConfiguration.
        :type: int
        """
        self._upload_file_size_in_bytes = upload_file_size_in_bytes

    @property
    def network_configuration(self):
        """
        Gets the network_configuration of this FtpMonitorConfiguration.

        :return: The network_configuration of this FtpMonitorConfiguration.
        :rtype: oci.apm_synthetics.models.NetworkConfiguration
        """
        return self._network_configuration

    @network_configuration.setter
    def network_configuration(self, network_configuration):
        """
        Sets the network_configuration of this FtpMonitorConfiguration.

        :param network_configuration: The network_configuration of this FtpMonitorConfiguration.
        :type: oci.apm_synthetics.models.NetworkConfiguration
        """
        self._network_configuration = network_configuration

    @property
    def verify_response_codes(self):
        """
        Gets the verify_response_codes of this FtpMonitorConfiguration.
        Expected FTP response codes. For status code range, set values such as 2xx, 3xx.


        :return: The verify_response_codes of this FtpMonitorConfiguration.
        :rtype: list[str]
        """
        return self._verify_response_codes

    @verify_response_codes.setter
    def verify_response_codes(self, verify_response_codes):
        """
        Sets the verify_response_codes of this FtpMonitorConfiguration.
        Expected FTP response codes. For status code range, set values such as 2xx, 3xx.


        :param verify_response_codes: The verify_response_codes of this FtpMonitorConfiguration.
        :type: list[str]
        """
        self._verify_response_codes = verify_response_codes

    @property
    def verify_response_content(self):
        """
        Gets the verify_response_content of this FtpMonitorConfiguration.
        Verify response content against regular expression based string.
        If response content does not match the verifyResponseContent value, then it will be considered a failure.


        :return: The verify_response_content of this FtpMonitorConfiguration.
        :rtype: str
        """
        return self._verify_response_content

    @verify_response_content.setter
    def verify_response_content(self, verify_response_content):
        """
        Sets the verify_response_content of this FtpMonitorConfiguration.
        Verify response content against regular expression based string.
        If response content does not match the verifyResponseContent value, then it will be considered a failure.


        :param verify_response_content: The verify_response_content of this FtpMonitorConfiguration.
        :type: str
        """
        self._verify_response_content = verify_response_content

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
