# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BulkUnpinMetadata(object):
    """
    Metadata about the bulk unpin operation.  The bulk unpin operation is atomic and binary.  If the processing of any of the attributes
    in the bulk unpin request results in a processing or validation error, then none of the attributes in the request are unpinned.
    """

    #: A constant which can be used with the operation_status property of a BulkUnpinMetadata.
    #: This constant has a value of "SUCCESS"
    OPERATION_STATUS_SUCCESS = "SUCCESS"

    #: A constant which can be used with the operation_status property of a BulkUnpinMetadata.
    #: This constant has a value of "EMPTY_ATTRIBUTE_LIST"
    OPERATION_STATUS_EMPTY_ATTRIBUTE_LIST = "EMPTY_ATTRIBUTE_LIST"

    #: A constant which can be used with the operation_status property of a BulkUnpinMetadata.
    #: This constant has a value of "INVALID_BULK_REQUEST"
    OPERATION_STATUS_INVALID_BULK_REQUEST = "INVALID_BULK_REQUEST"

    #: A constant which can be used with the operation_type property of a BulkUnpinMetadata.
    #: This constant has a value of "UNPIN"
    OPERATION_TYPE_UNPIN = "UNPIN"

    def __init__(self, **kwargs):
        """
        Initializes a new BulkUnpinMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param operation_status:
            The value to assign to the operation_status property of this BulkUnpinMetadata.
            Allowed values for this property are: "SUCCESS", "EMPTY_ATTRIBUTE_LIST", "INVALID_BULK_REQUEST", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type operation_status: str

        :param operation_type:
            The value to assign to the operation_type property of this BulkUnpinMetadata.
            Allowed values for this property are: "UNPIN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type operation_type: str

        :param attributes_unpinned:
            The value to assign to the attributes_unpinned property of this BulkUnpinMetadata.
        :type attributes_unpinned: int

        :param synthetic_attributes_unpinned:
            The value to assign to the synthetic_attributes_unpinned property of this BulkUnpinMetadata.
        :type synthetic_attributes_unpinned: int

        """
        self.swagger_types = {
            'operation_status': 'str',
            'operation_type': 'str',
            'attributes_unpinned': 'int',
            'synthetic_attributes_unpinned': 'int'
        }
        self.attribute_map = {
            'operation_status': 'operationStatus',
            'operation_type': 'operationType',
            'attributes_unpinned': 'attributesUnpinned',
            'synthetic_attributes_unpinned': 'syntheticAttributesUnpinned'
        }
        self._operation_status = None
        self._operation_type = None
        self._attributes_unpinned = None
        self._synthetic_attributes_unpinned = None

    @property
    def operation_status(self):
        """
        **[Required]** Gets the operation_status of this BulkUnpinMetadata.
        Operation status of the bulk unpin operation.
        SUCCESS - The bulk unpin operation has succeeded and all the attributes in the bulk unpin request have been unpinned by this operation.
        The following are error statuses for the bulk unpin operation.
        EMPTY_ATTRIBUTE_LIST - The bulk unpin request object was empty and did not contain any attributes to be unpinned.
        INVALID_BULK_REQUEST - The bulk request contains invalid attribute(s), or attribute(s) that resulted in a validation error, or an attribute that resulted
        in a processing error.

        Allowed values for this property are: "SUCCESS", "EMPTY_ATTRIBUTE_LIST", "INVALID_BULK_REQUEST", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The operation_status of this BulkUnpinMetadata.
        :rtype: str
        """
        return self._operation_status

    @operation_status.setter
    def operation_status(self, operation_status):
        """
        Sets the operation_status of this BulkUnpinMetadata.
        Operation status of the bulk unpin operation.
        SUCCESS - The bulk unpin operation has succeeded and all the attributes in the bulk unpin request have been unpinned by this operation.
        The following are error statuses for the bulk unpin operation.
        EMPTY_ATTRIBUTE_LIST - The bulk unpin request object was empty and did not contain any attributes to be unpinned.
        INVALID_BULK_REQUEST - The bulk request contains invalid attribute(s), or attribute(s) that resulted in a validation error, or an attribute that resulted
        in a processing error.


        :param operation_status: The operation_status of this BulkUnpinMetadata.
        :type: str
        """
        allowed_values = ["SUCCESS", "EMPTY_ATTRIBUTE_LIST", "INVALID_BULK_REQUEST"]
        if not value_allowed_none_or_none_sentinel(operation_status, allowed_values):
            operation_status = 'UNKNOWN_ENUM_VALUE'
        self._operation_status = operation_status

    @property
    def operation_type(self):
        """
        **[Required]** Gets the operation_type of this BulkUnpinMetadata.
        Type of operation.

        Allowed values for this property are: "UNPIN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The operation_type of this BulkUnpinMetadata.
        :rtype: str
        """
        return self._operation_type

    @operation_type.setter
    def operation_type(self, operation_type):
        """
        Sets the operation_type of this BulkUnpinMetadata.
        Type of operation.


        :param operation_type: The operation_type of this BulkUnpinMetadata.
        :type: str
        """
        allowed_values = ["UNPIN"]
        if not value_allowed_none_or_none_sentinel(operation_type, allowed_values):
            operation_type = 'UNKNOWN_ENUM_VALUE'
        self._operation_type = operation_type

    @property
    def attributes_unpinned(self):
        """
        **[Required]** Gets the attributes_unpinned of this BulkUnpinMetadata.
        Total number attributes (both string and numeric) in TRACES namespace that were unpinned.


        :return: The attributes_unpinned of this BulkUnpinMetadata.
        :rtype: int
        """
        return self._attributes_unpinned

    @attributes_unpinned.setter
    def attributes_unpinned(self, attributes_unpinned):
        """
        Sets the attributes_unpinned of this BulkUnpinMetadata.
        Total number attributes (both string and numeric) in TRACES namespace that were unpinned.


        :param attributes_unpinned: The attributes_unpinned of this BulkUnpinMetadata.
        :type: int
        """
        self._attributes_unpinned = attributes_unpinned

    @property
    def synthetic_attributes_unpinned(self):
        """
        Gets the synthetic_attributes_unpinned of this BulkUnpinMetadata.
        Total number attributes (both string and numeric) in SYNTHETIC namespace that were unpinned.


        :return: The synthetic_attributes_unpinned of this BulkUnpinMetadata.
        :rtype: int
        """
        return self._synthetic_attributes_unpinned

    @synthetic_attributes_unpinned.setter
    def synthetic_attributes_unpinned(self, synthetic_attributes_unpinned):
        """
        Sets the synthetic_attributes_unpinned of this BulkUnpinMetadata.
        Total number attributes (both string and numeric) in SYNTHETIC namespace that were unpinned.


        :param synthetic_attributes_unpinned: The synthetic_attributes_unpinned of this BulkUnpinMetadata.
        :type: int
        """
        self._synthetic_attributes_unpinned = synthetic_attributes_unpinned

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
