# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210415

from .security_context import SecurityContext
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LinuxSecurityContext(SecurityContext):
    """
    Security context for Linux container.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LinuxSecurityContext object with values from keyword arguments. The default value of the :py:attr:`~oci.container_instances.models.LinuxSecurityContext.security_context_type` attribute
        of this class is ``LINUX`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param security_context_type:
            The value to assign to the security_context_type property of this LinuxSecurityContext.
            Allowed values for this property are: "LINUX"
        :type security_context_type: str

        :param run_as_user:
            The value to assign to the run_as_user property of this LinuxSecurityContext.
        :type run_as_user: int

        :param run_as_group:
            The value to assign to the run_as_group property of this LinuxSecurityContext.
        :type run_as_group: int

        :param is_non_root_user_check_enabled:
            The value to assign to the is_non_root_user_check_enabled property of this LinuxSecurityContext.
        :type is_non_root_user_check_enabled: bool

        :param is_root_file_system_readonly:
            The value to assign to the is_root_file_system_readonly property of this LinuxSecurityContext.
        :type is_root_file_system_readonly: bool

        :param capabilities:
            The value to assign to the capabilities property of this LinuxSecurityContext.
        :type capabilities: oci.container_instances.models.ContainerCapabilities

        """
        self.swagger_types = {
            'security_context_type': 'str',
            'run_as_user': 'int',
            'run_as_group': 'int',
            'is_non_root_user_check_enabled': 'bool',
            'is_root_file_system_readonly': 'bool',
            'capabilities': 'ContainerCapabilities'
        }
        self.attribute_map = {
            'security_context_type': 'securityContextType',
            'run_as_user': 'runAsUser',
            'run_as_group': 'runAsGroup',
            'is_non_root_user_check_enabled': 'isNonRootUserCheckEnabled',
            'is_root_file_system_readonly': 'isRootFileSystemReadonly',
            'capabilities': 'capabilities'
        }
        self._security_context_type = None
        self._run_as_user = None
        self._run_as_group = None
        self._is_non_root_user_check_enabled = None
        self._is_root_file_system_readonly = None
        self._capabilities = None
        self._security_context_type = 'LINUX'

    @property
    def run_as_user(self):
        """
        Gets the run_as_user of this LinuxSecurityContext.
        The user ID (UID) to run the entrypoint process of the container. Defaults to user specified UID in container image metadata if not provided. This must be provided if runAsGroup is provided.


        :return: The run_as_user of this LinuxSecurityContext.
        :rtype: int
        """
        return self._run_as_user

    @run_as_user.setter
    def run_as_user(self, run_as_user):
        """
        Sets the run_as_user of this LinuxSecurityContext.
        The user ID (UID) to run the entrypoint process of the container. Defaults to user specified UID in container image metadata if not provided. This must be provided if runAsGroup is provided.


        :param run_as_user: The run_as_user of this LinuxSecurityContext.
        :type: int
        """
        self._run_as_user = run_as_user

    @property
    def run_as_group(self):
        """
        Gets the run_as_group of this LinuxSecurityContext.
        The group ID (GID) to run the entrypoint process of the container. Uses runtime default if not provided.


        :return: The run_as_group of this LinuxSecurityContext.
        :rtype: int
        """
        return self._run_as_group

    @run_as_group.setter
    def run_as_group(self, run_as_group):
        """
        Sets the run_as_group of this LinuxSecurityContext.
        The group ID (GID) to run the entrypoint process of the container. Uses runtime default if not provided.


        :param run_as_group: The run_as_group of this LinuxSecurityContext.
        :type: int
        """
        self._run_as_group = run_as_group

    @property
    def is_non_root_user_check_enabled(self):
        """
        Gets the is_non_root_user_check_enabled of this LinuxSecurityContext.
        Indicates if the container must run as a non-root user. If true, the service validates the container image at runtime to ensure that it is not going to run with UID 0 (root) and fails the container instance creation if the validation fails.


        :return: The is_non_root_user_check_enabled of this LinuxSecurityContext.
        :rtype: bool
        """
        return self._is_non_root_user_check_enabled

    @is_non_root_user_check_enabled.setter
    def is_non_root_user_check_enabled(self, is_non_root_user_check_enabled):
        """
        Sets the is_non_root_user_check_enabled of this LinuxSecurityContext.
        Indicates if the container must run as a non-root user. If true, the service validates the container image at runtime to ensure that it is not going to run with UID 0 (root) and fails the container instance creation if the validation fails.


        :param is_non_root_user_check_enabled: The is_non_root_user_check_enabled of this LinuxSecurityContext.
        :type: bool
        """
        self._is_non_root_user_check_enabled = is_non_root_user_check_enabled

    @property
    def is_root_file_system_readonly(self):
        """
        Gets the is_root_file_system_readonly of this LinuxSecurityContext.
        Determines if the container will have a read-only root file system. Default value is false.


        :return: The is_root_file_system_readonly of this LinuxSecurityContext.
        :rtype: bool
        """
        return self._is_root_file_system_readonly

    @is_root_file_system_readonly.setter
    def is_root_file_system_readonly(self, is_root_file_system_readonly):
        """
        Sets the is_root_file_system_readonly of this LinuxSecurityContext.
        Determines if the container will have a read-only root file system. Default value is false.


        :param is_root_file_system_readonly: The is_root_file_system_readonly of this LinuxSecurityContext.
        :type: bool
        """
        self._is_root_file_system_readonly = is_root_file_system_readonly

    @property
    def capabilities(self):
        """
        Gets the capabilities of this LinuxSecurityContext.

        :return: The capabilities of this LinuxSecurityContext.
        :rtype: oci.container_instances.models.ContainerCapabilities
        """
        return self._capabilities

    @capabilities.setter
    def capabilities(self, capabilities):
        """
        Sets the capabilities of this LinuxSecurityContext.

        :param capabilities: The capabilities of this LinuxSecurityContext.
        :type: oci.container_instances.models.ContainerCapabilities
        """
        self._capabilities = capabilities

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
