# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CapacityBin(object):
    """
    Total and remaining CPU & memory capacity for each capacity bucket.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CapacityBin object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param capacity_index:
            The value to assign to the capacity_index property of this CapacityBin.
        :type capacity_index: int

        :param total_ocpus:
            The value to assign to the total_ocpus property of this CapacityBin.
        :type total_ocpus: float

        :param remaining_ocpus:
            The value to assign to the remaining_ocpus property of this CapacityBin.
        :type remaining_ocpus: float

        :param total_memory_in_gbs:
            The value to assign to the total_memory_in_gbs property of this CapacityBin.
        :type total_memory_in_gbs: float

        :param remaining_memory_in_gbs:
            The value to assign to the remaining_memory_in_gbs property of this CapacityBin.
        :type remaining_memory_in_gbs: float

        :param supported_shapes:
            The value to assign to the supported_shapes property of this CapacityBin.
        :type supported_shapes: list[str]

        """
        self.swagger_types = {
            'capacity_index': 'int',
            'total_ocpus': 'float',
            'remaining_ocpus': 'float',
            'total_memory_in_gbs': 'float',
            'remaining_memory_in_gbs': 'float',
            'supported_shapes': 'list[str]'
        }
        self.attribute_map = {
            'capacity_index': 'capacityIndex',
            'total_ocpus': 'totalOcpus',
            'remaining_ocpus': 'remainingOcpus',
            'total_memory_in_gbs': 'totalMemoryInGBs',
            'remaining_memory_in_gbs': 'remainingMemoryInGBs',
            'supported_shapes': 'supportedShapes'
        }
        self._capacity_index = None
        self._total_ocpus = None
        self._remaining_ocpus = None
        self._total_memory_in_gbs = None
        self._remaining_memory_in_gbs = None
        self._supported_shapes = None

    @property
    def capacity_index(self):
        """
        **[Required]** Gets the capacity_index of this CapacityBin.
        Zero-based index for the corresponding capacity bucket.


        :return: The capacity_index of this CapacityBin.
        :rtype: int
        """
        return self._capacity_index

    @capacity_index.setter
    def capacity_index(self, capacity_index):
        """
        Sets the capacity_index of this CapacityBin.
        Zero-based index for the corresponding capacity bucket.


        :param capacity_index: The capacity_index of this CapacityBin.
        :type: int
        """
        self._capacity_index = capacity_index

    @property
    def total_ocpus(self):
        """
        **[Required]** Gets the total_ocpus of this CapacityBin.
        The total OCPUs of the capacity bucket.


        :return: The total_ocpus of this CapacityBin.
        :rtype: float
        """
        return self._total_ocpus

    @total_ocpus.setter
    def total_ocpus(self, total_ocpus):
        """
        Sets the total_ocpus of this CapacityBin.
        The total OCPUs of the capacity bucket.


        :param total_ocpus: The total_ocpus of this CapacityBin.
        :type: float
        """
        self._total_ocpus = total_ocpus

    @property
    def remaining_ocpus(self):
        """
        **[Required]** Gets the remaining_ocpus of this CapacityBin.
        The available OCPUs of the capacity bucket.


        :return: The remaining_ocpus of this CapacityBin.
        :rtype: float
        """
        return self._remaining_ocpus

    @remaining_ocpus.setter
    def remaining_ocpus(self, remaining_ocpus):
        """
        Sets the remaining_ocpus of this CapacityBin.
        The available OCPUs of the capacity bucket.


        :param remaining_ocpus: The remaining_ocpus of this CapacityBin.
        :type: float
        """
        self._remaining_ocpus = remaining_ocpus

    @property
    def total_memory_in_gbs(self):
        """
        **[Required]** Gets the total_memory_in_gbs of this CapacityBin.
        The total memory of the capacity bucket, in GBs.


        :return: The total_memory_in_gbs of this CapacityBin.
        :rtype: float
        """
        return self._total_memory_in_gbs

    @total_memory_in_gbs.setter
    def total_memory_in_gbs(self, total_memory_in_gbs):
        """
        Sets the total_memory_in_gbs of this CapacityBin.
        The total memory of the capacity bucket, in GBs.


        :param total_memory_in_gbs: The total_memory_in_gbs of this CapacityBin.
        :type: float
        """
        self._total_memory_in_gbs = total_memory_in_gbs

    @property
    def remaining_memory_in_gbs(self):
        """
        **[Required]** Gets the remaining_memory_in_gbs of this CapacityBin.
        The remaining memory of the capacity bucket, in GBs.


        :return: The remaining_memory_in_gbs of this CapacityBin.
        :rtype: float
        """
        return self._remaining_memory_in_gbs

    @remaining_memory_in_gbs.setter
    def remaining_memory_in_gbs(self, remaining_memory_in_gbs):
        """
        Sets the remaining_memory_in_gbs of this CapacityBin.
        The remaining memory of the capacity bucket, in GBs.


        :param remaining_memory_in_gbs: The remaining_memory_in_gbs of this CapacityBin.
        :type: float
        """
        self._remaining_memory_in_gbs = remaining_memory_in_gbs

    @property
    def supported_shapes(self):
        """
        **[Required]** Gets the supported_shapes of this CapacityBin.
        List of VMI shapes supported on each capacity bucket.


        :return: The supported_shapes of this CapacityBin.
        :rtype: list[str]
        """
        return self._supported_shapes

    @supported_shapes.setter
    def supported_shapes(self, supported_shapes):
        """
        Sets the supported_shapes of this CapacityBin.
        List of VMI shapes supported on each capacity bucket.


        :param supported_shapes: The supported_shapes of this CapacityBin.
        :type: list[str]
        """
        self._supported_shapes = supported_shapes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
