# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SecurityAssessmentTemplateDetails(object):
    """
    The details required to set the template for the assessment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SecurityAssessmentTemplateDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param template_assessment_id:
            The value to assign to the template_assessment_id property of this SecurityAssessmentTemplateDetails.
        :type template_assessment_id: str

        """
        self.swagger_types = {
            'template_assessment_id': 'str'
        }
        self.attribute_map = {
            'template_assessment_id': 'templateAssessmentId'
        }
        self._template_assessment_id = None

    @property
    def template_assessment_id(self):
        """
        Gets the template_assessment_id of this SecurityAssessmentTemplateDetails.
        The OCID of the template type security assessment containing the check details.


        :return: The template_assessment_id of this SecurityAssessmentTemplateDetails.
        :rtype: str
        """
        return self._template_assessment_id

    @template_assessment_id.setter
    def template_assessment_id(self, template_assessment_id):
        """
        Sets the template_assessment_id of this SecurityAssessmentTemplateDetails.
        The OCID of the template type security assessment containing the check details.


        :param template_assessment_id: The template_assessment_id of this SecurityAssessmentTemplateDetails.
        :type: str
        """
        self._template_assessment_id = template_assessment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
