# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TargetOverrideCollection(object):
    """
    Collection of target override summary.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TargetOverrideCollection object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param targets_count:
            The value to assign to the targets_count property of this TargetOverrideCollection.
        :type targets_count: int

        :param targets_overriding_count:
            The value to assign to the targets_overriding_count property of this TargetOverrideCollection.
        :type targets_overriding_count: int

        :param targets_conforming_count:
            The value to assign to the targets_conforming_count property of this TargetOverrideCollection.
        :type targets_conforming_count: int

        :param targets_overriding_paid_usage_count:
            The value to assign to the targets_overriding_paid_usage_count property of this TargetOverrideCollection.
        :type targets_overriding_paid_usage_count: int

        :param targets_overriding_online_months_count:
            The value to assign to the targets_overriding_online_months_count property of this TargetOverrideCollection.
        :type targets_overriding_online_months_count: int

        :param targets_overriding_offline_months_count:
            The value to assign to the targets_overriding_offline_months_count property of this TargetOverrideCollection.
        :type targets_overriding_offline_months_count: int

        :param items:
            The value to assign to the items property of this TargetOverrideCollection.
        :type items: list[oci.data_safe.models.TargetOverrideSummary]

        """
        self.swagger_types = {
            'targets_count': 'int',
            'targets_overriding_count': 'int',
            'targets_conforming_count': 'int',
            'targets_overriding_paid_usage_count': 'int',
            'targets_overriding_online_months_count': 'int',
            'targets_overriding_offline_months_count': 'int',
            'items': 'list[TargetOverrideSummary]'
        }
        self.attribute_map = {
            'targets_count': 'targetsCount',
            'targets_overriding_count': 'targetsOverridingCount',
            'targets_conforming_count': 'targetsConformingCount',
            'targets_overriding_paid_usage_count': 'targetsOverridingPaidUsageCount',
            'targets_overriding_online_months_count': 'targetsOverridingOnlineMonthsCount',
            'targets_overriding_offline_months_count': 'targetsOverridingOfflineMonthsCount',
            'items': 'items'
        }
        self._targets_count = None
        self._targets_overriding_count = None
        self._targets_conforming_count = None
        self._targets_overriding_paid_usage_count = None
        self._targets_overriding_online_months_count = None
        self._targets_overriding_offline_months_count = None
        self._items = None

    @property
    def targets_count(self):
        """
        **[Required]** Gets the targets_count of this TargetOverrideCollection.
        Number of target databases within the target database group.


        :return: The targets_count of this TargetOverrideCollection.
        :rtype: int
        """
        return self._targets_count

    @targets_count.setter
    def targets_count(self, targets_count):
        """
        Sets the targets_count of this TargetOverrideCollection.
        Number of target databases within the target database group.


        :param targets_count: The targets_count of this TargetOverrideCollection.
        :type: int
        """
        self._targets_count = targets_count

    @property
    def targets_overriding_count(self):
        """
        **[Required]** Gets the targets_overriding_count of this TargetOverrideCollection.
        Number of target databases within the target database group that override the audit profile of the target database group.


        :return: The targets_overriding_count of this TargetOverrideCollection.
        :rtype: int
        """
        return self._targets_overriding_count

    @targets_overriding_count.setter
    def targets_overriding_count(self, targets_overriding_count):
        """
        Sets the targets_overriding_count of this TargetOverrideCollection.
        Number of target databases within the target database group that override the audit profile of the target database group.


        :param targets_overriding_count: The targets_overriding_count of this TargetOverrideCollection.
        :type: int
        """
        self._targets_overriding_count = targets_overriding_count

    @property
    def targets_conforming_count(self):
        """
        **[Required]** Gets the targets_conforming_count of this TargetOverrideCollection.
        Number of target databases within the target database group that conform with the audit profile of the target database group.


        :return: The targets_conforming_count of this TargetOverrideCollection.
        :rtype: int
        """
        return self._targets_conforming_count

    @targets_conforming_count.setter
    def targets_conforming_count(self, targets_conforming_count):
        """
        Sets the targets_conforming_count of this TargetOverrideCollection.
        Number of target databases within the target database group that conform with the audit profile of the target database group.


        :param targets_conforming_count: The targets_conforming_count of this TargetOverrideCollection.
        :type: int
        """
        self._targets_conforming_count = targets_conforming_count

    @property
    def targets_overriding_paid_usage_count(self):
        """
        **[Required]** Gets the targets_overriding_paid_usage_count of this TargetOverrideCollection.
        Number of target databases within the group that override the paid usage setting of the audit profile for the target database group.


        :return: The targets_overriding_paid_usage_count of this TargetOverrideCollection.
        :rtype: int
        """
        return self._targets_overriding_paid_usage_count

    @targets_overriding_paid_usage_count.setter
    def targets_overriding_paid_usage_count(self, targets_overriding_paid_usage_count):
        """
        Sets the targets_overriding_paid_usage_count of this TargetOverrideCollection.
        Number of target databases within the group that override the paid usage setting of the audit profile for the target database group.


        :param targets_overriding_paid_usage_count: The targets_overriding_paid_usage_count of this TargetOverrideCollection.
        :type: int
        """
        self._targets_overriding_paid_usage_count = targets_overriding_paid_usage_count

    @property
    def targets_overriding_online_months_count(self):
        """
        **[Required]** Gets the targets_overriding_online_months_count of this TargetOverrideCollection.
        Number of target databases within the group that override the online retention setting of the audit profile for the target database group.


        :return: The targets_overriding_online_months_count of this TargetOverrideCollection.
        :rtype: int
        """
        return self._targets_overriding_online_months_count

    @targets_overriding_online_months_count.setter
    def targets_overriding_online_months_count(self, targets_overriding_online_months_count):
        """
        Sets the targets_overriding_online_months_count of this TargetOverrideCollection.
        Number of target databases within the group that override the online retention setting of the audit profile for the target database group.


        :param targets_overriding_online_months_count: The targets_overriding_online_months_count of this TargetOverrideCollection.
        :type: int
        """
        self._targets_overriding_online_months_count = targets_overriding_online_months_count

    @property
    def targets_overriding_offline_months_count(self):
        """
        **[Required]** Gets the targets_overriding_offline_months_count of this TargetOverrideCollection.
        Number of target databases within the group that override the offline retention setting of the audit profile for the target database group.


        :return: The targets_overriding_offline_months_count of this TargetOverrideCollection.
        :rtype: int
        """
        return self._targets_overriding_offline_months_count

    @targets_overriding_offline_months_count.setter
    def targets_overriding_offline_months_count(self, targets_overriding_offline_months_count):
        """
        Sets the targets_overriding_offline_months_count of this TargetOverrideCollection.
        Number of target databases within the group that override the offline retention setting of the audit profile for the target database group.


        :param targets_overriding_offline_months_count: The targets_overriding_offline_months_count of this TargetOverrideCollection.
        :type: int
        """
        self._targets_overriding_offline_months_count = targets_overriding_offline_months_count

    @property
    def items(self):
        """
        **[Required]** Gets the items of this TargetOverrideCollection.
        Array of target database override summary.


        :return: The items of this TargetOverrideCollection.
        :rtype: list[oci.data_safe.models.TargetOverrideSummary]
        """
        return self._items

    @items.setter
    def items(self, items):
        """
        Sets the items of this TargetOverrideCollection.
        Array of target database override summary.


        :param items: The items of this TargetOverrideCollection.
        :type: list[oci.data_safe.models.TargetOverrideSummary]
        """
        self._items = items

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
