# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NotebookSessionShapeConfigDetails(object):
    """
    Details for the notebook session shape configuration.
    """

    #: A constant which can be used with the cpu_baseline property of a NotebookSessionShapeConfigDetails.
    #: This constant has a value of "BASELINE_1_8"
    CPU_BASELINE_BASELINE_1_8 = "BASELINE_1_8"

    #: A constant which can be used with the cpu_baseline property of a NotebookSessionShapeConfigDetails.
    #: This constant has a value of "BASELINE_1_2"
    CPU_BASELINE_BASELINE_1_2 = "BASELINE_1_2"

    #: A constant which can be used with the cpu_baseline property of a NotebookSessionShapeConfigDetails.
    #: This constant has a value of "BASELINE_1_1"
    CPU_BASELINE_BASELINE_1_1 = "BASELINE_1_1"

    def __init__(self, **kwargs):
        """
        Initializes a new NotebookSessionShapeConfigDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ocpus:
            The value to assign to the ocpus property of this NotebookSessionShapeConfigDetails.
        :type ocpus: float

        :param memory_in_gbs:
            The value to assign to the memory_in_gbs property of this NotebookSessionShapeConfigDetails.
        :type memory_in_gbs: float

        :param cpu_baseline:
            The value to assign to the cpu_baseline property of this NotebookSessionShapeConfigDetails.
            Allowed values for this property are: "BASELINE_1_8", "BASELINE_1_2", "BASELINE_1_1", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type cpu_baseline: str

        """
        self.swagger_types = {
            'ocpus': 'float',
            'memory_in_gbs': 'float',
            'cpu_baseline': 'str'
        }
        self.attribute_map = {
            'ocpus': 'ocpus',
            'memory_in_gbs': 'memoryInGBs',
            'cpu_baseline': 'cpuBaseline'
        }
        self._ocpus = None
        self._memory_in_gbs = None
        self._cpu_baseline = None

    @property
    def ocpus(self):
        """
        Gets the ocpus of this NotebookSessionShapeConfigDetails.
        The total number of OCPUs available to the notebook session instance.


        :return: The ocpus of this NotebookSessionShapeConfigDetails.
        :rtype: float
        """
        return self._ocpus

    @ocpus.setter
    def ocpus(self, ocpus):
        """
        Sets the ocpus of this NotebookSessionShapeConfigDetails.
        The total number of OCPUs available to the notebook session instance.


        :param ocpus: The ocpus of this NotebookSessionShapeConfigDetails.
        :type: float
        """
        self._ocpus = ocpus

    @property
    def memory_in_gbs(self):
        """
        Gets the memory_in_gbs of this NotebookSessionShapeConfigDetails.
        The total amount of memory available to the notebook session instance, in gigabytes.


        :return: The memory_in_gbs of this NotebookSessionShapeConfigDetails.
        :rtype: float
        """
        return self._memory_in_gbs

    @memory_in_gbs.setter
    def memory_in_gbs(self, memory_in_gbs):
        """
        Sets the memory_in_gbs of this NotebookSessionShapeConfigDetails.
        The total amount of memory available to the notebook session instance, in gigabytes.


        :param memory_in_gbs: The memory_in_gbs of this NotebookSessionShapeConfigDetails.
        :type: float
        """
        self._memory_in_gbs = memory_in_gbs

    @property
    def cpu_baseline(self):
        """
        Gets the cpu_baseline of this NotebookSessionShapeConfigDetails.
        The baseline OCPU utilization for a subcore burstable VM instance. If this attribute is left bank, it will default to `BASELINE_1_1`.
        The following values are supported:
          BASELINE_1_8 - baseline usage is 1/8 of an OCPU.
          BASELINE_1_2 - baseline usage is 1/2 of an OCPU.
          BASELINE_1_1 - baseline usage is an entire OCPU. This represents a non-burstable instance.

        Allowed values for this property are: "BASELINE_1_8", "BASELINE_1_2", "BASELINE_1_1", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The cpu_baseline of this NotebookSessionShapeConfigDetails.
        :rtype: str
        """
        return self._cpu_baseline

    @cpu_baseline.setter
    def cpu_baseline(self, cpu_baseline):
        """
        Sets the cpu_baseline of this NotebookSessionShapeConfigDetails.
        The baseline OCPU utilization for a subcore burstable VM instance. If this attribute is left bank, it will default to `BASELINE_1_1`.
        The following values are supported:
          BASELINE_1_8 - baseline usage is 1/8 of an OCPU.
          BASELINE_1_2 - baseline usage is 1/2 of an OCPU.
          BASELINE_1_1 - baseline usage is an entire OCPU. This represents a non-burstable instance.


        :param cpu_baseline: The cpu_baseline of this NotebookSessionShapeConfigDetails.
        :type: str
        """
        allowed_values = ["BASELINE_1_8", "BASELINE_1_2", "BASELINE_1_1"]
        if not value_allowed_none_or_none_sentinel(cpu_baseline, allowed_values):
            cpu_baseline = 'UNKNOWN_ENUM_VALUE'
        self._cpu_baseline = cpu_baseline

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
