# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ActionMember(object):
    """
    The details of an action member.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ActionMember object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param member_order:
            The value to assign to the member_order property of this ActionMember.
        :type member_order: int

        :param member_id:
            The value to assign to the member_id property of this ActionMember.
        :type member_id: str

        :param estimated_time_in_mins:
            The value to assign to the estimated_time_in_mins property of this ActionMember.
        :type estimated_time_in_mins: int

        """
        self.swagger_types = {
            'member_order': 'int',
            'member_id': 'str',
            'estimated_time_in_mins': 'int'
        }
        self.attribute_map = {
            'member_order': 'memberOrder',
            'member_id': 'memberId',
            'estimated_time_in_mins': 'estimatedTimeInMins'
        }
        self._member_order = None
        self._member_id = None
        self._estimated_time_in_mins = None

    @property
    def member_order(self):
        """
        **[Required]** Gets the member_order of this ActionMember.
        The order of the action member in a scheduled action.


        :return: The member_order of this ActionMember.
        :rtype: int
        """
        return self._member_order

    @member_order.setter
    def member_order(self, member_order):
        """
        Sets the member_order of this ActionMember.
        The order of the action member in a scheduled action.


        :param member_order: The member_order of this ActionMember.
        :type: int
        """
        self._member_order = member_order

    @property
    def member_id(self):
        """
        **[Required]** Gets the member_id of this ActionMember.
        The ocid of the action member.


        :return: The member_id of this ActionMember.
        :rtype: str
        """
        return self._member_id

    @member_id.setter
    def member_id(self, member_id):
        """
        Sets the member_id of this ActionMember.
        The ocid of the action member.


        :param member_id: The member_id of this ActionMember.
        :type: str
        """
        self._member_id = member_id

    @property
    def estimated_time_in_mins(self):
        """
        Gets the estimated_time_in_mins of this ActionMember.
        The estimated time for the intended action member.


        :return: The estimated_time_in_mins of this ActionMember.
        :rtype: int
        """
        return self._estimated_time_in_mins

    @estimated_time_in_mins.setter
    def estimated_time_in_mins(self, estimated_time_in_mins):
        """
        Sets the estimated_time_in_mins of this ActionMember.
        The estimated time for the intended action member.


        :param estimated_time_in_mins: The estimated_time_in_mins of this ActionMember.
        :type: int
        """
        self._estimated_time_in_mins = estimated_time_in_mins

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
