# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .autonomous_database_encryption_key_details import AutonomousDatabaseEncryptionKeyDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GcpKeyDetails(AutonomousDatabaseEncryptionKeyDetails):
    """
    Details for GCP encryption key.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GcpKeyDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database.models.GcpKeyDetails.provider` attribute
        of this class is ``GCP`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param provider:
            The value to assign to the provider property of this GcpKeyDetails.
            Allowed values for this property are: "AWS", "AZURE", "OCI", "ORACLE_MANAGED", "OKV"
        :type provider: str

        :param key_name:
            The value to assign to the key_name property of this GcpKeyDetails.
        :type key_name: str

        :param kms_rest_endpoint:
            The value to assign to the kms_rest_endpoint property of this GcpKeyDetails.
        :type kms_rest_endpoint: str

        :param project:
            The value to assign to the project property of this GcpKeyDetails.
        :type project: str

        :param location:
            The value to assign to the location property of this GcpKeyDetails.
        :type location: str

        :param key_ring:
            The value to assign to the key_ring property of this GcpKeyDetails.
        :type key_ring: str

        """
        self.swagger_types = {
            'provider': 'str',
            'key_name': 'str',
            'kms_rest_endpoint': 'str',
            'project': 'str',
            'location': 'str',
            'key_ring': 'str'
        }
        self.attribute_map = {
            'provider': 'provider',
            'key_name': 'keyName',
            'kms_rest_endpoint': 'kmsRestEndpoint',
            'project': 'project',
            'location': 'location',
            'key_ring': 'keyRing'
        }
        self._provider = None
        self._key_name = None
        self._kms_rest_endpoint = None
        self._project = None
        self._location = None
        self._key_ring = None
        self._provider = 'GCP'

    @property
    def key_name(self):
        """
        **[Required]** Gets the key_name of this GcpKeyDetails.
        GCP key name


        :return: The key_name of this GcpKeyDetails.
        :rtype: str
        """
        return self._key_name

    @key_name.setter
    def key_name(self, key_name):
        """
        Sets the key_name of this GcpKeyDetails.
        GCP key name


        :param key_name: The key_name of this GcpKeyDetails.
        :type: str
        """
        self._key_name = key_name

    @property
    def kms_rest_endpoint(self):
        """
        Gets the kms_rest_endpoint of this GcpKeyDetails.
        GCP kms REST API endpoint


        :return: The kms_rest_endpoint of this GcpKeyDetails.
        :rtype: str
        """
        return self._kms_rest_endpoint

    @kms_rest_endpoint.setter
    def kms_rest_endpoint(self, kms_rest_endpoint):
        """
        Sets the kms_rest_endpoint of this GcpKeyDetails.
        GCP kms REST API endpoint


        :param kms_rest_endpoint: The kms_rest_endpoint of this GcpKeyDetails.
        :type: str
        """
        self._kms_rest_endpoint = kms_rest_endpoint

    @property
    def project(self):
        """
        **[Required]** Gets the project of this GcpKeyDetails.
        GCP project name


        :return: The project of this GcpKeyDetails.
        :rtype: str
        """
        return self._project

    @project.setter
    def project(self, project):
        """
        Sets the project of this GcpKeyDetails.
        GCP project name


        :param project: The project of this GcpKeyDetails.
        :type: str
        """
        self._project = project

    @property
    def location(self):
        """
        **[Required]** Gets the location of this GcpKeyDetails.
        GCP key ring location


        :return: The location of this GcpKeyDetails.
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the location of this GcpKeyDetails.
        GCP key ring location


        :param location: The location of this GcpKeyDetails.
        :type: str
        """
        self._location = location

    @property
    def key_ring(self):
        """
        **[Required]** Gets the key_ring of this GcpKeyDetails.
        GCP key ring


        :return: The key_ring of this GcpKeyDetails.
        :rtype: str
        """
        return self._key_ring

    @key_ring.setter
    def key_ring(self, key_ring):
        """
        Sets the key_ring of this GcpKeyDetails.
        GCP key ring


        :param key_ring: The key_ring of this GcpKeyDetails.
        :type: str
        """
        self._key_ring = key_ring

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
