# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .set_key_version_details import SetKeyVersionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciProviderSetKeyVersionDetails(SetKeyVersionDetails):
    """
    Used for setting KMS key versions
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OciProviderSetKeyVersionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database.models.OciProviderSetKeyVersionDetails.provider` attribute
        of this class is ``OCI`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param provider:
            The value to assign to the provider property of this OciProviderSetKeyVersionDetails.
            Allowed values for this property are: "OCI"
        :type provider: str

        :param kms_key_version_id:
            The value to assign to the kms_key_version_id property of this OciProviderSetKeyVersionDetails.
        :type kms_key_version_id: str

        """
        self.swagger_types = {
            'provider': 'str',
            'kms_key_version_id': 'str'
        }
        self.attribute_map = {
            'provider': 'provider',
            'kms_key_version_id': 'kmsKeyVersionId'
        }
        self._provider = None
        self._kms_key_version_id = None
        self._provider = 'OCI'

    @property
    def kms_key_version_id(self):
        """
        **[Required]** Gets the kms_key_version_id of this OciProviderSetKeyVersionDetails.
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.


        :return: The kms_key_version_id of this OciProviderSetKeyVersionDetails.
        :rtype: str
        """
        return self._kms_key_version_id

    @kms_key_version_id.setter
    def kms_key_version_id(self, kms_key_version_id):
        """
        Sets the kms_key_version_id of this OciProviderSetKeyVersionDetails.
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation. Autonomous Database Serverless does not use key versions, hence is not applicable for Autonomous Database Serverless instances.


        :param kms_key_version_id: The kms_key_version_id of this OciProviderSetKeyVersionDetails.
        :type: str
        """
        self._kms_key_version_id = kms_key_version_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
