# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateExternalMySqlDatabaseConnectorDetails(object):
    """
    Details for creating an external database connector.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateExternalMySqlDatabaseConnectorDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateExternalMySqlDatabaseConnectorDetails.
        :type compartment_id: str

        :param connector_details:
            The value to assign to the connector_details property of this CreateExternalMySqlDatabaseConnectorDetails.
        :type connector_details: oci.database_management.models.CreateMySqlDatabaseConnectorDetails

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'connector_details': 'CreateMySqlDatabaseConnectorDetails'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'connector_details': 'connectorDetails'
        }
        self._compartment_id = None
        self._connector_details = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateExternalMySqlDatabaseConnectorDetails.
        OCID of compartment for the External MySQL Database.


        :return: The compartment_id of this CreateExternalMySqlDatabaseConnectorDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateExternalMySqlDatabaseConnectorDetails.
        OCID of compartment for the External MySQL Database.


        :param compartment_id: The compartment_id of this CreateExternalMySqlDatabaseConnectorDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def connector_details(self):
        """
        **[Required]** Gets the connector_details of this CreateExternalMySqlDatabaseConnectorDetails.

        :return: The connector_details of this CreateExternalMySqlDatabaseConnectorDetails.
        :rtype: oci.database_management.models.CreateMySqlDatabaseConnectorDetails
        """
        return self._connector_details

    @connector_details.setter
    def connector_details(self, connector_details):
        """
        Sets the connector_details of this CreateExternalMySqlDatabaseConnectorDetails.

        :param connector_details: The connector_details of this CreateExternalMySqlDatabaseConnectorDetails.
        :type: oci.database_management.models.CreateMySqlDatabaseConnectorDetails
        """
        self._connector_details = connector_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
