# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManagedMySqlDatabaseGeneralReplicationInformation(object):
    """
    General information about the replication of a MySQL server.
    """

    #: A constant which can be used with the read_only property of a ManagedMySqlDatabaseGeneralReplicationInformation.
    #: This constant has a value of "ON"
    READ_ONLY_ON = "ON"

    #: A constant which can be used with the read_only property of a ManagedMySqlDatabaseGeneralReplicationInformation.
    #: This constant has a value of "SUPER"
    READ_ONLY_SUPER = "SUPER"

    #: A constant which can be used with the read_only property of a ManagedMySqlDatabaseGeneralReplicationInformation.
    #: This constant has a value of "OFF"
    READ_ONLY_OFF = "OFF"

    def __init__(self, **kwargs):
        """
        Initializes a new ManagedMySqlDatabaseGeneralReplicationInformation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_type:
            The value to assign to the instance_type property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type instance_type: str

        :param host_name:
            The value to assign to the host_name property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type host_name: str

        :param port:
            The value to assign to the port property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type port: int

        :param server_id:
            The value to assign to the server_id property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type server_id: int

        :param server_uuid:
            The value to assign to the server_uuid property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type server_uuid: str

        :param seconds_behind_source_max:
            The value to assign to the seconds_behind_source_max property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type seconds_behind_source_max: int

        :param fetch_status_summary:
            The value to assign to the fetch_status_summary property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type fetch_status_summary: str

        :param apply_status_summary:
            The value to assign to the apply_status_summary property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type apply_status_summary: str

        :param is_high_availability_enabled:
            The value to assign to the is_high_availability_enabled property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type is_high_availability_enabled: bool

        :param high_availability_member_state:
            The value to assign to the high_availability_member_state property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type high_availability_member_state: str

        :param inbound_replications_count:
            The value to assign to the inbound_replications_count property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type inbound_replications_count: int

        :param read_only:
            The value to assign to the read_only property of this ManagedMySqlDatabaseGeneralReplicationInformation.
            Allowed values for this property are: "ON", "SUPER", "OFF", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type read_only: str

        :param gtid_mode:
            The value to assign to the gtid_mode property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type gtid_mode: str

        :param executed_gtid_set:
            The value to assign to the executed_gtid_set property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type executed_gtid_set: str

        :param binary_logging:
            The value to assign to the binary_logging property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type binary_logging: str

        :param binary_log_format:
            The value to assign to the binary_log_format property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type binary_log_format: str

        :param outbound_replications_count:
            The value to assign to the outbound_replications_count property of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type outbound_replications_count: int

        """
        self.swagger_types = {
            'instance_type': 'str',
            'host_name': 'str',
            'port': 'int',
            'server_id': 'int',
            'server_uuid': 'str',
            'seconds_behind_source_max': 'int',
            'fetch_status_summary': 'str',
            'apply_status_summary': 'str',
            'is_high_availability_enabled': 'bool',
            'high_availability_member_state': 'str',
            'inbound_replications_count': 'int',
            'read_only': 'str',
            'gtid_mode': 'str',
            'executed_gtid_set': 'str',
            'binary_logging': 'str',
            'binary_log_format': 'str',
            'outbound_replications_count': 'int'
        }
        self.attribute_map = {
            'instance_type': 'instanceType',
            'host_name': 'hostName',
            'port': 'port',
            'server_id': 'serverId',
            'server_uuid': 'serverUuid',
            'seconds_behind_source_max': 'secondsBehindSourceMax',
            'fetch_status_summary': 'fetchStatusSummary',
            'apply_status_summary': 'applyStatusSummary',
            'is_high_availability_enabled': 'isHighAvailabilityEnabled',
            'high_availability_member_state': 'highAvailabilityMemberState',
            'inbound_replications_count': 'inboundReplicationsCount',
            'read_only': 'readOnly',
            'gtid_mode': 'gtidMode',
            'executed_gtid_set': 'executedGtidSet',
            'binary_logging': 'binaryLogging',
            'binary_log_format': 'binaryLogFormat',
            'outbound_replications_count': 'outboundReplicationsCount'
        }
        self._instance_type = None
        self._host_name = None
        self._port = None
        self._server_id = None
        self._server_uuid = None
        self._seconds_behind_source_max = None
        self._fetch_status_summary = None
        self._apply_status_summary = None
        self._is_high_availability_enabled = None
        self._high_availability_member_state = None
        self._inbound_replications_count = None
        self._read_only = None
        self._gtid_mode = None
        self._executed_gtid_set = None
        self._binary_logging = None
        self._binary_log_format = None
        self._outbound_replications_count = None

    @property
    def instance_type(self):
        """
        Gets the instance_type of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The type of the instance for example, Source, Replica, Primary Group Member, and Secondary Group Member. If the instance is replicating from one or more sources and has one or more replicas, which means, it belongs to a replication chain, the instance type can be Replica/Source.


        :return: The instance_type of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: str
        """
        return self._instance_type

    @instance_type.setter
    def instance_type(self, instance_type):
        """
        Sets the instance_type of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The type of the instance for example, Source, Replica, Primary Group Member, and Secondary Group Member. If the instance is replicating from one or more sources and has one or more replicas, which means, it belongs to a replication chain, the instance type can be Replica/Source.


        :param instance_type: The instance_type of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: str
        """
        self._instance_type = instance_type

    @property
    def host_name(self):
        """
        Gets the host_name of this ManagedMySqlDatabaseGeneralReplicationInformation.
        This server's host name.


        :return: The host_name of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: str
        """
        return self._host_name

    @host_name.setter
    def host_name(self, host_name):
        """
        Sets the host_name of this ManagedMySqlDatabaseGeneralReplicationInformation.
        This server's host name.


        :param host_name: The host_name of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: str
        """
        self._host_name = host_name

    @property
    def port(self):
        """
        Gets the port of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The number of the port on which the server listens for TCP/IP connections.


        :return: The port of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The number of the port on which the server listens for TCP/IP connections.


        :param port: The port of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: int
        """
        self._port = port

    @property
    def server_id(self):
        """
        **[Required]** Gets the server_id of this ManagedMySqlDatabaseGeneralReplicationInformation.
        This server's ID.


        :return: The server_id of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: int
        """
        return self._server_id

    @server_id.setter
    def server_id(self, server_id):
        """
        Sets the server_id of this ManagedMySqlDatabaseGeneralReplicationInformation.
        This server's ID.


        :param server_id: The server_id of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: int
        """
        self._server_id = server_id

    @property
    def server_uuid(self):
        """
        **[Required]** Gets the server_uuid of this ManagedMySqlDatabaseGeneralReplicationInformation.
        This server's Universally Unique Identifier (UUID).


        :return: The server_uuid of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: str
        """
        return self._server_uuid

    @server_uuid.setter
    def server_uuid(self, server_uuid):
        """
        Sets the server_uuid of this ManagedMySqlDatabaseGeneralReplicationInformation.
        This server's Universally Unique Identifier (UUID).


        :param server_uuid: The server_uuid of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: str
        """
        self._server_uuid = server_uuid

    @property
    def seconds_behind_source_max(self):
        """
        Gets the seconds_behind_source_max of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The number of seconds the replica is behind the source. When multiple sources are involved, this is the maximum value across all sources.


        :return: The seconds_behind_source_max of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: int
        """
        return self._seconds_behind_source_max

    @seconds_behind_source_max.setter
    def seconds_behind_source_max(self, seconds_behind_source_max):
        """
        Sets the seconds_behind_source_max of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The number of seconds the replica is behind the source. When multiple sources are involved, this is the maximum value across all sources.


        :param seconds_behind_source_max: The seconds_behind_source_max of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: int
        """
        self._seconds_behind_source_max = seconds_behind_source_max

    @property
    def fetch_status_summary(self):
        """
        Gets the fetch_status_summary of this ManagedMySqlDatabaseGeneralReplicationInformation.
        A summary of the current status of fetch operations.


        :return: The fetch_status_summary of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: str
        """
        return self._fetch_status_summary

    @fetch_status_summary.setter
    def fetch_status_summary(self, fetch_status_summary):
        """
        Sets the fetch_status_summary of this ManagedMySqlDatabaseGeneralReplicationInformation.
        A summary of the current status of fetch operations.


        :param fetch_status_summary: The fetch_status_summary of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: str
        """
        self._fetch_status_summary = fetch_status_summary

    @property
    def apply_status_summary(self):
        """
        Gets the apply_status_summary of this ManagedMySqlDatabaseGeneralReplicationInformation.
        A summary of the current status of apply operations.


        :return: The apply_status_summary of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: str
        """
        return self._apply_status_summary

    @apply_status_summary.setter
    def apply_status_summary(self, apply_status_summary):
        """
        Sets the apply_status_summary of this ManagedMySqlDatabaseGeneralReplicationInformation.
        A summary of the current status of apply operations.


        :param apply_status_summary: The apply_status_summary of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: str
        """
        self._apply_status_summary = apply_status_summary

    @property
    def is_high_availability_enabled(self):
        """
        Gets the is_high_availability_enabled of this ManagedMySqlDatabaseGeneralReplicationInformation.
        Specifies if high availability is enabled on this server.


        :return: The is_high_availability_enabled of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: bool
        """
        return self._is_high_availability_enabled

    @is_high_availability_enabled.setter
    def is_high_availability_enabled(self, is_high_availability_enabled):
        """
        Sets the is_high_availability_enabled of this ManagedMySqlDatabaseGeneralReplicationInformation.
        Specifies if high availability is enabled on this server.


        :param is_high_availability_enabled: The is_high_availability_enabled of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: bool
        """
        self._is_high_availability_enabled = is_high_availability_enabled

    @property
    def high_availability_member_state(self):
        """
        Gets the high_availability_member_state of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The state of this server as a group replication member.


        :return: The high_availability_member_state of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: str
        """
        return self._high_availability_member_state

    @high_availability_member_state.setter
    def high_availability_member_state(self, high_availability_member_state):
        """
        Sets the high_availability_member_state of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The state of this server as a group replication member.


        :param high_availability_member_state: The high_availability_member_state of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: str
        """
        self._high_availability_member_state = high_availability_member_state

    @property
    def inbound_replications_count(self):
        """
        Gets the inbound_replications_count of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The number of sources this server is replicating from.


        :return: The inbound_replications_count of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: int
        """
        return self._inbound_replications_count

    @inbound_replications_count.setter
    def inbound_replications_count(self, inbound_replications_count):
        """
        Sets the inbound_replications_count of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The number of sources this server is replicating from.


        :param inbound_replications_count: The inbound_replications_count of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: int
        """
        self._inbound_replications_count = inbound_replications_count

    @property
    def read_only(self):
        """
        **[Required]** Gets the read_only of this ManagedMySqlDatabaseGeneralReplicationInformation.
        If the value is ON, the instance is configured as read_only. If the value is SUPER, the instance is configured as super_read_only. If the value is OFF, the instance is neither read_only nor super_read_only.

        Allowed values for this property are: "ON", "SUPER", "OFF", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The read_only of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: str
        """
        return self._read_only

    @read_only.setter
    def read_only(self, read_only):
        """
        Sets the read_only of this ManagedMySqlDatabaseGeneralReplicationInformation.
        If the value is ON, the instance is configured as read_only. If the value is SUPER, the instance is configured as super_read_only. If the value is OFF, the instance is neither read_only nor super_read_only.


        :param read_only: The read_only of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: str
        """
        allowed_values = ["ON", "SUPER", "OFF"]
        if not value_allowed_none_or_none_sentinel(read_only, allowed_values):
            read_only = 'UNKNOWN_ENUM_VALUE'
        self._read_only = read_only

    @property
    def gtid_mode(self):
        """
        Gets the gtid_mode of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The Global Transaction Identifier (GTID) mode of this server.


        :return: The gtid_mode of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: str
        """
        return self._gtid_mode

    @gtid_mode.setter
    def gtid_mode(self, gtid_mode):
        """
        Sets the gtid_mode of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The Global Transaction Identifier (GTID) mode of this server.


        :param gtid_mode: The gtid_mode of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: str
        """
        self._gtid_mode = gtid_mode

    @property
    def executed_gtid_set(self):
        """
        Gets the executed_gtid_set of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The set of global transaction identifiers for transactions that have been executed on this source server.


        :return: The executed_gtid_set of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: str
        """
        return self._executed_gtid_set

    @executed_gtid_set.setter
    def executed_gtid_set(self, executed_gtid_set):
        """
        Sets the executed_gtid_set of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The set of global transaction identifiers for transactions that have been executed on this source server.


        :param executed_gtid_set: The executed_gtid_set of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: str
        """
        self._executed_gtid_set = executed_gtid_set

    @property
    def binary_logging(self):
        """
        Gets the binary_logging of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The status of binary logging on this server.


        :return: The binary_logging of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: str
        """
        return self._binary_logging

    @binary_logging.setter
    def binary_logging(self, binary_logging):
        """
        Sets the binary_logging of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The status of binary logging on this server.


        :param binary_logging: The binary_logging of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: str
        """
        self._binary_logging = binary_logging

    @property
    def binary_log_format(self):
        """
        Gets the binary_log_format of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The binary logging format used by this server.


        :return: The binary_log_format of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: str
        """
        return self._binary_log_format

    @binary_log_format.setter
    def binary_log_format(self, binary_log_format):
        """
        Sets the binary_log_format of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The binary logging format used by this server.


        :param binary_log_format: The binary_log_format of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: str
        """
        self._binary_log_format = binary_log_format

    @property
    def outbound_replications_count(self):
        """
        Gets the outbound_replications_count of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The number of replicas replicating from this server.


        :return: The outbound_replications_count of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :rtype: int
        """
        return self._outbound_replications_count

    @outbound_replications_count.setter
    def outbound_replications_count(self, outbound_replications_count):
        """
        Sets the outbound_replications_count of this ManagedMySqlDatabaseGeneralReplicationInformation.
        The number of replicas replicating from this server.


        :param outbound_replications_count: The outbound_replications_count of this ManagedMySqlDatabaseGeneralReplicationInformation.
        :type: int
        """
        self._outbound_replications_count = outbound_replications_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
