# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchOperationsSummary(object):
    """
    Patch operation list summary by status record.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PatchOperationsSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param scheduled_patch_ops_count:
            The value to assign to the scheduled_patch_ops_count property of this PatchOperationsSummary.
        :type scheduled_patch_ops_count: int

        :param running_patch_ops_count:
            The value to assign to the running_patch_ops_count property of this PatchOperationsSummary.
        :type running_patch_ops_count: int

        :param successful_patch_ops_count:
            The value to assign to the successful_patch_ops_count property of this PatchOperationsSummary.
        :type successful_patch_ops_count: int

        :param warnings_patch_ops_count:
            The value to assign to the warnings_patch_ops_count property of this PatchOperationsSummary.
        :type warnings_patch_ops_count: int

        :param failed_patch_ops_count:
            The value to assign to the failed_patch_ops_count property of this PatchOperationsSummary.
        :type failed_patch_ops_count: int

        """
        self.swagger_types = {
            'scheduled_patch_ops_count': 'int',
            'running_patch_ops_count': 'int',
            'successful_patch_ops_count': 'int',
            'warnings_patch_ops_count': 'int',
            'failed_patch_ops_count': 'int'
        }
        self.attribute_map = {
            'scheduled_patch_ops_count': 'scheduledPatchOpsCount',
            'running_patch_ops_count': 'runningPatchOpsCount',
            'successful_patch_ops_count': 'successfulPatchOpsCount',
            'warnings_patch_ops_count': 'warningsPatchOpsCount',
            'failed_patch_ops_count': 'failedPatchOpsCount'
        }
        self._scheduled_patch_ops_count = None
        self._running_patch_ops_count = None
        self._successful_patch_ops_count = None
        self._warnings_patch_ops_count = None
        self._failed_patch_ops_count = None

    @property
    def scheduled_patch_ops_count(self):
        """
        Gets the scheduled_patch_ops_count of this PatchOperationsSummary.
        Total number of scheduled Patch operations.


        :return: The scheduled_patch_ops_count of this PatchOperationsSummary.
        :rtype: int
        """
        return self._scheduled_patch_ops_count

    @scheduled_patch_ops_count.setter
    def scheduled_patch_ops_count(self, scheduled_patch_ops_count):
        """
        Sets the scheduled_patch_ops_count of this PatchOperationsSummary.
        Total number of scheduled Patch operations.


        :param scheduled_patch_ops_count: The scheduled_patch_ops_count of this PatchOperationsSummary.
        :type: int
        """
        self._scheduled_patch_ops_count = scheduled_patch_ops_count

    @property
    def running_patch_ops_count(self):
        """
        Gets the running_patch_ops_count of this PatchOperationsSummary.
        Total number of in progress Patch operations.


        :return: The running_patch_ops_count of this PatchOperationsSummary.
        :rtype: int
        """
        return self._running_patch_ops_count

    @running_patch_ops_count.setter
    def running_patch_ops_count(self, running_patch_ops_count):
        """
        Sets the running_patch_ops_count of this PatchOperationsSummary.
        Total number of in progress Patch operations.


        :param running_patch_ops_count: The running_patch_ops_count of this PatchOperationsSummary.
        :type: int
        """
        self._running_patch_ops_count = running_patch_ops_count

    @property
    def successful_patch_ops_count(self):
        """
        Gets the successful_patch_ops_count of this PatchOperationsSummary.
        Total number of successful Patch operations.


        :return: The successful_patch_ops_count of this PatchOperationsSummary.
        :rtype: int
        """
        return self._successful_patch_ops_count

    @successful_patch_ops_count.setter
    def successful_patch_ops_count(self, successful_patch_ops_count):
        """
        Sets the successful_patch_ops_count of this PatchOperationsSummary.
        Total number of successful Patch operations.


        :param successful_patch_ops_count: The successful_patch_ops_count of this PatchOperationsSummary.
        :type: int
        """
        self._successful_patch_ops_count = successful_patch_ops_count

    @property
    def warnings_patch_ops_count(self):
        """
        Gets the warnings_patch_ops_count of this PatchOperationsSummary.
        Total number of Patch operations that have warnings.


        :return: The warnings_patch_ops_count of this PatchOperationsSummary.
        :rtype: int
        """
        return self._warnings_patch_ops_count

    @warnings_patch_ops_count.setter
    def warnings_patch_ops_count(self, warnings_patch_ops_count):
        """
        Sets the warnings_patch_ops_count of this PatchOperationsSummary.
        Total number of Patch operations that have warnings.


        :param warnings_patch_ops_count: The warnings_patch_ops_count of this PatchOperationsSummary.
        :type: int
        """
        self._warnings_patch_ops_count = warnings_patch_ops_count

    @property
    def failed_patch_ops_count(self):
        """
        Gets the failed_patch_ops_count of this PatchOperationsSummary.
        Total number of failed Patch operations.


        :return: The failed_patch_ops_count of this PatchOperationsSummary.
        :rtype: int
        """
        return self._failed_patch_ops_count

    @failed_patch_ops_count.setter
    def failed_patch_ops_count(self, failed_patch_ops_count):
        """
        Sets the failed_patch_ops_count of this PatchOperationsSummary.
        Total number of failed Patch operations.


        :param failed_patch_ops_count: The failed_patch_ops_count of this PatchOperationsSummary.
        :type: int
        """
        self._failed_patch_ops_count = failed_patch_ops_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
