# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourceInfo(object):
    """
    The Resource Info.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ResourceInfo object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_compartment_id:
            The value to assign to the resource_compartment_id property of this ResourceInfo.
        :type resource_compartment_id: str

        :param resource_name:
            The value to assign to the resource_name property of this ResourceInfo.
        :type resource_name: str

        :param resource_id:
            The value to assign to the resource_id property of this ResourceInfo.
        :type resource_id: str

        :param resource_type:
            The value to assign to the resource_type property of this ResourceInfo.
        :type resource_type: str

        :param deployment_type:
            The value to assign to the deployment_type property of this ResourceInfo.
        :type deployment_type: str

        :param connector_id:
            The value to assign to the connector_id property of this ResourceInfo.
        :type connector_id: str

        :param is_cluster_db:
            The value to assign to the is_cluster_db property of this ResourceInfo.
        :type is_cluster_db: bool

        :param host_info:
            The value to assign to the host_info property of this ResourceInfo.
        :type host_info: list[oci.dblm.models.HostInfo]

        :param db_version:
            The value to assign to the db_version property of this ResourceInfo.
        :type db_version: str

        :param db_platform_type:
            The value to assign to the db_platform_type property of this ResourceInfo.
        :type db_platform_type: str

        :param license_type:
            The value to assign to the license_type property of this ResourceInfo.
        :type license_type: str

        :param agent_id:
            The value to assign to the agent_id property of this ResourceInfo.
        :type agent_id: str

        """
        self.swagger_types = {
            'resource_compartment_id': 'str',
            'resource_name': 'str',
            'resource_id': 'str',
            'resource_type': 'str',
            'deployment_type': 'str',
            'connector_id': 'str',
            'is_cluster_db': 'bool',
            'host_info': 'list[HostInfo]',
            'db_version': 'str',
            'db_platform_type': 'str',
            'license_type': 'str',
            'agent_id': 'str'
        }
        self.attribute_map = {
            'resource_compartment_id': 'resourceCompartmentId',
            'resource_name': 'resourceName',
            'resource_id': 'resourceId',
            'resource_type': 'resourceType',
            'deployment_type': 'deploymentType',
            'connector_id': 'connectorId',
            'is_cluster_db': 'isClusterDb',
            'host_info': 'hostInfo',
            'db_version': 'dbVersion',
            'db_platform_type': 'dbPlatformType',
            'license_type': 'licenseType',
            'agent_id': 'agentId'
        }
        self._resource_compartment_id = None
        self._resource_name = None
        self._resource_id = None
        self._resource_type = None
        self._deployment_type = None
        self._connector_id = None
        self._is_cluster_db = None
        self._host_info = None
        self._db_version = None
        self._db_platform_type = None
        self._license_type = None
        self._agent_id = None

    @property
    def resource_compartment_id(self):
        """
        **[Required]** Gets the resource_compartment_id of this ResourceInfo.
        The compartmentId of the resource.


        :return: The resource_compartment_id of this ResourceInfo.
        :rtype: str
        """
        return self._resource_compartment_id

    @resource_compartment_id.setter
    def resource_compartment_id(self, resource_compartment_id):
        """
        Sets the resource_compartment_id of this ResourceInfo.
        The compartmentId of the resource.


        :param resource_compartment_id: The resource_compartment_id of this ResourceInfo.
        :type: str
        """
        self._resource_compartment_id = resource_compartment_id

    @property
    def resource_name(self):
        """
        **[Required]** Gets the resource_name of this ResourceInfo.
        The name of the resource.


        :return: The resource_name of this ResourceInfo.
        :rtype: str
        """
        return self._resource_name

    @resource_name.setter
    def resource_name(self, resource_name):
        """
        Sets the resource_name of this ResourceInfo.
        The name of the resource.


        :param resource_name: The resource_name of this ResourceInfo.
        :type: str
        """
        self._resource_name = resource_name

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this ResourceInfo.
        The Id of the resource.


        :return: The resource_id of this ResourceInfo.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this ResourceInfo.
        The Id of the resource.


        :param resource_id: The resource_id of this ResourceInfo.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def resource_type(self):
        """
        **[Required]** Gets the resource_type of this ResourceInfo.
        The type of the resource.


        :return: The resource_type of this ResourceInfo.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this ResourceInfo.
        The type of the resource.


        :param resource_type: The resource_type of this ResourceInfo.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def deployment_type(self):
        """
        **[Required]** Gets the deployment_type of this ResourceInfo.
        The deployment type of the resource.


        :return: The deployment_type of this ResourceInfo.
        :rtype: str
        """
        return self._deployment_type

    @deployment_type.setter
    def deployment_type(self, deployment_type):
        """
        Sets the deployment_type of this ResourceInfo.
        The deployment type of the resource.


        :param deployment_type: The deployment_type of this ResourceInfo.
        :type: str
        """
        self._deployment_type = deployment_type

    @property
    def connector_id(self):
        """
        **[Required]** Gets the connector_id of this ResourceInfo.
        The connector Id of the resource.


        :return: The connector_id of this ResourceInfo.
        :rtype: str
        """
        return self._connector_id

    @connector_id.setter
    def connector_id(self, connector_id):
        """
        Sets the connector_id of this ResourceInfo.
        The connector Id of the resource.


        :param connector_id: The connector_id of this ResourceInfo.
        :type: str
        """
        self._connector_id = connector_id

    @property
    def is_cluster_db(self):
        """
        Gets the is_cluster_db of this ResourceInfo.
        True if it is a cluster db.


        :return: The is_cluster_db of this ResourceInfo.
        :rtype: bool
        """
        return self._is_cluster_db

    @is_cluster_db.setter
    def is_cluster_db(self, is_cluster_db):
        """
        Sets the is_cluster_db of this ResourceInfo.
        True if it is a cluster db.


        :param is_cluster_db: The is_cluster_db of this ResourceInfo.
        :type: bool
        """
        self._is_cluster_db = is_cluster_db

    @property
    def host_info(self):
        """
        **[Required]** Gets the host_info of this ResourceInfo.
        host info objects


        :return: The host_info of this ResourceInfo.
        :rtype: list[oci.dblm.models.HostInfo]
        """
        return self._host_info

    @host_info.setter
    def host_info(self, host_info):
        """
        Sets the host_info of this ResourceInfo.
        host info objects


        :param host_info: The host_info of this ResourceInfo.
        :type: list[oci.dblm.models.HostInfo]
        """
        self._host_info = host_info

    @property
    def db_version(self):
        """
        **[Required]** Gets the db_version of this ResourceInfo.
        The version of the resource.


        :return: The db_version of this ResourceInfo.
        :rtype: str
        """
        return self._db_version

    @db_version.setter
    def db_version(self, db_version):
        """
        Sets the db_version of this ResourceInfo.
        The version of the resource.


        :param db_version: The db_version of this ResourceInfo.
        :type: str
        """
        self._db_version = db_version

    @property
    def db_platform_type(self):
        """
        **[Required]** Gets the db_platform_type of this ResourceInfo.
        The platform type of the resource.


        :return: The db_platform_type of this ResourceInfo.
        :rtype: str
        """
        return self._db_platform_type

    @db_platform_type.setter
    def db_platform_type(self, db_platform_type):
        """
        Sets the db_platform_type of this ResourceInfo.
        The platform type of the resource.


        :param db_platform_type: The db_platform_type of this ResourceInfo.
        :type: str
        """
        self._db_platform_type = db_platform_type

    @property
    def license_type(self):
        """
        **[Required]** Gets the license_type of this ResourceInfo.
        The License Type of the resource.


        :return: The license_type of this ResourceInfo.
        :rtype: str
        """
        return self._license_type

    @license_type.setter
    def license_type(self, license_type):
        """
        Sets the license_type of this ResourceInfo.
        The License Type of the resource.


        :param license_type: The license_type of this ResourceInfo.
        :type: str
        """
        self._license_type = license_type

    @property
    def agent_id(self):
        """
        Gets the agent_id of this ResourceInfo.
        The agent Id of the agent managing the resource.


        :return: The agent_id of this ResourceInfo.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """
        Sets the agent_id of this ResourceInfo.
        The agent Id of the agent managing the resource.


        :param agent_id: The agent_id of this ResourceInfo.
        :type: str
        """
        self._agent_id = agent_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
