# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VulnerabilityResourceSummary(object):
    """
    The assessed Resources.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VulnerabilityResourceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this VulnerabilityResourceSummary.
        :type id: str

        :param name:
            The value to assign to the name property of this VulnerabilityResourceSummary.
        :type name: str

        :param version:
            The value to assign to the version property of this VulnerabilityResourceSummary.
        :type version: str

        :param release:
            The value to assign to the release property of this VulnerabilityResourceSummary.
        :type release: str

        :param platform:
            The value to assign to the platform property of this VulnerabilityResourceSummary.
        :type platform: str

        :param time_config_collected:
            The value to assign to the time_config_collected property of this VulnerabilityResourceSummary.
        :type time_config_collected: datetime

        :param time_scan_ended:
            The value to assign to the time_scan_ended property of this VulnerabilityResourceSummary.
        :type time_scan_ended: datetime

        :param image_id:
            The value to assign to the image_id property of this VulnerabilityResourceSummary.
        :type image_id: str

        :param subscribed_image:
            The value to assign to the subscribed_image property of this VulnerabilityResourceSummary.
        :type subscribed_image: str

        :param metric_errors:
            The value to assign to the metric_errors property of this VulnerabilityResourceSummary.
        :type metric_errors: list[oci.dblm.models.MetricError]

        :param child_pdbs:
            The value to assign to the child_pdbs property of this VulnerabilityResourceSummary.
        :type child_pdbs: list[oci.dblm.models.ChildPdb]

        :param vulnerabilities_summary:
            The value to assign to the vulnerabilities_summary property of this VulnerabilityResourceSummary.
        :type vulnerabilities_summary: object

        :param patch_recommendations_summary:
            The value to assign to the patch_recommendations_summary property of this VulnerabilityResourceSummary.
        :type patch_recommendations_summary: object

        :param patch_recommendations_details:
            The value to assign to the patch_recommendations_details property of this VulnerabilityResourceSummary.
        :type patch_recommendations_details: list[oci.dblm.models.PatchRecommendationsDetailsSummary]

        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'version': 'str',
            'release': 'str',
            'platform': 'str',
            'time_config_collected': 'datetime',
            'time_scan_ended': 'datetime',
            'image_id': 'str',
            'subscribed_image': 'str',
            'metric_errors': 'list[MetricError]',
            'child_pdbs': 'list[ChildPdb]',
            'vulnerabilities_summary': 'object',
            'patch_recommendations_summary': 'object',
            'patch_recommendations_details': 'list[PatchRecommendationsDetailsSummary]'
        }
        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'version': 'version',
            'release': 'release',
            'platform': 'platform',
            'time_config_collected': 'timeConfigCollected',
            'time_scan_ended': 'timeScanEnded',
            'image_id': 'imageId',
            'subscribed_image': 'subscribedImage',
            'metric_errors': 'metricErrors',
            'child_pdbs': 'childPdbs',
            'vulnerabilities_summary': 'vulnerabilitiesSummary',
            'patch_recommendations_summary': 'patchRecommendationsSummary',
            'patch_recommendations_details': 'patchRecommendationsDetails'
        }
        self._id = None
        self._name = None
        self._version = None
        self._release = None
        self._platform = None
        self._time_config_collected = None
        self._time_scan_ended = None
        self._image_id = None
        self._subscribed_image = None
        self._metric_errors = None
        self._child_pdbs = None
        self._vulnerabilities_summary = None
        self._patch_recommendations_summary = None
        self._patch_recommendations_details = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this VulnerabilityResourceSummary.
        The resource ID for this resource.


        :return: The id of this VulnerabilityResourceSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VulnerabilityResourceSummary.
        The resource ID for this resource.


        :param id: The id of this VulnerabilityResourceSummary.
        :type: str
        """
        self._id = id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this VulnerabilityResourceSummary.
        The name of the resource.


        :return: The name of this VulnerabilityResourceSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VulnerabilityResourceSummary.
        The name of the resource.


        :param name: The name of this VulnerabilityResourceSummary.
        :type: str
        """
        self._name = name

    @property
    def version(self):
        """
        **[Required]** Gets the version of this VulnerabilityResourceSummary.
        A string representing the version of the resource.


        :return: The version of this VulnerabilityResourceSummary.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this VulnerabilityResourceSummary.
        A string representing the version of the resource.


        :param version: The version of this VulnerabilityResourceSummary.
        :type: str
        """
        self._version = version

    @property
    def release(self):
        """
        **[Required]** Gets the release of this VulnerabilityResourceSummary.
        A string representing the release of the resource.


        :return: The release of this VulnerabilityResourceSummary.
        :rtype: str
        """
        return self._release

    @release.setter
    def release(self, release):
        """
        Sets the release of this VulnerabilityResourceSummary.
        A string representing the release of the resource.


        :param release: The release of this VulnerabilityResourceSummary.
        :type: str
        """
        self._release = release

    @property
    def platform(self):
        """
        **[Required]** Gets the platform of this VulnerabilityResourceSummary.
        A string representing the platform of the resource.


        :return: The platform of this VulnerabilityResourceSummary.
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform):
        """
        Sets the platform of this VulnerabilityResourceSummary.
        A string representing the platform of the resource.


        :param platform: The platform of this VulnerabilityResourceSummary.
        :type: str
        """
        self._platform = platform

    @property
    def time_config_collected(self):
        """
        **[Required]** Gets the time_config_collected of this VulnerabilityResourceSummary.
        Time when the latest configuration collection happened.


        :return: The time_config_collected of this VulnerabilityResourceSummary.
        :rtype: datetime
        """
        return self._time_config_collected

    @time_config_collected.setter
    def time_config_collected(self, time_config_collected):
        """
        Sets the time_config_collected of this VulnerabilityResourceSummary.
        Time when the latest configuration collection happened.


        :param time_config_collected: The time_config_collected of this VulnerabilityResourceSummary.
        :type: datetime
        """
        self._time_config_collected = time_config_collected

    @property
    def time_scan_ended(self):
        """
        **[Required]** Gets the time_scan_ended of this VulnerabilityResourceSummary.
        Time when the latest scan happened for the resource.


        :return: The time_scan_ended of this VulnerabilityResourceSummary.
        :rtype: datetime
        """
        return self._time_scan_ended

    @time_scan_ended.setter
    def time_scan_ended(self, time_scan_ended):
        """
        Sets the time_scan_ended of this VulnerabilityResourceSummary.
        Time when the latest scan happened for the resource.


        :param time_scan_ended: The time_scan_ended of this VulnerabilityResourceSummary.
        :type: datetime
        """
        self._time_scan_ended = time_scan_ended

    @property
    def image_id(self):
        """
        **[Required]** Gets the image_id of this VulnerabilityResourceSummary.
        Identifier for the resource is subscribed to.


        :return: The image_id of this VulnerabilityResourceSummary.
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """
        Sets the image_id of this VulnerabilityResourceSummary.
        Identifier for the resource is subscribed to.


        :param image_id: The image_id of this VulnerabilityResourceSummary.
        :type: str
        """
        self._image_id = image_id

    @property
    def subscribed_image(self):
        """
        **[Required]** Gets the subscribed_image of this VulnerabilityResourceSummary.
        Image the resource is subscribed to.


        :return: The subscribed_image of this VulnerabilityResourceSummary.
        :rtype: str
        """
        return self._subscribed_image

    @subscribed_image.setter
    def subscribed_image(self, subscribed_image):
        """
        Sets the subscribed_image of this VulnerabilityResourceSummary.
        Image the resource is subscribed to.


        :param subscribed_image: The subscribed_image of this VulnerabilityResourceSummary.
        :type: str
        """
        self._subscribed_image = subscribed_image

    @property
    def metric_errors(self):
        """
        **[Required]** Gets the metric_errors of this VulnerabilityResourceSummary.
        Metric errors.


        :return: The metric_errors of this VulnerabilityResourceSummary.
        :rtype: list[oci.dblm.models.MetricError]
        """
        return self._metric_errors

    @metric_errors.setter
    def metric_errors(self, metric_errors):
        """
        Sets the metric_errors of this VulnerabilityResourceSummary.
        Metric errors.


        :param metric_errors: The metric_errors of this VulnerabilityResourceSummary.
        :type: list[oci.dblm.models.MetricError]
        """
        self._metric_errors = metric_errors

    @property
    def child_pdbs(self):
        """
        **[Required]** Gets the child_pdbs of this VulnerabilityResourceSummary.
        PDBs for a CDB.


        :return: The child_pdbs of this VulnerabilityResourceSummary.
        :rtype: list[oci.dblm.models.ChildPdb]
        """
        return self._child_pdbs

    @child_pdbs.setter
    def child_pdbs(self, child_pdbs):
        """
        Sets the child_pdbs of this VulnerabilityResourceSummary.
        PDBs for a CDB.


        :param child_pdbs: The child_pdbs of this VulnerabilityResourceSummary.
        :type: list[oci.dblm.models.ChildPdb]
        """
        self._child_pdbs = child_pdbs

    @property
    def vulnerabilities_summary(self):
        """
        **[Required]** Gets the vulnerabilities_summary of this VulnerabilityResourceSummary.
        Summary of the resources that are registered and may or may not have vulnerabilities.


        :return: The vulnerabilities_summary of this VulnerabilityResourceSummary.
        :rtype: object
        """
        return self._vulnerabilities_summary

    @vulnerabilities_summary.setter
    def vulnerabilities_summary(self, vulnerabilities_summary):
        """
        Sets the vulnerabilities_summary of this VulnerabilityResourceSummary.
        Summary of the resources that are registered and may or may not have vulnerabilities.


        :param vulnerabilities_summary: The vulnerabilities_summary of this VulnerabilityResourceSummary.
        :type: object
        """
        self._vulnerabilities_summary = vulnerabilities_summary

    @property
    def patch_recommendations_summary(self):
        """
        **[Required]** Gets the patch_recommendations_summary of this VulnerabilityResourceSummary.
        Summary of the patch recommendations for databases.


        :return: The patch_recommendations_summary of this VulnerabilityResourceSummary.
        :rtype: object
        """
        return self._patch_recommendations_summary

    @patch_recommendations_summary.setter
    def patch_recommendations_summary(self, patch_recommendations_summary):
        """
        Sets the patch_recommendations_summary of this VulnerabilityResourceSummary.
        Summary of the patch recommendations for databases.


        :param patch_recommendations_summary: The patch_recommendations_summary of this VulnerabilityResourceSummary.
        :type: object
        """
        self._patch_recommendations_summary = patch_recommendations_summary

    @property
    def patch_recommendations_details(self):
        """
        **[Required]** Gets the patch_recommendations_details of this VulnerabilityResourceSummary.
        List of the patch recommendations for databases


        :return: The patch_recommendations_details of this VulnerabilityResourceSummary.
        :rtype: list[oci.dblm.models.PatchRecommendationsDetailsSummary]
        """
        return self._patch_recommendations_details

    @patch_recommendations_details.setter
    def patch_recommendations_details(self, patch_recommendations_details):
        """
        Sets the patch_recommendations_details of this VulnerabilityResourceSummary.
        List of the patch recommendations for databases


        :param patch_recommendations_details: The patch_recommendations_details of this VulnerabilityResourceSummary.
        :type: list[oci.dblm.models.PatchRecommendationsDetailsSummary]
        """
        self._patch_recommendations_details = patch_recommendations_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
