# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ForkSyncStatusSummary(object):
    """
    Object that contains the sync status for a specific branch name.
    """

    #: A constant which can be used with the sync_status property of a ForkSyncStatusSummary.
    #: This constant has a value of "IN_SYNC"
    SYNC_STATUS_IN_SYNC = "IN_SYNC"

    #: A constant which can be used with the sync_status property of a ForkSyncStatusSummary.
    #: This constant has a value of "SYNC_IN_PROGRESS"
    SYNC_STATUS_SYNC_IN_PROGRESS = "SYNC_IN_PROGRESS"

    #: A constant which can be used with the sync_status property of a ForkSyncStatusSummary.
    #: This constant has a value of "OUT_OF_SYNC"
    SYNC_STATUS_OUT_OF_SYNC = "OUT_OF_SYNC"

    def __init__(self, **kwargs):
        """
        Initializes a new ForkSyncStatusSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param sync_status:
            The value to assign to the sync_status property of this ForkSyncStatusSummary.
            Allowed values for this property are: "IN_SYNC", "SYNC_IN_PROGRESS", "OUT_OF_SYNC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type sync_status: str

        :param repository_id:
            The value to assign to the repository_id property of this ForkSyncStatusSummary.
        :type repository_id: str

        :param branch_name:
            The value to assign to the branch_name property of this ForkSyncStatusSummary.
        :type branch_name: str

        """
        self.swagger_types = {
            'sync_status': 'str',
            'repository_id': 'str',
            'branch_name': 'str'
        }
        self.attribute_map = {
            'sync_status': 'syncStatus',
            'repository_id': 'repositoryId',
            'branch_name': 'branchName'
        }
        self._sync_status = None
        self._repository_id = None
        self._branch_name = None

    @property
    def sync_status(self):
        """
        **[Required]** Gets the sync_status of this ForkSyncStatusSummary.
        Sync status for the provided branch.

        Allowed values for this property are: "IN_SYNC", "SYNC_IN_PROGRESS", "OUT_OF_SYNC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The sync_status of this ForkSyncStatusSummary.
        :rtype: str
        """
        return self._sync_status

    @sync_status.setter
    def sync_status(self, sync_status):
        """
        Sets the sync_status of this ForkSyncStatusSummary.
        Sync status for the provided branch.


        :param sync_status: The sync_status of this ForkSyncStatusSummary.
        :type: str
        """
        allowed_values = ["IN_SYNC", "SYNC_IN_PROGRESS", "OUT_OF_SYNC"]
        if not value_allowed_none_or_none_sentinel(sync_status, allowed_values):
            sync_status = 'UNKNOWN_ENUM_VALUE'
        self._sync_status = sync_status

    @property
    def repository_id(self):
        """
        **[Required]** Gets the repository_id of this ForkSyncStatusSummary.
        The OCID of the child repository.


        :return: The repository_id of this ForkSyncStatusSummary.
        :rtype: str
        """
        return self._repository_id

    @repository_id.setter
    def repository_id(self, repository_id):
        """
        Sets the repository_id of this ForkSyncStatusSummary.
        The OCID of the child repository.


        :param repository_id: The repository_id of this ForkSyncStatusSummary.
        :type: str
        """
        self._repository_id = repository_id

    @property
    def branch_name(self):
        """
        **[Required]** Gets the branch_name of this ForkSyncStatusSummary.
        The branch in the child repository we are checking the sync status of.


        :return: The branch_name of this ForkSyncStatusSummary.
        :rtype: str
        """
        return self._branch_name

    @branch_name.setter
    def branch_name(self, branch_name):
        """
        Sets the branch_name of this ForkSyncStatusSummary.
        The branch in the child repository we are checking the sync status of.


        :param branch_name: The branch_name of this ForkSyncStatusSummary.
        :type: str
        """
        self._branch_name = branch_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
