# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManageSettingsDetails(object):
    """
    The information to be updated.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ManageSettingsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param discovery_frequency:
            The value to assign to the discovery_frequency property of this ManageSettingsDetails.
        :type discovery_frequency: str

        """
        self.swagger_types = {
            'discovery_frequency': 'str'
        }
        self.attribute_map = {
            'discovery_frequency': 'discoveryFrequency'
        }
        self._discovery_frequency = None

    @property
    def discovery_frequency(self):
        """
        Gets the discovery_frequency of this ManageSettingsDetails.
        Provide discovery frequency.


        :return: The discovery_frequency of this ManageSettingsDetails.
        :rtype: str
        """
        return self._discovery_frequency

    @discovery_frequency.setter
    def discovery_frequency(self, discovery_frequency):
        """
        Sets the discovery_frequency of this ManageSettingsDetails.
        Provide discovery frequency.


        :param discovery_frequency: The discovery_frequency of this ManageSettingsDetails.
        :type: str
        """
        self._discovery_frequency = discovery_frequency

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
