# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .patch_selection_details import PatchSelectionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchLevelSelectionDetails(PatchSelectionDetails):
    """
    Patch Level Details.
    If you set the policy rule by selecting this option and provide the Patch level as Latest, Fleet Application Management calculates the compliance status of the product in the following ways:
    -   Reports the patch process as compliant for the software identified or targets discovered at the Latest and Latest-1 version.
    -   Reports the patch process as noncompliant for the software identified or targets discovered at the Latest-2 version.
    """

    #: A constant which can be used with the patch_level property of a PatchLevelSelectionDetails.
    #: This constant has a value of "LATEST"
    PATCH_LEVEL_LATEST = "LATEST"

    #: A constant which can be used with the patch_level property of a PatchLevelSelectionDetails.
    #: This constant has a value of "LATEST_MINUS_ONE"
    PATCH_LEVEL_LATEST_MINUS_ONE = "LATEST_MINUS_ONE"

    #: A constant which can be used with the patch_level property of a PatchLevelSelectionDetails.
    #: This constant has a value of "LATEST_MINUS_TWO"
    PATCH_LEVEL_LATEST_MINUS_TWO = "LATEST_MINUS_TWO"

    def __init__(self, **kwargs):
        """
        Initializes a new PatchLevelSelectionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.PatchLevelSelectionDetails.selection_type` attribute
        of this class is ``PATCH_LEVEL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param selection_type:
            The value to assign to the selection_type property of this PatchLevelSelectionDetails.
            Allowed values for this property are: "PATCH_LEVEL", "PATCH_NAME", "PATCH_RELEASE_DATE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type selection_type: str

        :param patch_level:
            The value to assign to the patch_level property of this PatchLevelSelectionDetails.
            Allowed values for this property are: "LATEST", "LATEST_MINUS_ONE", "LATEST_MINUS_TWO", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type patch_level: str

        """
        self.swagger_types = {
            'selection_type': 'str',
            'patch_level': 'str'
        }
        self.attribute_map = {
            'selection_type': 'selectionType',
            'patch_level': 'patchLevel'
        }
        self._selection_type = None
        self._patch_level = None
        self._selection_type = 'PATCH_LEVEL'

    @property
    def patch_level(self):
        """
        **[Required]** Gets the patch_level of this PatchLevelSelectionDetails.
        Patch Name.

        Allowed values for this property are: "LATEST", "LATEST_MINUS_ONE", "LATEST_MINUS_TWO", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The patch_level of this PatchLevelSelectionDetails.
        :rtype: str
        """
        return self._patch_level

    @patch_level.setter
    def patch_level(self, patch_level):
        """
        Sets the patch_level of this PatchLevelSelectionDetails.
        Patch Name.


        :param patch_level: The patch_level of this PatchLevelSelectionDetails.
        :type: str
        """
        allowed_values = ["LATEST", "LATEST_MINUS_ONE", "LATEST_MINUS_TWO"]
        if not value_allowed_none_or_none_sentinel(patch_level, allowed_values):
            patch_level = 'UNKNOWN_ENUM_VALUE'
        self._patch_level = patch_level

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
