# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SchedulerJobAggregation(object):
    """
    Aggregated summary information for SchedulerJob.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SchedulerJobAggregation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param count:
            The value to assign to the count property of this SchedulerJobAggregation.
        :type count: int

        :param dimensions:
            The value to assign to the dimensions property of this SchedulerJobAggregation.
        :type dimensions: oci.fleet_apps_management.models.SchedulerJobDimension

        """
        self.swagger_types = {
            'count': 'int',
            'dimensions': 'SchedulerJobDimension'
        }
        self.attribute_map = {
            'count': 'count',
            'dimensions': 'dimensions'
        }
        self._count = None
        self._dimensions = None

    @property
    def count(self):
        """
        **[Required]** Gets the count of this SchedulerJobAggregation.
        Count of jobs in a Compartment.


        :return: The count of this SchedulerJobAggregation.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this SchedulerJobAggregation.
        Count of jobs in a Compartment.


        :param count: The count of this SchedulerJobAggregation.
        :type: int
        """
        self._count = count

    @property
    def dimensions(self):
        """
        **[Required]** Gets the dimensions of this SchedulerJobAggregation.

        :return: The dimensions of this SchedulerJobAggregation.
        :rtype: oci.fleet_apps_management.models.SchedulerJobDimension
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this SchedulerJobAggregation.

        :param dimensions: The dimensions of this SchedulerJobAggregation.
        :type: oci.fleet_apps_management.models.SchedulerJobDimension
        """
        self._dimensions = dimensions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
