# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FsuActionProgressDetails(object):
    """
    Progress of the Action in execution. If the Exadata Fleet Update Action has not started yet, this will be omitted.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FsuActionProgressDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param in_progress_targets:
            The value to assign to the in_progress_targets property of this FsuActionProgressDetails.
        :type in_progress_targets: int

        :param completed_targets:
            The value to assign to the completed_targets property of this FsuActionProgressDetails.
        :type completed_targets: int

        :param failed_targets:
            The value to assign to the failed_targets property of this FsuActionProgressDetails.
        :type failed_targets: int

        :param waiting_targets:
            The value to assign to the waiting_targets property of this FsuActionProgressDetails.
        :type waiting_targets: int

        :param total_targets:
            The value to assign to the total_targets property of this FsuActionProgressDetails.
        :type total_targets: int

        """
        self.swagger_types = {
            'in_progress_targets': 'int',
            'completed_targets': 'int',
            'failed_targets': 'int',
            'waiting_targets': 'int',
            'total_targets': 'int'
        }
        self.attribute_map = {
            'in_progress_targets': 'inProgressTargets',
            'completed_targets': 'completedTargets',
            'failed_targets': 'failedTargets',
            'waiting_targets': 'waitingTargets',
            'total_targets': 'totalTargets'
        }
        self._in_progress_targets = None
        self._completed_targets = None
        self._failed_targets = None
        self._waiting_targets = None
        self._total_targets = None

    @property
    def in_progress_targets(self):
        """
        Gets the in_progress_targets of this FsuActionProgressDetails.
        Number of targets with jobs in progress.


        :return: The in_progress_targets of this FsuActionProgressDetails.
        :rtype: int
        """
        return self._in_progress_targets

    @in_progress_targets.setter
    def in_progress_targets(self, in_progress_targets):
        """
        Sets the in_progress_targets of this FsuActionProgressDetails.
        Number of targets with jobs in progress.


        :param in_progress_targets: The in_progress_targets of this FsuActionProgressDetails.
        :type: int
        """
        self._in_progress_targets = in_progress_targets

    @property
    def completed_targets(self):
        """
        Gets the completed_targets of this FsuActionProgressDetails.
        Number of targets with completed jobs.


        :return: The completed_targets of this FsuActionProgressDetails.
        :rtype: int
        """
        return self._completed_targets

    @completed_targets.setter
    def completed_targets(self, completed_targets):
        """
        Sets the completed_targets of this FsuActionProgressDetails.
        Number of targets with completed jobs.


        :param completed_targets: The completed_targets of this FsuActionProgressDetails.
        :type: int
        """
        self._completed_targets = completed_targets

    @property
    def failed_targets(self):
        """
        Gets the failed_targets of this FsuActionProgressDetails.
        Number of targets with failed jobs.


        :return: The failed_targets of this FsuActionProgressDetails.
        :rtype: int
        """
        return self._failed_targets

    @failed_targets.setter
    def failed_targets(self, failed_targets):
        """
        Sets the failed_targets of this FsuActionProgressDetails.
        Number of targets with failed jobs.


        :param failed_targets: The failed_targets of this FsuActionProgressDetails.
        :type: int
        """
        self._failed_targets = failed_targets

    @property
    def waiting_targets(self):
        """
        Gets the waiting_targets of this FsuActionProgressDetails.
        Number of targets with jobs waiting for batch to execute or for user to resume.


        :return: The waiting_targets of this FsuActionProgressDetails.
        :rtype: int
        """
        return self._waiting_targets

    @waiting_targets.setter
    def waiting_targets(self, waiting_targets):
        """
        Sets the waiting_targets of this FsuActionProgressDetails.
        Number of targets with jobs waiting for batch to execute or for user to resume.


        :param waiting_targets: The waiting_targets of this FsuActionProgressDetails.
        :type: int
        """
        self._waiting_targets = waiting_targets

    @property
    def total_targets(self):
        """
        Gets the total_targets of this FsuActionProgressDetails.
        Total number of targets impacted by Exadata Fleet Update Action.


        :return: The total_targets of this FsuActionProgressDetails.
        :rtype: int
        """
        return self._total_targets

    @total_targets.setter
    def total_targets(self, total_targets):
        """
        Sets the total_targets of this FsuActionProgressDetails.
        Total number of targets impacted by Exadata Fleet Update Action.


        :param total_targets: The total_targets of this FsuActionProgressDetails.
        :type: int
        """
        self._total_targets = total_targets

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
