# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .guest_os_fleet_discovery_details import GuestOsFleetDiscoveryDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GuestOsSearchQueryDiscovery(GuestOsFleetDiscoveryDetails):
    """
    Discover Exadata VM Cluster targets for a 'GUEST_OS' collection by querying `OCI Search Service`__ using specified query string.

    __ https://docs.cloud.oracle.com/Content/Search/Concepts/queryoverview.htm
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GuestOsSearchQueryDiscovery object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.GuestOsSearchQueryDiscovery.strategy` attribute
        of this class is ``SEARCH_QUERY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param strategy:
            The value to assign to the strategy property of this GuestOsSearchQueryDiscovery.
            Allowed values for this property are: "SEARCH_QUERY", "FILTERS", "TARGET_LIST", "DISCOVERY_RESULTS"
        :type strategy: str

        :param query:
            The value to assign to the query property of this GuestOsSearchQueryDiscovery.
        :type query: str

        """
        self.swagger_types = {
            'strategy': 'str',
            'query': 'str'
        }
        self.attribute_map = {
            'strategy': 'strategy',
            'query': 'query'
        }
        self._strategy = None
        self._query = None
        self._strategy = 'SEARCH_QUERY'

    @property
    def query(self):
        """
        **[Required]** Gets the query of this GuestOsSearchQueryDiscovery.
        `OCI Search Service`__ query string.

        __ https://docs.cloud.oracle.com/Content/Search/Concepts/queryoverview.htm


        :return: The query of this GuestOsSearchQueryDiscovery.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """
        Sets the query of this GuestOsSearchQueryDiscovery.
        `OCI Search Service`__ query string.

        __ https://docs.cloud.oracle.com/Content/Search/Concepts/queryoverview.htm


        :param query: The query of this GuestOsSearchQueryDiscovery.
        :type: str
        """
        self._query = query

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
