# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SessionConfig(object):
    """
    Session Configuration on AgentEndpoint.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SessionConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param idle_timeout_in_seconds:
            The value to assign to the idle_timeout_in_seconds property of this SessionConfig.
        :type idle_timeout_in_seconds: int

        """
        self.swagger_types = {
            'idle_timeout_in_seconds': 'int'
        }
        self.attribute_map = {
            'idle_timeout_in_seconds': 'idleTimeoutInSeconds'
        }
        self._idle_timeout_in_seconds = None

    @property
    def idle_timeout_in_seconds(self):
        """
        Gets the idle_timeout_in_seconds of this SessionConfig.
        The session will become inactive after this timeout.


        :return: The idle_timeout_in_seconds of this SessionConfig.
        :rtype: int
        """
        return self._idle_timeout_in_seconds

    @idle_timeout_in_seconds.setter
    def idle_timeout_in_seconds(self, idle_timeout_in_seconds):
        """
        Sets the idle_timeout_in_seconds of this SessionConfig.
        The session will become inactive after this timeout.


        :param idle_timeout_in_seconds: The idle_timeout_in_seconds of this SessionConfig.
        :type: int
        """
        self._idle_timeout_in_seconds = idle_timeout_in_seconds

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
