# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .required_action import RequiredAction
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HumanApprovalRequiredAction(RequiredAction):
    """
    An object describing human confirmation of tool execution that is required from the user.
    """

    #: A constant which can be used with the options property of a HumanApprovalRequiredAction.
    #: This constant has a value of "APPROVE"
    OPTIONS_APPROVE = "APPROVE"

    #: A constant which can be used with the options property of a HumanApprovalRequiredAction.
    #: This constant has a value of "DENY"
    OPTIONS_DENY = "DENY"

    def __init__(self, **kwargs):
        """
        Initializes a new HumanApprovalRequiredAction object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent_runtime.models.HumanApprovalRequiredAction.required_action_type` attribute
        of this class is ``HUMAN_APPROVAL_REQUIRED_ACTION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action_id:
            The value to assign to the action_id property of this HumanApprovalRequiredAction.
        :type action_id: str

        :param required_action_type:
            The value to assign to the required_action_type property of this HumanApprovalRequiredAction.
            Allowed values for this property are: "HUMAN_APPROVAL_REQUIRED_ACTION", "FUNCTION_CALLING_REQUIRED_ACTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type required_action_type: str

        :param message:
            The value to assign to the message property of this HumanApprovalRequiredAction.
        :type message: str

        :param options:
            The value to assign to the options property of this HumanApprovalRequiredAction.
            Allowed values for items in this list are: "APPROVE", "DENY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type options: list[str]

        """
        self.swagger_types = {
            'action_id': 'str',
            'required_action_type': 'str',
            'message': 'str',
            'options': 'list[str]'
        }
        self.attribute_map = {
            'action_id': 'actionId',
            'required_action_type': 'requiredActionType',
            'message': 'message',
            'options': 'options'
        }
        self._action_id = None
        self._required_action_type = None
        self._message = None
        self._options = None
        self._required_action_type = 'HUMAN_APPROVAL_REQUIRED_ACTION'

    @property
    def message(self):
        """
        **[Required]** Gets the message of this HumanApprovalRequiredAction.
        Message accompanying the human input request asking for approval or denial of a tool execution.


        :return: The message of this HumanApprovalRequiredAction.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this HumanApprovalRequiredAction.
        Message accompanying the human input request asking for approval or denial of a tool execution.


        :param message: The message of this HumanApprovalRequiredAction.
        :type: str
        """
        self._message = message

    @property
    def options(self):
        """
        **[Required]** Gets the options of this HumanApprovalRequiredAction.
        The options presented to the user approving and denying execution of the tool.

        Allowed values for items in this list are: "APPROVE", "DENY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The options of this HumanApprovalRequiredAction.
        :rtype: list[str]
        """
        return self._options

    @options.setter
    def options(self, options):
        """
        Sets the options of this HumanApprovalRequiredAction.
        The options presented to the user approving and denying execution of the tool.


        :param options: The options of this HumanApprovalRequiredAction.
        :type: list[str]
        """
        allowed_values = ["APPROVE", "DENY"]
        if options:
            options[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in options]
        self._options = options

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
