# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ParagraphCitation(object):
    """
    The source of information for the paragraph of agent's response.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ParagraphCitation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param paragraph:
            The value to assign to the paragraph property of this ParagraphCitation.
        :type paragraph: oci.generative_ai_agent_runtime.models.Paragraph

        :param citations:
            The value to assign to the citations property of this ParagraphCitation.
        :type citations: list[oci.generative_ai_agent_runtime.models.Citation]

        """
        self.swagger_types = {
            'paragraph': 'Paragraph',
            'citations': 'list[Citation]'
        }
        self.attribute_map = {
            'paragraph': 'paragraph',
            'citations': 'citations'
        }
        self._paragraph = None
        self._citations = None

    @property
    def paragraph(self):
        """
        **[Required]** Gets the paragraph of this ParagraphCitation.

        :return: The paragraph of this ParagraphCitation.
        :rtype: oci.generative_ai_agent_runtime.models.Paragraph
        """
        return self._paragraph

    @paragraph.setter
    def paragraph(self, paragraph):
        """
        Sets the paragraph of this ParagraphCitation.

        :param paragraph: The paragraph of this ParagraphCitation.
        :type: oci.generative_ai_agent_runtime.models.Paragraph
        """
        self._paragraph = paragraph

    @property
    def citations(self):
        """
        Gets the citations of this ParagraphCitation.
        A list of citations for the paragraph of the generated message.


        :return: The citations of this ParagraphCitation.
        :rtype: list[oci.generative_ai_agent_runtime.models.Citation]
        """
        return self._citations

    @citations.setter
    def citations(self, citations):
        """
        Sets the citations of this ParagraphCitation.
        A list of citations for the paragraph of the generated message.


        :param citations: The citations of this ParagraphCitation.
        :type: list[oci.generative_ai_agent_runtime.models.Citation]
        """
        self._citations = citations

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
