# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SqlResultFiles(object):
    """
    Specifies file locations for SQL result data.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SqlResultFiles object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param status_file:
            The value to assign to the status_file property of this SqlResultFiles.
        :type status_file: str

        :param data_file:
            The value to assign to the data_file property of this SqlResultFiles.
        :type data_file: str

        """
        self.swagger_types = {
            'status_file': 'str',
            'data_file': 'str'
        }
        self.attribute_map = {
            'status_file': 'statusFile',
            'data_file': 'dataFile'
        }
        self._status_file = None
        self._data_file = None

    @property
    def status_file(self):
        """
        Gets the status_file of this SqlResultFiles.
        Specifies the path or URL to status metadata.


        :return: The status_file of this SqlResultFiles.
        :rtype: str
        """
        return self._status_file

    @status_file.setter
    def status_file(self, status_file):
        """
        Sets the status_file of this SqlResultFiles.
        Specifies the path or URL to status metadata.


        :param status_file: The status_file of this SqlResultFiles.
        :type: str
        """
        self._status_file = status_file

    @property
    def data_file(self):
        """
        Gets the data_file of this SqlResultFiles.
        Specifies the path or URL to the full SQL result data.


        :return: The data_file of this SqlResultFiles.
        :rtype: str
        """
        return self._data_file

    @data_file.setter
    def data_file(self, data_file):
        """
        Sets the data_file of this SqlResultFiles.
        Specifies the path or URL to the full SQL result data.


        :param data_file: The data_file of this SqlResultFiles.
        :type: str
        """
        self._data_file = data_file

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
