# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .chat_content import ChatContent
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VideoContent(ChatContent):
    """
    Represents a single instance of chat video content.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VideoContent object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.VideoContent.type` attribute
        of this class is ``VIDEO`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this VideoContent.
            Allowed values for this property are: "TEXT", "IMAGE"
        :type type: str

        :param video_url:
            The value to assign to the video_url property of this VideoContent.
        :type video_url: oci.generative_ai_inference.models.VideoUrl

        """
        self.swagger_types = {
            'type': 'str',
            'video_url': 'VideoUrl'
        }
        self.attribute_map = {
            'type': 'type',
            'video_url': 'videoUrl'
        }
        self._type = None
        self._video_url = None
        self._type = 'VIDEO'

    @property
    def video_url(self):
        """
        Gets the video_url of this VideoContent.

        :return: The video_url of this VideoContent.
        :rtype: oci.generative_ai_inference.models.VideoUrl
        """
        return self._video_url

    @video_url.setter
    def video_url(self, video_url):
        """
        Sets the video_url of this VideoContent.

        :param video_url: The video_url of this VideoContent.
        :type: oci.generative_ai_inference.models.VideoUrl
        """
        self._video_url = video_url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
