# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateDeploymentDetails(object):
    """
    The information to use to update a Deployment.
    """

    #: A constant which can be used with the license_model property of a UpdateDeploymentDetails.
    #: This constant has a value of "LICENSE_INCLUDED"
    LICENSE_MODEL_LICENSE_INCLUDED = "LICENSE_INCLUDED"

    #: A constant which can be used with the license_model property of a UpdateDeploymentDetails.
    #: This constant has a value of "BRING_YOUR_OWN_LICENSE"
    LICENSE_MODEL_BRING_YOUR_OWN_LICENSE = "BRING_YOUR_OWN_LICENSE"

    #: A constant which can be used with the environment_type property of a UpdateDeploymentDetails.
    #: This constant has a value of "PRODUCTION"
    ENVIRONMENT_TYPE_PRODUCTION = "PRODUCTION"

    #: A constant which can be used with the environment_type property of a UpdateDeploymentDetails.
    #: This constant has a value of "DEVELOPMENT_OR_TESTING"
    ENVIRONMENT_TYPE_DEVELOPMENT_OR_TESTING = "DEVELOPMENT_OR_TESTING"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateDeploymentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateDeploymentDetails.
        :type display_name: str

        :param license_model:
            The value to assign to the license_model property of this UpdateDeploymentDetails.
            Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"
        :type license_model: str

        :param is_byol_cpu_core_count_limit_enabled:
            The value to assign to the is_byol_cpu_core_count_limit_enabled property of this UpdateDeploymentDetails.
        :type is_byol_cpu_core_count_limit_enabled: bool

        :param byol_cpu_core_count_limit:
            The value to assign to the byol_cpu_core_count_limit property of this UpdateDeploymentDetails.
        :type byol_cpu_core_count_limit: int

        :param environment_type:
            The value to assign to the environment_type property of this UpdateDeploymentDetails.
            Allowed values for this property are: "PRODUCTION", "DEVELOPMENT_OR_TESTING"
        :type environment_type: str

        :param description:
            The value to assign to the description property of this UpdateDeploymentDetails.
        :type description: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateDeploymentDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateDeploymentDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param nsg_ids:
            The value to assign to the nsg_ids property of this UpdateDeploymentDetails.
        :type nsg_ids: list[str]

        :param subnet_id:
            The value to assign to the subnet_id property of this UpdateDeploymentDetails.
        :type subnet_id: str

        :param load_balancer_subnet_id:
            The value to assign to the load_balancer_subnet_id property of this UpdateDeploymentDetails.
        :type load_balancer_subnet_id: str

        :param is_public:
            The value to assign to the is_public property of this UpdateDeploymentDetails.
        :type is_public: bool

        :param fqdn:
            The value to assign to the fqdn property of this UpdateDeploymentDetails.
        :type fqdn: str

        :param cpu_core_count:
            The value to assign to the cpu_core_count property of this UpdateDeploymentDetails.
        :type cpu_core_count: int

        :param is_auto_scaling_enabled:
            The value to assign to the is_auto_scaling_enabled property of this UpdateDeploymentDetails.
        :type is_auto_scaling_enabled: bool

        :param placements:
            The value to assign to the placements property of this UpdateDeploymentDetails.
        :type placements: list[oci.golden_gate.models.DeploymentPlacementDetails]

        :param ogg_data:
            The value to assign to the ogg_data property of this UpdateDeploymentDetails.
        :type ogg_data: oci.golden_gate.models.UpdateOggDeploymentDetails

        :param maintenance_window:
            The value to assign to the maintenance_window property of this UpdateDeploymentDetails.
        :type maintenance_window: oci.golden_gate.models.UpdateMaintenanceWindowDetails

        :param maintenance_configuration:
            The value to assign to the maintenance_configuration property of this UpdateDeploymentDetails.
        :type maintenance_configuration: oci.golden_gate.models.UpdateMaintenanceConfigurationDetails

        :param backup_schedule:
            The value to assign to the backup_schedule property of this UpdateDeploymentDetails.
        :type backup_schedule: oci.golden_gate.models.UpdateBackupScheduleDetails

        """
        self.swagger_types = {
            'display_name': 'str',
            'license_model': 'str',
            'is_byol_cpu_core_count_limit_enabled': 'bool',
            'byol_cpu_core_count_limit': 'int',
            'environment_type': 'str',
            'description': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'nsg_ids': 'list[str]',
            'subnet_id': 'str',
            'load_balancer_subnet_id': 'str',
            'is_public': 'bool',
            'fqdn': 'str',
            'cpu_core_count': 'int',
            'is_auto_scaling_enabled': 'bool',
            'placements': 'list[DeploymentPlacementDetails]',
            'ogg_data': 'UpdateOggDeploymentDetails',
            'maintenance_window': 'UpdateMaintenanceWindowDetails',
            'maintenance_configuration': 'UpdateMaintenanceConfigurationDetails',
            'backup_schedule': 'UpdateBackupScheduleDetails'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'license_model': 'licenseModel',
            'is_byol_cpu_core_count_limit_enabled': 'isByolCpuCoreCountLimitEnabled',
            'byol_cpu_core_count_limit': 'byolCpuCoreCountLimit',
            'environment_type': 'environmentType',
            'description': 'description',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'nsg_ids': 'nsgIds',
            'subnet_id': 'subnetId',
            'load_balancer_subnet_id': 'loadBalancerSubnetId',
            'is_public': 'isPublic',
            'fqdn': 'fqdn',
            'cpu_core_count': 'cpuCoreCount',
            'is_auto_scaling_enabled': 'isAutoScalingEnabled',
            'placements': 'placements',
            'ogg_data': 'oggData',
            'maintenance_window': 'maintenanceWindow',
            'maintenance_configuration': 'maintenanceConfiguration',
            'backup_schedule': 'backupSchedule'
        }
        self._display_name = None
        self._license_model = None
        self._is_byol_cpu_core_count_limit_enabled = None
        self._byol_cpu_core_count_limit = None
        self._environment_type = None
        self._description = None
        self._freeform_tags = None
        self._defined_tags = None
        self._nsg_ids = None
        self._subnet_id = None
        self._load_balancer_subnet_id = None
        self._is_public = None
        self._fqdn = None
        self._cpu_core_count = None
        self._is_auto_scaling_enabled = None
        self._placements = None
        self._ogg_data = None
        self._maintenance_window = None
        self._maintenance_configuration = None
        self._backup_schedule = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateDeploymentDetails.
        An object's Display Name.


        :return: The display_name of this UpdateDeploymentDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateDeploymentDetails.
        An object's Display Name.


        :param display_name: The display_name of this UpdateDeploymentDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def license_model(self):
        """
        Gets the license_model of this UpdateDeploymentDetails.
        The Oracle license model that applies to a Deployment.

        Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"


        :return: The license_model of this UpdateDeploymentDetails.
        :rtype: str
        """
        return self._license_model

    @license_model.setter
    def license_model(self, license_model):
        """
        Sets the license_model of this UpdateDeploymentDetails.
        The Oracle license model that applies to a Deployment.


        :param license_model: The license_model of this UpdateDeploymentDetails.
        :type: str
        """
        allowed_values = ["LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"]
        if not value_allowed_none_or_none_sentinel(license_model, allowed_values):
            raise ValueError(
                f"Invalid value for `license_model`, must be None or one of {allowed_values}"
            )
        self._license_model = license_model

    @property
    def is_byol_cpu_core_count_limit_enabled(self):
        """
        Gets the is_byol_cpu_core_count_limit_enabled of this UpdateDeploymentDetails.
        Flag to allow to configure the 'Bring Your Own License' (BYOL) license type CPU limit.
        If enabled, the exact number of CPUs must be provided via byolCpuCoreCountLimit.


        :return: The is_byol_cpu_core_count_limit_enabled of this UpdateDeploymentDetails.
        :rtype: bool
        """
        return self._is_byol_cpu_core_count_limit_enabled

    @is_byol_cpu_core_count_limit_enabled.setter
    def is_byol_cpu_core_count_limit_enabled(self, is_byol_cpu_core_count_limit_enabled):
        """
        Sets the is_byol_cpu_core_count_limit_enabled of this UpdateDeploymentDetails.
        Flag to allow to configure the 'Bring Your Own License' (BYOL) license type CPU limit.
        If enabled, the exact number of CPUs must be provided via byolCpuCoreCountLimit.


        :param is_byol_cpu_core_count_limit_enabled: The is_byol_cpu_core_count_limit_enabled of this UpdateDeploymentDetails.
        :type: bool
        """
        self._is_byol_cpu_core_count_limit_enabled = is_byol_cpu_core_count_limit_enabled

    @property
    def byol_cpu_core_count_limit(self):
        """
        Gets the byol_cpu_core_count_limit of this UpdateDeploymentDetails.
        The maximum number of CPUs allowed with a 'Bring Your Own License' (BYOL) license type.
        Any CPU usage above this limit is considered as License Included and billed.


        :return: The byol_cpu_core_count_limit of this UpdateDeploymentDetails.
        :rtype: int
        """
        return self._byol_cpu_core_count_limit

    @byol_cpu_core_count_limit.setter
    def byol_cpu_core_count_limit(self, byol_cpu_core_count_limit):
        """
        Sets the byol_cpu_core_count_limit of this UpdateDeploymentDetails.
        The maximum number of CPUs allowed with a 'Bring Your Own License' (BYOL) license type.
        Any CPU usage above this limit is considered as License Included and billed.


        :param byol_cpu_core_count_limit: The byol_cpu_core_count_limit of this UpdateDeploymentDetails.
        :type: int
        """
        self._byol_cpu_core_count_limit = byol_cpu_core_count_limit

    @property
    def environment_type(self):
        """
        Gets the environment_type of this UpdateDeploymentDetails.
        Specifies whether the deployment is used in a production or development/testing environment.

        Allowed values for this property are: "PRODUCTION", "DEVELOPMENT_OR_TESTING"


        :return: The environment_type of this UpdateDeploymentDetails.
        :rtype: str
        """
        return self._environment_type

    @environment_type.setter
    def environment_type(self, environment_type):
        """
        Sets the environment_type of this UpdateDeploymentDetails.
        Specifies whether the deployment is used in a production or development/testing environment.


        :param environment_type: The environment_type of this UpdateDeploymentDetails.
        :type: str
        """
        allowed_values = ["PRODUCTION", "DEVELOPMENT_OR_TESTING"]
        if not value_allowed_none_or_none_sentinel(environment_type, allowed_values):
            raise ValueError(
                f"Invalid value for `environment_type`, must be None or one of {allowed_values}"
            )
        self._environment_type = environment_type

    @property
    def description(self):
        """
        Gets the description of this UpdateDeploymentDetails.
        Metadata about this specific object.


        :return: The description of this UpdateDeploymentDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateDeploymentDetails.
        Metadata about this specific object.


        :param description: The description of this UpdateDeploymentDetails.
        :type: str
        """
        self._description = description

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateDeploymentDetails.
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists
        for cross-compatibility only.

        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateDeploymentDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateDeploymentDetails.
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists
        for cross-compatibility only.

        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateDeploymentDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateDeploymentDetails.
        Tags defined for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateDeploymentDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateDeploymentDetails.
        Tags defined for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateDeploymentDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this UpdateDeploymentDetails.
        An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.


        :return: The nsg_ids of this UpdateDeploymentDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this UpdateDeploymentDetails.
        An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.


        :param nsg_ids: The nsg_ids of this UpdateDeploymentDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this UpdateDeploymentDetails.
        The `OCID`__ of the subnet of the deployment's private endpoint.
        The subnet must be a private subnet. For backward compatibility, public subnets are allowed until May 31 2025,
        after which the private subnet will be enforced.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this UpdateDeploymentDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this UpdateDeploymentDetails.
        The `OCID`__ of the subnet of the deployment's private endpoint.
        The subnet must be a private subnet. For backward compatibility, public subnets are allowed until May 31 2025,
        after which the private subnet will be enforced.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this UpdateDeploymentDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def load_balancer_subnet_id(self):
        """
        Gets the load_balancer_subnet_id of this UpdateDeploymentDetails.
        The `OCID`__ of a public subnet in the customer tenancy.
        Can be provided only for public deployments. If provided, the loadbalancer will be created in this subnet instead of the service tenancy.
        For backward compatibility, this is an optional property. It will become mandatory for public deployments after October 1, 2024.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The load_balancer_subnet_id of this UpdateDeploymentDetails.
        :rtype: str
        """
        return self._load_balancer_subnet_id

    @load_balancer_subnet_id.setter
    def load_balancer_subnet_id(self, load_balancer_subnet_id):
        """
        Sets the load_balancer_subnet_id of this UpdateDeploymentDetails.
        The `OCID`__ of a public subnet in the customer tenancy.
        Can be provided only for public deployments. If provided, the loadbalancer will be created in this subnet instead of the service tenancy.
        For backward compatibility, this is an optional property. It will become mandatory for public deployments after October 1, 2024.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param load_balancer_subnet_id: The load_balancer_subnet_id of this UpdateDeploymentDetails.
        :type: str
        """
        self._load_balancer_subnet_id = load_balancer_subnet_id

    @property
    def is_public(self):
        """
        Gets the is_public of this UpdateDeploymentDetails.
        True if this object is publicly available.


        :return: The is_public of this UpdateDeploymentDetails.
        :rtype: bool
        """
        return self._is_public

    @is_public.setter
    def is_public(self, is_public):
        """
        Sets the is_public of this UpdateDeploymentDetails.
        True if this object is publicly available.


        :param is_public: The is_public of this UpdateDeploymentDetails.
        :type: bool
        """
        self._is_public = is_public

    @property
    def fqdn(self):
        """
        Gets the fqdn of this UpdateDeploymentDetails.
        A three-label Fully Qualified Domain Name (FQDN) for a resource.


        :return: The fqdn of this UpdateDeploymentDetails.
        :rtype: str
        """
        return self._fqdn

    @fqdn.setter
    def fqdn(self, fqdn):
        """
        Sets the fqdn of this UpdateDeploymentDetails.
        A three-label Fully Qualified Domain Name (FQDN) for a resource.


        :param fqdn: The fqdn of this UpdateDeploymentDetails.
        :type: str
        """
        self._fqdn = fqdn

    @property
    def cpu_core_count(self):
        """
        Gets the cpu_core_count of this UpdateDeploymentDetails.
        The Minimum number of OCPUs to be made available for this Deployment.


        :return: The cpu_core_count of this UpdateDeploymentDetails.
        :rtype: int
        """
        return self._cpu_core_count

    @cpu_core_count.setter
    def cpu_core_count(self, cpu_core_count):
        """
        Sets the cpu_core_count of this UpdateDeploymentDetails.
        The Minimum number of OCPUs to be made available for this Deployment.


        :param cpu_core_count: The cpu_core_count of this UpdateDeploymentDetails.
        :type: int
        """
        self._cpu_core_count = cpu_core_count

    @property
    def is_auto_scaling_enabled(self):
        """
        Gets the is_auto_scaling_enabled of this UpdateDeploymentDetails.
        Indicates if auto scaling is enabled for the Deployment's CPU core count.


        :return: The is_auto_scaling_enabled of this UpdateDeploymentDetails.
        :rtype: bool
        """
        return self._is_auto_scaling_enabled

    @is_auto_scaling_enabled.setter
    def is_auto_scaling_enabled(self, is_auto_scaling_enabled):
        """
        Sets the is_auto_scaling_enabled of this UpdateDeploymentDetails.
        Indicates if auto scaling is enabled for the Deployment's CPU core count.


        :param is_auto_scaling_enabled: The is_auto_scaling_enabled of this UpdateDeploymentDetails.
        :type: bool
        """
        self._is_auto_scaling_enabled = is_auto_scaling_enabled

    @property
    def placements(self):
        """
        Gets the placements of this UpdateDeploymentDetails.
        An array of local peers of deployment


        :return: The placements of this UpdateDeploymentDetails.
        :rtype: list[oci.golden_gate.models.DeploymentPlacementDetails]
        """
        return self._placements

    @placements.setter
    def placements(self, placements):
        """
        Sets the placements of this UpdateDeploymentDetails.
        An array of local peers of deployment


        :param placements: The placements of this UpdateDeploymentDetails.
        :type: list[oci.golden_gate.models.DeploymentPlacementDetails]
        """
        self._placements = placements

    @property
    def ogg_data(self):
        """
        Gets the ogg_data of this UpdateDeploymentDetails.

        :return: The ogg_data of this UpdateDeploymentDetails.
        :rtype: oci.golden_gate.models.UpdateOggDeploymentDetails
        """
        return self._ogg_data

    @ogg_data.setter
    def ogg_data(self, ogg_data):
        """
        Sets the ogg_data of this UpdateDeploymentDetails.

        :param ogg_data: The ogg_data of this UpdateDeploymentDetails.
        :type: oci.golden_gate.models.UpdateOggDeploymentDetails
        """
        self._ogg_data = ogg_data

    @property
    def maintenance_window(self):
        """
        Gets the maintenance_window of this UpdateDeploymentDetails.

        :return: The maintenance_window of this UpdateDeploymentDetails.
        :rtype: oci.golden_gate.models.UpdateMaintenanceWindowDetails
        """
        return self._maintenance_window

    @maintenance_window.setter
    def maintenance_window(self, maintenance_window):
        """
        Sets the maintenance_window of this UpdateDeploymentDetails.

        :param maintenance_window: The maintenance_window of this UpdateDeploymentDetails.
        :type: oci.golden_gate.models.UpdateMaintenanceWindowDetails
        """
        self._maintenance_window = maintenance_window

    @property
    def maintenance_configuration(self):
        """
        Gets the maintenance_configuration of this UpdateDeploymentDetails.

        :return: The maintenance_configuration of this UpdateDeploymentDetails.
        :rtype: oci.golden_gate.models.UpdateMaintenanceConfigurationDetails
        """
        return self._maintenance_configuration

    @maintenance_configuration.setter
    def maintenance_configuration(self, maintenance_configuration):
        """
        Sets the maintenance_configuration of this UpdateDeploymentDetails.

        :param maintenance_configuration: The maintenance_configuration of this UpdateDeploymentDetails.
        :type: oci.golden_gate.models.UpdateMaintenanceConfigurationDetails
        """
        self._maintenance_configuration = maintenance_configuration

    @property
    def backup_schedule(self):
        """
        Gets the backup_schedule of this UpdateDeploymentDetails.

        :return: The backup_schedule of this UpdateDeploymentDetails.
        :rtype: oci.golden_gate.models.UpdateBackupScheduleDetails
        """
        return self._backup_schedule

    @backup_schedule.setter
    def backup_schedule(self, backup_schedule):
        """
        Sets the backup_schedule of this UpdateDeploymentDetails.

        :param backup_schedule: The backup_schedule of this UpdateDeploymentDetails.
        :type: oci.golden_gate.models.UpdateBackupScheduleDetails
        """
        self._backup_schedule = backup_schedule

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
