# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JavaLicenseAcceptanceRecord(object):
    """
    User acceptance record for a Java license.
    """

    #: A constant which can be used with the license_acceptance_status property of a JavaLicenseAcceptanceRecord.
    #: This constant has a value of "ACCEPTED"
    LICENSE_ACCEPTANCE_STATUS_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the license_acceptance_status property of a JavaLicenseAcceptanceRecord.
    #: This constant has a value of "REVOKED"
    LICENSE_ACCEPTANCE_STATUS_REVOKED = "REVOKED"

    #: A constant which can be used with the license_type property of a JavaLicenseAcceptanceRecord.
    #: This constant has a value of "OTN"
    LICENSE_TYPE_OTN = "OTN"

    #: A constant which can be used with the license_type property of a JavaLicenseAcceptanceRecord.
    #: This constant has a value of "NFTC"
    LICENSE_TYPE_NFTC = "NFTC"

    #: A constant which can be used with the license_type property of a JavaLicenseAcceptanceRecord.
    #: This constant has a value of "BCL"
    LICENSE_TYPE_BCL = "BCL"

    #: A constant which can be used with the license_type property of a JavaLicenseAcceptanceRecord.
    #: This constant has a value of "RESTRICTED"
    LICENSE_TYPE_RESTRICTED = "RESTRICTED"

    #: A constant which can be used with the lifecycle_state property of a JavaLicenseAcceptanceRecord.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a JavaLicenseAcceptanceRecord.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a JavaLicenseAcceptanceRecord.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a JavaLicenseAcceptanceRecord.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a JavaLicenseAcceptanceRecord.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a JavaLicenseAcceptanceRecord.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a JavaLicenseAcceptanceRecord.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    def __init__(self, **kwargs):
        """
        Initializes a new JavaLicenseAcceptanceRecord object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this JavaLicenseAcceptanceRecord.
        :type id: str

        :param license_acceptance_status:
            The value to assign to the license_acceptance_status property of this JavaLicenseAcceptanceRecord.
            Allowed values for this property are: "ACCEPTED", "REVOKED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type license_acceptance_status: str

        :param compartment_id:
            The value to assign to the compartment_id property of this JavaLicenseAcceptanceRecord.
        :type compartment_id: str

        :param license_type:
            The value to assign to the license_type property of this JavaLicenseAcceptanceRecord.
            Allowed values for this property are: "OTN", "NFTC", "BCL", "RESTRICTED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type license_type: str

        :param created_by:
            The value to assign to the created_by property of this JavaLicenseAcceptanceRecord.
        :type created_by: oci.jms_java_downloads.models.Principal

        :param last_updated_by:
            The value to assign to the last_updated_by property of this JavaLicenseAcceptanceRecord.
        :type last_updated_by: oci.jms_java_downloads.models.Principal

        :param time_accepted:
            The value to assign to the time_accepted property of this JavaLicenseAcceptanceRecord.
        :type time_accepted: datetime

        :param time_last_updated:
            The value to assign to the time_last_updated property of this JavaLicenseAcceptanceRecord.
        :type time_last_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this JavaLicenseAcceptanceRecord.
            Allowed values for this property are: "ACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "NEEDS_ATTENTION", "UPDATING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this JavaLicenseAcceptanceRecord.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this JavaLicenseAcceptanceRecord.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this JavaLicenseAcceptanceRecord.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'license_acceptance_status': 'str',
            'compartment_id': 'str',
            'license_type': 'str',
            'created_by': 'Principal',
            'last_updated_by': 'Principal',
            'time_accepted': 'datetime',
            'time_last_updated': 'datetime',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'license_acceptance_status': 'licenseAcceptanceStatus',
            'compartment_id': 'compartmentId',
            'license_type': 'licenseType',
            'created_by': 'createdBy',
            'last_updated_by': 'lastUpdatedBy',
            'time_accepted': 'timeAccepted',
            'time_last_updated': 'timeLastUpdated',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._license_acceptance_status = None
        self._compartment_id = None
        self._license_type = None
        self._created_by = None
        self._last_updated_by = None
        self._time_accepted = None
        self._time_last_updated = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this JavaLicenseAcceptanceRecord.
        The unique identifier for the acceptance record.


        :return: The id of this JavaLicenseAcceptanceRecord.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this JavaLicenseAcceptanceRecord.
        The unique identifier for the acceptance record.


        :param id: The id of this JavaLicenseAcceptanceRecord.
        :type: str
        """
        self._id = id

    @property
    def license_acceptance_status(self):
        """
        **[Required]** Gets the license_acceptance_status of this JavaLicenseAcceptanceRecord.
        Status of license acceptance.

        Allowed values for this property are: "ACCEPTED", "REVOKED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The license_acceptance_status of this JavaLicenseAcceptanceRecord.
        :rtype: str
        """
        return self._license_acceptance_status

    @license_acceptance_status.setter
    def license_acceptance_status(self, license_acceptance_status):
        """
        Sets the license_acceptance_status of this JavaLicenseAcceptanceRecord.
        Status of license acceptance.


        :param license_acceptance_status: The license_acceptance_status of this JavaLicenseAcceptanceRecord.
        :type: str
        """
        allowed_values = ["ACCEPTED", "REVOKED"]
        if not value_allowed_none_or_none_sentinel(license_acceptance_status, allowed_values):
            license_acceptance_status = 'UNKNOWN_ENUM_VALUE'
        self._license_acceptance_status = license_acceptance_status

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this JavaLicenseAcceptanceRecord.
        The tenancy `OCID`__ of the user accepting the license.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this JavaLicenseAcceptanceRecord.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this JavaLicenseAcceptanceRecord.
        The tenancy `OCID`__ of the user accepting the license.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this JavaLicenseAcceptanceRecord.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def license_type(self):
        """
        **[Required]** Gets the license_type of this JavaLicenseAcceptanceRecord.
        License type associated with the acceptance.

        Allowed values for this property are: "OTN", "NFTC", "BCL", "RESTRICTED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The license_type of this JavaLicenseAcceptanceRecord.
        :rtype: str
        """
        return self._license_type

    @license_type.setter
    def license_type(self, license_type):
        """
        Sets the license_type of this JavaLicenseAcceptanceRecord.
        License type associated with the acceptance.


        :param license_type: The license_type of this JavaLicenseAcceptanceRecord.
        :type: str
        """
        allowed_values = ["OTN", "NFTC", "BCL", "RESTRICTED"]
        if not value_allowed_none_or_none_sentinel(license_type, allowed_values):
            license_type = 'UNKNOWN_ENUM_VALUE'
        self._license_type = license_type

    @property
    def created_by(self):
        """
        **[Required]** Gets the created_by of this JavaLicenseAcceptanceRecord.

        :return: The created_by of this JavaLicenseAcceptanceRecord.
        :rtype: oci.jms_java_downloads.models.Principal
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this JavaLicenseAcceptanceRecord.

        :param created_by: The created_by of this JavaLicenseAcceptanceRecord.
        :type: oci.jms_java_downloads.models.Principal
        """
        self._created_by = created_by

    @property
    def last_updated_by(self):
        """
        Gets the last_updated_by of this JavaLicenseAcceptanceRecord.

        :return: The last_updated_by of this JavaLicenseAcceptanceRecord.
        :rtype: oci.jms_java_downloads.models.Principal
        """
        return self._last_updated_by

    @last_updated_by.setter
    def last_updated_by(self, last_updated_by):
        """
        Sets the last_updated_by of this JavaLicenseAcceptanceRecord.

        :param last_updated_by: The last_updated_by of this JavaLicenseAcceptanceRecord.
        :type: oci.jms_java_downloads.models.Principal
        """
        self._last_updated_by = last_updated_by

    @property
    def time_accepted(self):
        """
        **[Required]** Gets the time_accepted of this JavaLicenseAcceptanceRecord.
        The date and time of license acceptance (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_accepted of this JavaLicenseAcceptanceRecord.
        :rtype: datetime
        """
        return self._time_accepted

    @time_accepted.setter
    def time_accepted(self, time_accepted):
        """
        Sets the time_accepted of this JavaLicenseAcceptanceRecord.
        The date and time of license acceptance (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_accepted: The time_accepted of this JavaLicenseAcceptanceRecord.
        :type: datetime
        """
        self._time_accepted = time_accepted

    @property
    def time_last_updated(self):
        """
        Gets the time_last_updated of this JavaLicenseAcceptanceRecord.
        The date and time of last update (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_last_updated of this JavaLicenseAcceptanceRecord.
        :rtype: datetime
        """
        return self._time_last_updated

    @time_last_updated.setter
    def time_last_updated(self, time_last_updated):
        """
        Sets the time_last_updated of this JavaLicenseAcceptanceRecord.
        The date and time of last update (formatted according to `RFC3339`__).

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_last_updated: The time_last_updated of this JavaLicenseAcceptanceRecord.
        :type: datetime
        """
        self._time_last_updated = time_last_updated

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this JavaLicenseAcceptanceRecord.
        The current state of the JavaLicenseAcceptanceRecord.

        Allowed values for this property are: "ACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "NEEDS_ATTENTION", "UPDATING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this JavaLicenseAcceptanceRecord.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this JavaLicenseAcceptanceRecord.
        The current state of the JavaLicenseAcceptanceRecord.


        :param lifecycle_state: The lifecycle_state of this JavaLicenseAcceptanceRecord.
        :type: str
        """
        allowed_values = ["ACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "NEEDS_ATTENTION", "UPDATING"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this JavaLicenseAcceptanceRecord.
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`. (See `Managing Tags and Tag Namespaces`__.)

        __ https://docs.cloud.oracle.com/Content/Tagging/Concepts/understandingfreeformtags.htm


        :return: The freeform_tags of this JavaLicenseAcceptanceRecord.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this JavaLicenseAcceptanceRecord.
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`. (See `Managing Tags and Tag Namespaces`__.)

        __ https://docs.cloud.oracle.com/Content/Tagging/Concepts/understandingfreeformtags.htm


        :param freeform_tags: The freeform_tags of this JavaLicenseAcceptanceRecord.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this JavaLicenseAcceptanceRecord.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`. (See `Understanding Free-form Tags`__).

        __ https://docs.cloud.oracle.com/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm


        :return: The defined_tags of this JavaLicenseAcceptanceRecord.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this JavaLicenseAcceptanceRecord.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`. (See `Understanding Free-form Tags`__).

        __ https://docs.cloud.oracle.com/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm


        :param defined_tags: The defined_tags of this JavaLicenseAcceptanceRecord.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this JavaLicenseAcceptanceRecord.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this JavaLicenseAcceptanceRecord.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this JavaLicenseAcceptanceRecord.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this JavaLicenseAcceptanceRecord.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
