# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250521


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JavaMigrationAnalysisSummary(object):
    """
    Summary information about a Java Migration Analysis.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new JavaMigrationAnalysisSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this JavaMigrationAnalysisSummary.
        :type id: str

        :param work_request_id:
            The value to assign to the work_request_id property of this JavaMigrationAnalysisSummary.
        :type work_request_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this JavaMigrationAnalysisSummary.
        :type compartment_id: str

        :param analysis_project_name:
            The value to assign to the analysis_project_name property of this JavaMigrationAnalysisSummary.
        :type analysis_project_name: str

        :param input_applications_object_storage_paths:
            The value to assign to the input_applications_object_storage_paths property of this JavaMigrationAnalysisSummary.
        :type input_applications_object_storage_paths: list[str]

        :param target_jdk_version:
            The value to assign to the target_jdk_version property of this JavaMigrationAnalysisSummary.
        :type target_jdk_version: str

        :param namespace_name:
            The value to assign to the namespace_name property of this JavaMigrationAnalysisSummary.
        :type namespace_name: str

        :param bucket_name:
            The value to assign to the bucket_name property of this JavaMigrationAnalysisSummary.
        :type bucket_name: str

        :param analysis_result_object_storage_path:
            The value to assign to the analysis_result_object_storage_path property of this JavaMigrationAnalysisSummary.
        :type analysis_result_object_storage_path: str

        :param analysis_result_files:
            The value to assign to the analysis_result_files property of this JavaMigrationAnalysisSummary.
        :type analysis_result_files: list[str]

        :param time_created:
            The value to assign to the time_created property of this JavaMigrationAnalysisSummary.
        :type time_created: datetime

        :param time_started:
            The value to assign to the time_started property of this JavaMigrationAnalysisSummary.
        :type time_started: datetime

        :param time_finished:
            The value to assign to the time_finished property of this JavaMigrationAnalysisSummary.
        :type time_finished: datetime

        :param created_by:
            The value to assign to the created_by property of this JavaMigrationAnalysisSummary.
        :type created_by: oci.jms_utils.models.Principal

        :param metadata:
            The value to assign to the metadata property of this JavaMigrationAnalysisSummary.
        :type metadata: str

        """
        self.swagger_types = {
            'id': 'str',
            'work_request_id': 'str',
            'compartment_id': 'str',
            'analysis_project_name': 'str',
            'input_applications_object_storage_paths': 'list[str]',
            'target_jdk_version': 'str',
            'namespace_name': 'str',
            'bucket_name': 'str',
            'analysis_result_object_storage_path': 'str',
            'analysis_result_files': 'list[str]',
            'time_created': 'datetime',
            'time_started': 'datetime',
            'time_finished': 'datetime',
            'created_by': 'Principal',
            'metadata': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'work_request_id': 'workRequestId',
            'compartment_id': 'compartmentId',
            'analysis_project_name': 'analysisProjectName',
            'input_applications_object_storage_paths': 'inputApplicationsObjectStoragePaths',
            'target_jdk_version': 'targetJdkVersion',
            'namespace_name': 'namespaceName',
            'bucket_name': 'bucketName',
            'analysis_result_object_storage_path': 'analysisResultObjectStoragePath',
            'analysis_result_files': 'analysisResultFiles',
            'time_created': 'timeCreated',
            'time_started': 'timeStarted',
            'time_finished': 'timeFinished',
            'created_by': 'createdBy',
            'metadata': 'metadata'
        }
        self._id = None
        self._work_request_id = None
        self._compartment_id = None
        self._analysis_project_name = None
        self._input_applications_object_storage_paths = None
        self._target_jdk_version = None
        self._namespace_name = None
        self._bucket_name = None
        self._analysis_result_object_storage_path = None
        self._analysis_result_files = None
        self._time_created = None
        self._time_started = None
        self._time_finished = None
        self._created_by = None
        self._metadata = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this JavaMigrationAnalysisSummary.
        The `OCID`__ of the Java Migration Analysis.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this JavaMigrationAnalysisSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this JavaMigrationAnalysisSummary.
        The `OCID`__ of the Java Migration Analysis.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this JavaMigrationAnalysisSummary.
        :type: str
        """
        self._id = id

    @property
    def work_request_id(self):
        """
        **[Required]** Gets the work_request_id of this JavaMigrationAnalysisSummary.
        The `OCID`__ of the Work Request.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The work_request_id of this JavaMigrationAnalysisSummary.
        :rtype: str
        """
        return self._work_request_id

    @work_request_id.setter
    def work_request_id(self, work_request_id):
        """
        Sets the work_request_id of this JavaMigrationAnalysisSummary.
        The `OCID`__ of the Work Request.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param work_request_id: The work_request_id of this JavaMigrationAnalysisSummary.
        :type: str
        """
        self._work_request_id = work_request_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this JavaMigrationAnalysisSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this JavaMigrationAnalysisSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this JavaMigrationAnalysisSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this JavaMigrationAnalysisSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def analysis_project_name(self):
        """
        **[Required]** Gets the analysis_project_name of this JavaMigrationAnalysisSummary.
        Name of the analysis project.


        :return: The analysis_project_name of this JavaMigrationAnalysisSummary.
        :rtype: str
        """
        return self._analysis_project_name

    @analysis_project_name.setter
    def analysis_project_name(self, analysis_project_name):
        """
        Sets the analysis_project_name of this JavaMigrationAnalysisSummary.
        Name of the analysis project.


        :param analysis_project_name: The analysis_project_name of this JavaMigrationAnalysisSummary.
        :type: str
        """
        self._analysis_project_name = analysis_project_name

    @property
    def input_applications_object_storage_paths(self):
        """
        **[Required]** Gets the input_applications_object_storage_paths of this JavaMigrationAnalysisSummary.
        Object storage paths to the input files applications to be analysed.


        :return: The input_applications_object_storage_paths of this JavaMigrationAnalysisSummary.
        :rtype: list[str]
        """
        return self._input_applications_object_storage_paths

    @input_applications_object_storage_paths.setter
    def input_applications_object_storage_paths(self, input_applications_object_storage_paths):
        """
        Sets the input_applications_object_storage_paths of this JavaMigrationAnalysisSummary.
        Object storage paths to the input files applications to be analysed.


        :param input_applications_object_storage_paths: The input_applications_object_storage_paths of this JavaMigrationAnalysisSummary.
        :type: list[str]
        """
        self._input_applications_object_storage_paths = input_applications_object_storage_paths

    @property
    def target_jdk_version(self):
        """
        **[Required]** Gets the target_jdk_version of this JavaMigrationAnalysisSummary.
        Jdk Version of the Java Migration Analysis target.


        :return: The target_jdk_version of this JavaMigrationAnalysisSummary.
        :rtype: str
        """
        return self._target_jdk_version

    @target_jdk_version.setter
    def target_jdk_version(self, target_jdk_version):
        """
        Sets the target_jdk_version of this JavaMigrationAnalysisSummary.
        Jdk Version of the Java Migration Analysis target.


        :param target_jdk_version: The target_jdk_version of this JavaMigrationAnalysisSummary.
        :type: str
        """
        self._target_jdk_version = target_jdk_version

    @property
    def namespace_name(self):
        """
        **[Required]** Gets the namespace_name of this JavaMigrationAnalysisSummary.
        Object storage namespace.


        :return: The namespace_name of this JavaMigrationAnalysisSummary.
        :rtype: str
        """
        return self._namespace_name

    @namespace_name.setter
    def namespace_name(self, namespace_name):
        """
        Sets the namespace_name of this JavaMigrationAnalysisSummary.
        Object storage namespace.


        :param namespace_name: The namespace_name of this JavaMigrationAnalysisSummary.
        :type: str
        """
        self._namespace_name = namespace_name

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this JavaMigrationAnalysisSummary.
        Object storage bucket name.


        :return: The bucket_name of this JavaMigrationAnalysisSummary.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this JavaMigrationAnalysisSummary.
        Object storage bucket name.


        :param bucket_name: The bucket_name of this JavaMigrationAnalysisSummary.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def analysis_result_object_storage_path(self):
        """
        **[Required]** Gets the analysis_result_object_storage_path of this JavaMigrationAnalysisSummary.
        Path to the Object Storage analysis application result.


        :return: The analysis_result_object_storage_path of this JavaMigrationAnalysisSummary.
        :rtype: str
        """
        return self._analysis_result_object_storage_path

    @analysis_result_object_storage_path.setter
    def analysis_result_object_storage_path(self, analysis_result_object_storage_path):
        """
        Sets the analysis_result_object_storage_path of this JavaMigrationAnalysisSummary.
        Path to the Object Storage analysis application result.


        :param analysis_result_object_storage_path: The analysis_result_object_storage_path of this JavaMigrationAnalysisSummary.
        :type: str
        """
        self._analysis_result_object_storage_path = analysis_result_object_storage_path

    @property
    def analysis_result_files(self):
        """
        **[Required]** Gets the analysis_result_files of this JavaMigrationAnalysisSummary.
        The analysis application file names result in the Object Storage.


        :return: The analysis_result_files of this JavaMigrationAnalysisSummary.
        :rtype: list[str]
        """
        return self._analysis_result_files

    @analysis_result_files.setter
    def analysis_result_files(self, analysis_result_files):
        """
        Sets the analysis_result_files of this JavaMigrationAnalysisSummary.
        The analysis application file names result in the Object Storage.


        :param analysis_result_files: The analysis_result_files of this JavaMigrationAnalysisSummary.
        :type: list[str]
        """
        self._analysis_result_files = analysis_result_files

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this JavaMigrationAnalysisSummary.
        The date and time the Java Migration Analysis was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this JavaMigrationAnalysisSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this JavaMigrationAnalysisSummary.
        The date and time the Java Migration Analysis was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this JavaMigrationAnalysisSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_started(self):
        """
        **[Required]** Gets the time_started of this JavaMigrationAnalysisSummary.
        The date and time the Java Migration Analysis was started, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_started of this JavaMigrationAnalysisSummary.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this JavaMigrationAnalysisSummary.
        The date and time the Java Migration Analysis was started, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_started: The time_started of this JavaMigrationAnalysisSummary.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_finished(self):
        """
        **[Required]** Gets the time_finished of this JavaMigrationAnalysisSummary.
        The date and time the Java Migration Analysis was finished, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_finished of this JavaMigrationAnalysisSummary.
        :rtype: datetime
        """
        return self._time_finished

    @time_finished.setter
    def time_finished(self, time_finished):
        """
        Sets the time_finished of this JavaMigrationAnalysisSummary.
        The date and time the Java Migration Analysis was finished, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_finished: The time_finished of this JavaMigrationAnalysisSummary.
        :type: datetime
        """
        self._time_finished = time_finished

    @property
    def created_by(self):
        """
        **[Required]** Gets the created_by of this JavaMigrationAnalysisSummary.

        :return: The created_by of this JavaMigrationAnalysisSummary.
        :rtype: oci.jms_utils.models.Principal
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this JavaMigrationAnalysisSummary.

        :param created_by: The created_by of this JavaMigrationAnalysisSummary.
        :type: oci.jms_utils.models.Principal
        """
        self._created_by = created_by

    @property
    def metadata(self):
        """
        Gets the metadata of this JavaMigrationAnalysisSummary.
        Additional info reserved for future use.


        :return: The metadata of this JavaMigrationAnalysisSummary.
        :rtype: str
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this JavaMigrationAnalysisSummary.
        Additional info reserved for future use.


        :param metadata: The metadata of this JavaMigrationAnalysisSummary.
        :type: str
        """
        self._metadata = metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
