# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250521

from .work_item_details import WorkItemDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PerformanceTuningWorkItemDetails(WorkItemDetails):
    """
    The performance tuning work item details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PerformanceTuningWorkItemDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.jms_utils.models.PerformanceTuningWorkItemDetails.kind` attribute
        of this class is ``PERFORMANCE_TUNING`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kind:
            The value to assign to the kind property of this PerformanceTuningWorkItemDetails.
            Allowed values for this property are: "BASIC", "JAVA_MIGRATION", "PERFORMANCE_TUNING"
        :type kind: str

        :param work_item_type:
            The value to assign to the work_item_type property of this PerformanceTuningWorkItemDetails.
            Allowed values for this property are: "PERFORMANCE_TUNING", "JAVA_MIGRATION"
        :type work_item_type: str

        :param artifact_object_storage_path:
            The value to assign to the artifact_object_storage_path property of this PerformanceTuningWorkItemDetails.
        :type artifact_object_storage_path: str

        :param analysis_project_name:
            The value to assign to the analysis_project_name property of this PerformanceTuningWorkItemDetails.
        :type analysis_project_name: str

        """
        self.swagger_types = {
            'kind': 'str',
            'work_item_type': 'str',
            'artifact_object_storage_path': 'str',
            'analysis_project_name': 'str'
        }
        self.attribute_map = {
            'kind': 'kind',
            'work_item_type': 'workItemType',
            'artifact_object_storage_path': 'artifactObjectStoragePath',
            'analysis_project_name': 'analysisProjectName'
        }
        self._kind = None
        self._work_item_type = None
        self._artifact_object_storage_path = None
        self._analysis_project_name = None
        self._kind = 'PERFORMANCE_TUNING'

    @property
    def artifact_object_storage_path(self):
        """
        **[Required]** Gets the artifact_object_storage_path of this PerformanceTuningWorkItemDetails.
        Object storage path to the artifact.


        :return: The artifact_object_storage_path of this PerformanceTuningWorkItemDetails.
        :rtype: str
        """
        return self._artifact_object_storage_path

    @artifact_object_storage_path.setter
    def artifact_object_storage_path(self, artifact_object_storage_path):
        """
        Sets the artifact_object_storage_path of this PerformanceTuningWorkItemDetails.
        Object storage path to the artifact.


        :param artifact_object_storage_path: The artifact_object_storage_path of this PerformanceTuningWorkItemDetails.
        :type: str
        """
        self._artifact_object_storage_path = artifact_object_storage_path

    @property
    def analysis_project_name(self):
        """
        **[Required]** Gets the analysis_project_name of this PerformanceTuningWorkItemDetails.
        Name of the analysis project.


        :return: The analysis_project_name of this PerformanceTuningWorkItemDetails.
        :rtype: str
        """
        return self._analysis_project_name

    @analysis_project_name.setter
    def analysis_project_name(self, analysis_project_name):
        """
        Sets the analysis_project_name of this PerformanceTuningWorkItemDetails.
        Name of the analysis project.


        :param analysis_project_name: The analysis_project_name of this PerformanceTuningWorkItemDetails.
        :type: str
        """
        self._analysis_project_name = analysis_project_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
