# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RecalledDataSize(object):
    """
    This is the recall related data size for the given timeframe
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RecalledDataSize object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_data_started:
            The value to assign to the time_data_started property of this RecalledDataSize.
        :type time_data_started: datetime

        :param time_data_ended:
            The value to assign to the time_data_ended property of this RecalledDataSize.
        :type time_data_ended: datetime

        :param recalled_data_in_bytes:
            The value to assign to the recalled_data_in_bytes property of this RecalledDataSize.
        :type recalled_data_in_bytes: int

        :param not_recalled_data_in_bytes:
            The value to assign to the not_recalled_data_in_bytes property of this RecalledDataSize.
        :type not_recalled_data_in_bytes: int

        """
        self.swagger_types = {
            'time_data_started': 'datetime',
            'time_data_ended': 'datetime',
            'recalled_data_in_bytes': 'int',
            'not_recalled_data_in_bytes': 'int'
        }
        self.attribute_map = {
            'time_data_started': 'timeDataStarted',
            'time_data_ended': 'timeDataEnded',
            'recalled_data_in_bytes': 'recalledDataInBytes',
            'not_recalled_data_in_bytes': 'notRecalledDataInBytes'
        }
        self._time_data_started = None
        self._time_data_ended = None
        self._recalled_data_in_bytes = None
        self._not_recalled_data_in_bytes = None

    @property
    def time_data_started(self):
        """
        **[Required]** Gets the time_data_started of this RecalledDataSize.
        This is the start of the time range of the archival data


        :return: The time_data_started of this RecalledDataSize.
        :rtype: datetime
        """
        return self._time_data_started

    @time_data_started.setter
    def time_data_started(self, time_data_started):
        """
        Sets the time_data_started of this RecalledDataSize.
        This is the start of the time range of the archival data


        :param time_data_started: The time_data_started of this RecalledDataSize.
        :type: datetime
        """
        self._time_data_started = time_data_started

    @property
    def time_data_ended(self):
        """
        **[Required]** Gets the time_data_ended of this RecalledDataSize.
        This is the end of the time range of the archival data


        :return: The time_data_ended of this RecalledDataSize.
        :rtype: datetime
        """
        return self._time_data_ended

    @time_data_ended.setter
    def time_data_ended(self, time_data_ended):
        """
        Sets the time_data_ended of this RecalledDataSize.
        This is the end of the time range of the archival data


        :param time_data_ended: The time_data_ended of this RecalledDataSize.
        :type: datetime
        """
        self._time_data_ended = time_data_ended

    @property
    def recalled_data_in_bytes(self):
        """
        **[Required]** Gets the recalled_data_in_bytes of this RecalledDataSize.
        This is the size of the recalled data


        :return: The recalled_data_in_bytes of this RecalledDataSize.
        :rtype: int
        """
        return self._recalled_data_in_bytes

    @recalled_data_in_bytes.setter
    def recalled_data_in_bytes(self, recalled_data_in_bytes):
        """
        Sets the recalled_data_in_bytes of this RecalledDataSize.
        This is the size of the recalled data


        :param recalled_data_in_bytes: The recalled_data_in_bytes of this RecalledDataSize.
        :type: int
        """
        self._recalled_data_in_bytes = recalled_data_in_bytes

    @property
    def not_recalled_data_in_bytes(self):
        """
        **[Required]** Gets the not_recalled_data_in_bytes of this RecalledDataSize.
        This is the size of the archival data not recalled yet


        :return: The not_recalled_data_in_bytes of this RecalledDataSize.
        :rtype: int
        """
        return self._not_recalled_data_in_bytes

    @not_recalled_data_in_bytes.setter
    def not_recalled_data_in_bytes(self, not_recalled_data_in_bytes):
        """
        Sets the not_recalled_data_in_bytes of this RecalledDataSize.
        This is the size of the archival data not recalled yet


        :param not_recalled_data_in_bytes: The not_recalled_data_in_bytes of this RecalledDataSize.
        :type: int
        """
        self._not_recalled_data_in_bytes = not_recalled_data_in_bytes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
