# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200531

from .unified_agent_logging_filter import UnifiedAgentLoggingFilter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UnifiedAgentParserFilter(UnifiedAgentLoggingFilter):
    """
    Logging parser filter object.
    Ref: https://docs.fluentd.org/filter/parser
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UnifiedAgentParserFilter object with values from keyword arguments. The default value of the :py:attr:`~oci.logging.models.UnifiedAgentParserFilter.filter_type` attribute
        of this class is ``PARSER_FILTER`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this UnifiedAgentParserFilter.
        :type name: str

        :param filter_type:
            The value to assign to the filter_type property of this UnifiedAgentParserFilter.
            Allowed values for this property are: "PARSER_FILTER", "GREP_FILTER", "RECORD_TRANSFORMER_FILTER", "CUSTOM_FILTER"
        :type filter_type: str

        :param parser:
            The value to assign to the parser property of this UnifiedAgentParserFilter.
        :type parser: oci.logging.models.UnifiedAgentParser

        :param key_name:
            The value to assign to the key_name property of this UnifiedAgentParserFilter.
        :type key_name: str

        :param reserve_time:
            The value to assign to the reserve_time property of this UnifiedAgentParserFilter.
        :type reserve_time: bool

        :param reserve_data:
            The value to assign to the reserve_data property of this UnifiedAgentParserFilter.
        :type reserve_data: bool

        :param remove_key_name_field:
            The value to assign to the remove_key_name_field property of this UnifiedAgentParserFilter.
        :type remove_key_name_field: bool

        :param replace_invalid_sequence:
            The value to assign to the replace_invalid_sequence property of this UnifiedAgentParserFilter.
        :type replace_invalid_sequence: bool

        :param inject_key_prefix:
            The value to assign to the inject_key_prefix property of this UnifiedAgentParserFilter.
        :type inject_key_prefix: str

        :param hash_value_field:
            The value to assign to the hash_value_field property of this UnifiedAgentParserFilter.
        :type hash_value_field: str

        :param emit_invalid_record_to_error:
            The value to assign to the emit_invalid_record_to_error property of this UnifiedAgentParserFilter.
        :type emit_invalid_record_to_error: bool

        """
        self.swagger_types = {
            'name': 'str',
            'filter_type': 'str',
            'parser': 'UnifiedAgentParser',
            'key_name': 'str',
            'reserve_time': 'bool',
            'reserve_data': 'bool',
            'remove_key_name_field': 'bool',
            'replace_invalid_sequence': 'bool',
            'inject_key_prefix': 'str',
            'hash_value_field': 'str',
            'emit_invalid_record_to_error': 'bool'
        }
        self.attribute_map = {
            'name': 'name',
            'filter_type': 'filterType',
            'parser': 'parser',
            'key_name': 'keyName',
            'reserve_time': 'reserveTime',
            'reserve_data': 'reserveData',
            'remove_key_name_field': 'removeKeyNameField',
            'replace_invalid_sequence': 'replaceInvalidSequence',
            'inject_key_prefix': 'injectKeyPrefix',
            'hash_value_field': 'hashValueField',
            'emit_invalid_record_to_error': 'emitInvalidRecordToError'
        }
        self._name = None
        self._filter_type = None
        self._parser = None
        self._key_name = None
        self._reserve_time = None
        self._reserve_data = None
        self._remove_key_name_field = None
        self._replace_invalid_sequence = None
        self._inject_key_prefix = None
        self._hash_value_field = None
        self._emit_invalid_record_to_error = None
        self._filter_type = 'PARSER_FILTER'

    @property
    def parser(self):
        """
        **[Required]** Gets the parser of this UnifiedAgentParserFilter.

        :return: The parser of this UnifiedAgentParserFilter.
        :rtype: oci.logging.models.UnifiedAgentParser
        """
        return self._parser

    @parser.setter
    def parser(self, parser):
        """
        Sets the parser of this UnifiedAgentParserFilter.

        :param parser: The parser of this UnifiedAgentParserFilter.
        :type: oci.logging.models.UnifiedAgentParser
        """
        self._parser = parser

    @property
    def key_name(self):
        """
        **[Required]** Gets the key_name of this UnifiedAgentParserFilter.
        The field name in the record to parse.


        :return: The key_name of this UnifiedAgentParserFilter.
        :rtype: str
        """
        return self._key_name

    @key_name.setter
    def key_name(self, key_name):
        """
        Sets the key_name of this UnifiedAgentParserFilter.
        The field name in the record to parse.


        :param key_name: The key_name of this UnifiedAgentParserFilter.
        :type: str
        """
        self._key_name = key_name

    @property
    def reserve_time(self):
        """
        Gets the reserve_time of this UnifiedAgentParserFilter.
        If true, keep the original event time in the parsed result.


        :return: The reserve_time of this UnifiedAgentParserFilter.
        :rtype: bool
        """
        return self._reserve_time

    @reserve_time.setter
    def reserve_time(self, reserve_time):
        """
        Sets the reserve_time of this UnifiedAgentParserFilter.
        If true, keep the original event time in the parsed result.


        :param reserve_time: The reserve_time of this UnifiedAgentParserFilter.
        :type: bool
        """
        self._reserve_time = reserve_time

    @property
    def reserve_data(self):
        """
        Gets the reserve_data of this UnifiedAgentParserFilter.
        If true, keep the original key-value pair in the parsed result.


        :return: The reserve_data of this UnifiedAgentParserFilter.
        :rtype: bool
        """
        return self._reserve_data

    @reserve_data.setter
    def reserve_data(self, reserve_data):
        """
        Sets the reserve_data of this UnifiedAgentParserFilter.
        If true, keep the original key-value pair in the parsed result.


        :param reserve_data: The reserve_data of this UnifiedAgentParserFilter.
        :type: bool
        """
        self._reserve_data = reserve_data

    @property
    def remove_key_name_field(self):
        """
        Gets the remove_key_name_field of this UnifiedAgentParserFilter.
        If true, remove the keyName field when parsing is succeeded.


        :return: The remove_key_name_field of this UnifiedAgentParserFilter.
        :rtype: bool
        """
        return self._remove_key_name_field

    @remove_key_name_field.setter
    def remove_key_name_field(self, remove_key_name_field):
        """
        Sets the remove_key_name_field of this UnifiedAgentParserFilter.
        If true, remove the keyName field when parsing is succeeded.


        :param remove_key_name_field: The remove_key_name_field of this UnifiedAgentParserFilter.
        :type: bool
        """
        self._remove_key_name_field = remove_key_name_field

    @property
    def replace_invalid_sequence(self):
        """
        Gets the replace_invalid_sequence of this UnifiedAgentParserFilter.
        If true, the invalid string is replaced with safe characters and is re-parsed.


        :return: The replace_invalid_sequence of this UnifiedAgentParserFilter.
        :rtype: bool
        """
        return self._replace_invalid_sequence

    @replace_invalid_sequence.setter
    def replace_invalid_sequence(self, replace_invalid_sequence):
        """
        Sets the replace_invalid_sequence of this UnifiedAgentParserFilter.
        If true, the invalid string is replaced with safe characters and is re-parsed.


        :param replace_invalid_sequence: The replace_invalid_sequence of this UnifiedAgentParserFilter.
        :type: bool
        """
        self._replace_invalid_sequence = replace_invalid_sequence

    @property
    def inject_key_prefix(self):
        """
        Gets the inject_key_prefix of this UnifiedAgentParserFilter.
        Store the parsed values with the specified key name prefix.


        :return: The inject_key_prefix of this UnifiedAgentParserFilter.
        :rtype: str
        """
        return self._inject_key_prefix

    @inject_key_prefix.setter
    def inject_key_prefix(self, inject_key_prefix):
        """
        Sets the inject_key_prefix of this UnifiedAgentParserFilter.
        Store the parsed values with the specified key name prefix.


        :param inject_key_prefix: The inject_key_prefix of this UnifiedAgentParserFilter.
        :type: str
        """
        self._inject_key_prefix = inject_key_prefix

    @property
    def hash_value_field(self):
        """
        Gets the hash_value_field of this UnifiedAgentParserFilter.
        Store the parsed values as a hash value in a field.


        :return: The hash_value_field of this UnifiedAgentParserFilter.
        :rtype: str
        """
        return self._hash_value_field

    @hash_value_field.setter
    def hash_value_field(self, hash_value_field):
        """
        Sets the hash_value_field of this UnifiedAgentParserFilter.
        Store the parsed values as a hash value in a field.


        :param hash_value_field: The hash_value_field of this UnifiedAgentParserFilter.
        :type: str
        """
        self._hash_value_field = hash_value_field

    @property
    def emit_invalid_record_to_error(self):
        """
        Gets the emit_invalid_record_to_error of this UnifiedAgentParserFilter.
        If true, emit invalid record to @ERROR label. Invalid cases are: 1) key does not exist; 2) the format
        does not match; or 3) an unexpected error. You can rescue unexpected format logs in the @ERROR lable.
        If you want to ignore these errors, set this to false.


        :return: The emit_invalid_record_to_error of this UnifiedAgentParserFilter.
        :rtype: bool
        """
        return self._emit_invalid_record_to_error

    @emit_invalid_record_to_error.setter
    def emit_invalid_record_to_error(self, emit_invalid_record_to_error):
        """
        Sets the emit_invalid_record_to_error of this UnifiedAgentParserFilter.
        If true, emit invalid record to @ERROR label. Invalid cases are: 1) key does not exist; 2) the format
        does not match; or 3) an unexpected error. You can rescue unexpected format logs in the @ERROR lable.
        If you want to ignore these errors, set this to false.


        :param emit_invalid_record_to_error: The emit_invalid_record_to_error of this UnifiedAgentParserFilter.
        :type: bool
        """
        self._emit_invalid_record_to_error = emit_invalid_record_to_error

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
