# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MarketplaceMetadataPublicKeySummary(object):
    """
    Model that contains signed marketplace instance metadata and associated signature in JWT form
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MarketplaceMetadataPublicKeySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key_algorithm:
            The value to assign to the key_algorithm property of this MarketplaceMetadataPublicKeySummary.
        :type key_algorithm: str

        :param key_type:
            The value to assign to the key_type property of this MarketplaceMetadataPublicKeySummary.
        :type key_type: str

        :param key_use:
            The value to assign to the key_use property of this MarketplaceMetadataPublicKeySummary.
        :type key_use: str

        :param key_id:
            The value to assign to the key_id property of this MarketplaceMetadataPublicKeySummary.
        :type key_id: str

        :param exponent:
            The value to assign to the exponent property of this MarketplaceMetadataPublicKeySummary.
        :type exponent: str

        :param modulus:
            The value to assign to the modulus property of this MarketplaceMetadataPublicKeySummary.
        :type modulus: str

        :param certificate_chain:
            The value to assign to the certificate_chain property of this MarketplaceMetadataPublicKeySummary.
        :type certificate_chain: list[str]

        :param certificate_thumbprint:
            The value to assign to the certificate_thumbprint property of this MarketplaceMetadataPublicKeySummary.
        :type certificate_thumbprint: str

        """
        self.swagger_types = {
            'key_algorithm': 'str',
            'key_type': 'str',
            'key_use': 'str',
            'key_id': 'str',
            'exponent': 'str',
            'modulus': 'str',
            'certificate_chain': 'list[str]',
            'certificate_thumbprint': 'str'
        }
        self.attribute_map = {
            'key_algorithm': 'keyAlgorithm',
            'key_type': 'keyType',
            'key_use': 'keyUse',
            'key_id': 'keyId',
            'exponent': 'exponent',
            'modulus': 'modulus',
            'certificate_chain': 'certificateChain',
            'certificate_thumbprint': 'certificateThumbprint'
        }
        self._key_algorithm = None
        self._key_type = None
        self._key_use = None
        self._key_id = None
        self._exponent = None
        self._modulus = None
        self._certificate_chain = None
        self._certificate_thumbprint = None

    @property
    def key_algorithm(self):
        """
        **[Required]** Gets the key_algorithm of this MarketplaceMetadataPublicKeySummary.
        algorithm for public key (i.e. RS256)


        :return: The key_algorithm of this MarketplaceMetadataPublicKeySummary.
        :rtype: str
        """
        return self._key_algorithm

    @key_algorithm.setter
    def key_algorithm(self, key_algorithm):
        """
        Sets the key_algorithm of this MarketplaceMetadataPublicKeySummary.
        algorithm for public key (i.e. RS256)


        :param key_algorithm: The key_algorithm of this MarketplaceMetadataPublicKeySummary.
        :type: str
        """
        self._key_algorithm = key_algorithm

    @property
    def key_type(self):
        """
        **[Required]** Gets the key_type of this MarketplaceMetadataPublicKeySummary.
        key type (i.e. RSA)


        :return: The key_type of this MarketplaceMetadataPublicKeySummary.
        :rtype: str
        """
        return self._key_type

    @key_type.setter
    def key_type(self, key_type):
        """
        Sets the key_type of this MarketplaceMetadataPublicKeySummary.
        key type (i.e. RSA)


        :param key_type: The key_type of this MarketplaceMetadataPublicKeySummary.
        :type: str
        """
        self._key_type = key_type

    @property
    def key_use(self):
        """
        **[Required]** Gets the key_use of this MarketplaceMetadataPublicKeySummary.
        how key is to be used


        :return: The key_use of this MarketplaceMetadataPublicKeySummary.
        :rtype: str
        """
        return self._key_use

    @key_use.setter
    def key_use(self, key_use):
        """
        Sets the key_use of this MarketplaceMetadataPublicKeySummary.
        how key is to be used


        :param key_use: The key_use of this MarketplaceMetadataPublicKeySummary.
        :type: str
        """
        self._key_use = key_use

    @property
    def key_id(self):
        """
        **[Required]** Gets the key_id of this MarketplaceMetadataPublicKeySummary.
        unique id that maps to public certificate, directs user which certificate to use to verfiy


        :return: The key_id of this MarketplaceMetadataPublicKeySummary.
        :rtype: str
        """
        return self._key_id

    @key_id.setter
    def key_id(self, key_id):
        """
        Sets the key_id of this MarketplaceMetadataPublicKeySummary.
        unique id that maps to public certificate, directs user which certificate to use to verfiy


        :param key_id: The key_id of this MarketplaceMetadataPublicKeySummary.
        :type: str
        """
        self._key_id = key_id

    @property
    def exponent(self):
        """
        **[Required]** Gets the exponent of this MarketplaceMetadataPublicKeySummary.
        base64 encoded exponent for public key


        :return: The exponent of this MarketplaceMetadataPublicKeySummary.
        :rtype: str
        """
        return self._exponent

    @exponent.setter
    def exponent(self, exponent):
        """
        Sets the exponent of this MarketplaceMetadataPublicKeySummary.
        base64 encoded exponent for public key


        :param exponent: The exponent of this MarketplaceMetadataPublicKeySummary.
        :type: str
        """
        self._exponent = exponent

    @property
    def modulus(self):
        """
        **[Required]** Gets the modulus of this MarketplaceMetadataPublicKeySummary.
        RSA public modulus


        :return: The modulus of this MarketplaceMetadataPublicKeySummary.
        :rtype: str
        """
        return self._modulus

    @modulus.setter
    def modulus(self, modulus):
        """
        Sets the modulus of this MarketplaceMetadataPublicKeySummary.
        RSA public modulus


        :param modulus: The modulus of this MarketplaceMetadataPublicKeySummary.
        :type: str
        """
        self._modulus = modulus

    @property
    def certificate_chain(self):
        """
        **[Required]** Gets the certificate_chain of this MarketplaceMetadataPublicKeySummary.
        chain of certificates used to sign JWT


        :return: The certificate_chain of this MarketplaceMetadataPublicKeySummary.
        :rtype: list[str]
        """
        return self._certificate_chain

    @certificate_chain.setter
    def certificate_chain(self, certificate_chain):
        """
        Sets the certificate_chain of this MarketplaceMetadataPublicKeySummary.
        chain of certificates used to sign JWT


        :param certificate_chain: The certificate_chain of this MarketplaceMetadataPublicKeySummary.
        :type: list[str]
        """
        self._certificate_chain = certificate_chain

    @property
    def certificate_thumbprint(self):
        """
        **[Required]** Gets the certificate_thumbprint of this MarketplaceMetadataPublicKeySummary.
        unique identifier of associated X509 certificate


        :return: The certificate_thumbprint of this MarketplaceMetadataPublicKeySummary.
        :rtype: str
        """
        return self._certificate_thumbprint

    @certificate_thumbprint.setter
    def certificate_thumbprint(self, certificate_thumbprint):
        """
        Sets the certificate_thumbprint of this MarketplaceMetadataPublicKeySummary.
        unique identifier of associated X509 certificate


        :param certificate_thumbprint: The certificate_thumbprint of this MarketplaceMetadataPublicKeySummary.
        :type: str
        """
        self._certificate_thumbprint = certificate_thumbprint

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
