# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ListingRevisionNote(object):
    """
    The model for the listing revision notes.
    """

    #: A constant which can be used with the note_source property of a ListingRevisionNote.
    #: This constant has a value of "PUBLISHER"
    NOTE_SOURCE_PUBLISHER = "PUBLISHER"

    #: A constant which can be used with the note_source property of a ListingRevisionNote.
    #: This constant has a value of "ADMINISTRATOR"
    NOTE_SOURCE_ADMINISTRATOR = "ADMINISTRATOR"

    #: A constant which can be used with the lifecycle_state property of a ListingRevisionNote.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ListingRevisionNote.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new ListingRevisionNote object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ListingRevisionNote.
        :type id: str

        :param listing_revision_id:
            The value to assign to the listing_revision_id property of this ListingRevisionNote.
        :type listing_revision_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ListingRevisionNote.
        :type compartment_id: str

        :param note_source:
            The value to assign to the note_source property of this ListingRevisionNote.
            Allowed values for this property are: "PUBLISHER", "ADMINISTRATOR", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type note_source: str

        :param note_details:
            The value to assign to the note_details property of this ListingRevisionNote.
        :type note_details: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ListingRevisionNote.
            Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this ListingRevisionNote.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ListingRevisionNote.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ListingRevisionNote.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ListingRevisionNote.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ListingRevisionNote.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'listing_revision_id': 'str',
            'compartment_id': 'str',
            'note_source': 'str',
            'note_details': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'listing_revision_id': 'listingRevisionId',
            'compartment_id': 'compartmentId',
            'note_source': 'noteSource',
            'note_details': 'noteDetails',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._listing_revision_id = None
        self._compartment_id = None
        self._note_source = None
        self._note_details = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ListingRevisionNote.
        The OCID of the listing revision note.


        :return: The id of this ListingRevisionNote.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ListingRevisionNote.
        The OCID of the listing revision note.


        :param id: The id of this ListingRevisionNote.
        :type: str
        """
        self._id = id

    @property
    def listing_revision_id(self):
        """
        **[Required]** Gets the listing_revision_id of this ListingRevisionNote.
        The unique identifier of the listing revision that the specified note belongs to.


        :return: The listing_revision_id of this ListingRevisionNote.
        :rtype: str
        """
        return self._listing_revision_id

    @listing_revision_id.setter
    def listing_revision_id(self, listing_revision_id):
        """
        Sets the listing_revision_id of this ListingRevisionNote.
        The unique identifier of the listing revision that the specified note belongs to.


        :param listing_revision_id: The listing_revision_id of this ListingRevisionNote.
        :type: str
        """
        self._listing_revision_id = listing_revision_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ListingRevisionNote.
        The unique identifier for the compartment.


        :return: The compartment_id of this ListingRevisionNote.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ListingRevisionNote.
        The unique identifier for the compartment.


        :param compartment_id: The compartment_id of this ListingRevisionNote.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def note_source(self):
        """
        **[Required]** Gets the note_source of this ListingRevisionNote.
        type of the note.

        Allowed values for this property are: "PUBLISHER", "ADMINISTRATOR", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The note_source of this ListingRevisionNote.
        :rtype: str
        """
        return self._note_source

    @note_source.setter
    def note_source(self, note_source):
        """
        Sets the note_source of this ListingRevisionNote.
        type of the note.


        :param note_source: The note_source of this ListingRevisionNote.
        :type: str
        """
        allowed_values = ["PUBLISHER", "ADMINISTRATOR"]
        if not value_allowed_none_or_none_sentinel(note_source, allowed_values):
            note_source = 'UNKNOWN_ENUM_VALUE'
        self._note_source = note_source

    @property
    def note_details(self):
        """
        **[Required]** Gets the note_details of this ListingRevisionNote.
        Notes provided for the listing revision.


        :return: The note_details of this ListingRevisionNote.
        :rtype: str
        """
        return self._note_details

    @note_details.setter
    def note_details(self, note_details):
        """
        Sets the note_details of this ListingRevisionNote.
        Notes provided for the listing revision.


        :param note_details: The note_details of this ListingRevisionNote.
        :type: str
        """
        self._note_details = note_details

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this ListingRevisionNote.
        The current state of the listing revision note.

        Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ListingRevisionNote.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ListingRevisionNote.
        The current state of the listing revision note.


        :param lifecycle_state: The lifecycle_state of this ListingRevisionNote.
        :type: str
        """
        allowed_values = ["ACTIVE", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ListingRevisionNote.
        The date and time the listing revision note was created, expressed in `RFC 3339`__
        timestamp format.

        Example: `2022-09-24T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this ListingRevisionNote.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ListingRevisionNote.
        The date and time the listing revision note was created, expressed in `RFC 3339`__
        timestamp format.

        Example: `2022-09-24T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this ListingRevisionNote.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this ListingRevisionNote.
        The date and time the listing revision note was updated, expressed in `RFC 3339`__
        timestamp format.

        Example: `2022-09-24T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ListingRevisionNote.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ListingRevisionNote.
        The date and time the listing revision note was updated, expressed in `RFC 3339`__
        timestamp format.

        Example: `2022-09-24T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ListingRevisionNote.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ListingRevisionNote.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this ListingRevisionNote.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ListingRevisionNote.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this ListingRevisionNote.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ListingRevisionNote.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this ListingRevisionNote.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ListingRevisionNote.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this ListingRevisionNote.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ListingRevisionNote.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ListingRevisionNote.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ListingRevisionNote.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ListingRevisionNote.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
