# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828

from .cloud_service_provider_metadata_item import CloudServiceProviderMetadataItem
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AzureCloudServiceProviderMetadataItem(CloudServiceProviderMetadataItem):
    """
    Azure Cloud Service Provider metadata item.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AzureCloudServiceProviderMetadataItem object with values from keyword arguments. The default value of the :py:attr:`~oci.multicloud.models.AzureCloudServiceProviderMetadataItem.subscription_type` attribute
        of this class is ``ORACLEDBATAZURE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param region:
            The value to assign to the region property of this AzureCloudServiceProviderMetadataItem.
        :type region: str

        :param resource_anchor_name:
            The value to assign to the resource_anchor_name property of this AzureCloudServiceProviderMetadataItem.
        :type resource_anchor_name: str

        :param resource_anchor_uri:
            The value to assign to the resource_anchor_uri property of this AzureCloudServiceProviderMetadataItem.
        :type resource_anchor_uri: str

        :param subscription_type:
            The value to assign to the subscription_type property of this AzureCloudServiceProviderMetadataItem.
            Allowed values for this property are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"
        :type subscription_type: str

        :param resource_group:
            The value to assign to the resource_group property of this AzureCloudServiceProviderMetadataItem.
        :type resource_group: str

        :param subscription:
            The value to assign to the subscription property of this AzureCloudServiceProviderMetadataItem.
        :type subscription: str

        """
        self.swagger_types = {
            'region': 'str',
            'resource_anchor_name': 'str',
            'resource_anchor_uri': 'str',
            'subscription_type': 'str',
            'resource_group': 'str',
            'subscription': 'str'
        }
        self.attribute_map = {
            'region': 'region',
            'resource_anchor_name': 'resourceAnchorName',
            'resource_anchor_uri': 'resourceAnchorUri',
            'subscription_type': 'subscriptionType',
            'resource_group': 'resourceGroup',
            'subscription': 'subscription'
        }
        self._region = None
        self._resource_anchor_name = None
        self._resource_anchor_uri = None
        self._subscription_type = None
        self._resource_group = None
        self._subscription = None
        self._subscription_type = 'ORACLEDBATAZURE'

    @property
    def resource_group(self):
        """
        **[Required]** Gets the resource_group of this AzureCloudServiceProviderMetadataItem.
        Azure resource group that was used for creating this resource.


        :return: The resource_group of this AzureCloudServiceProviderMetadataItem.
        :rtype: str
        """
        return self._resource_group

    @resource_group.setter
    def resource_group(self, resource_group):
        """
        Sets the resource_group of this AzureCloudServiceProviderMetadataItem.
        Azure resource group that was used for creating this resource.


        :param resource_group: The resource_group of this AzureCloudServiceProviderMetadataItem.
        :type: str
        """
        self._resource_group = resource_group

    @property
    def subscription(self):
        """
        **[Required]** Gets the subscription of this AzureCloudServiceProviderMetadataItem.
        Azure subscription that was used for creating this resource.


        :return: The subscription of this AzureCloudServiceProviderMetadataItem.
        :rtype: str
        """
        return self._subscription

    @subscription.setter
    def subscription(self, subscription):
        """
        Sets the subscription of this AzureCloudServiceProviderMetadataItem.
        Azure subscription that was used for creating this resource.


        :param subscription: The subscription of this AzureCloudServiceProviderMetadataItem.
        :type: str
        """
        self._subscription = subscription

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
