# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudServiceProviderMetadataItem(object):
    """
    Cloud Service Provider metadata item.
    Warning - In future this object can change to generic object with future Cloud Service Provider based on
    CloudServiceProvider field. This can be one of CSP provider type Azure, GCP and AWS.
    """

    #: A constant which can be used with the subscription_type property of a CloudServiceProviderMetadataItem.
    #: This constant has a value of "ORACLEDBATAZURE"
    SUBSCRIPTION_TYPE_ORACLEDBATAZURE = "ORACLEDBATAZURE"

    #: A constant which can be used with the subscription_type property of a CloudServiceProviderMetadataItem.
    #: This constant has a value of "ORACLEDBATGOOGLE"
    SUBSCRIPTION_TYPE_ORACLEDBATGOOGLE = "ORACLEDBATGOOGLE"

    #: A constant which can be used with the subscription_type property of a CloudServiceProviderMetadataItem.
    #: This constant has a value of "ORACLEDBATAWS"
    SUBSCRIPTION_TYPE_ORACLEDBATAWS = "ORACLEDBATAWS"

    def __init__(self, **kwargs):
        """
        Initializes a new CloudServiceProviderMetadataItem object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.multicloud.models.AzureCloudServiceProviderMetadataItem`
        * :class:`~oci.multicloud.models.GcpCloudServiceProviderMetadataItem`
        * :class:`~oci.multicloud.models.AwsCloudServiceProviderMetadataItem`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param region:
            The value to assign to the region property of this CloudServiceProviderMetadataItem.
        :type region: str

        :param resource_anchor_name:
            The value to assign to the resource_anchor_name property of this CloudServiceProviderMetadataItem.
        :type resource_anchor_name: str

        :param resource_anchor_uri:
            The value to assign to the resource_anchor_uri property of this CloudServiceProviderMetadataItem.
        :type resource_anchor_uri: str

        :param subscription_type:
            The value to assign to the subscription_type property of this CloudServiceProviderMetadataItem.
            Allowed values for this property are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type subscription_type: str

        """
        self.swagger_types = {
            'region': 'str',
            'resource_anchor_name': 'str',
            'resource_anchor_uri': 'str',
            'subscription_type': 'str'
        }
        self.attribute_map = {
            'region': 'region',
            'resource_anchor_name': 'resourceAnchorName',
            'resource_anchor_uri': 'resourceAnchorUri',
            'subscription_type': 'subscriptionType'
        }
        self._region = None
        self._resource_anchor_name = None
        self._resource_anchor_uri = None
        self._subscription_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['subscriptionType']

        if type == 'ORACLEDBATAZURE':
            return 'AzureCloudServiceProviderMetadataItem'

        if type == 'ORACLEDBATGOOGLE':
            return 'GcpCloudServiceProviderMetadataItem'

        if type == 'ORACLEDBATAWS':
            return 'AwsCloudServiceProviderMetadataItem'
        else:
            return 'CloudServiceProviderMetadataItem'

    @property
    def region(self):
        """
        Gets the region of this CloudServiceProviderMetadataItem.
        The Azure, AWS or GCP region.


        :return: The region of this CloudServiceProviderMetadataItem.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this CloudServiceProviderMetadataItem.
        The Azure, AWS or GCP region.


        :param region: The region of this CloudServiceProviderMetadataItem.
        :type: str
        """
        self._region = region

    @property
    def resource_anchor_name(self):
        """
        **[Required]** Gets the resource_anchor_name of this CloudServiceProviderMetadataItem.
        CSP resource anchor ID or name.


        :return: The resource_anchor_name of this CloudServiceProviderMetadataItem.
        :rtype: str
        """
        return self._resource_anchor_name

    @resource_anchor_name.setter
    def resource_anchor_name(self, resource_anchor_name):
        """
        Sets the resource_anchor_name of this CloudServiceProviderMetadataItem.
        CSP resource anchor ID or name.


        :param resource_anchor_name: The resource_anchor_name of this CloudServiceProviderMetadataItem.
        :type: str
        """
        self._resource_anchor_name = resource_anchor_name

    @property
    def resource_anchor_uri(self):
        """
        Gets the resource_anchor_uri of this CloudServiceProviderMetadataItem.
        CSP resource anchor Uri.


        :return: The resource_anchor_uri of this CloudServiceProviderMetadataItem.
        :rtype: str
        """
        return self._resource_anchor_uri

    @resource_anchor_uri.setter
    def resource_anchor_uri(self, resource_anchor_uri):
        """
        Sets the resource_anchor_uri of this CloudServiceProviderMetadataItem.
        CSP resource anchor Uri.


        :param resource_anchor_uri: The resource_anchor_uri of this CloudServiceProviderMetadataItem.
        :type: str
        """
        self._resource_anchor_uri = resource_anchor_uri

    @property
    def subscription_type(self):
        """
        **[Required]** Gets the subscription_type of this CloudServiceProviderMetadataItem.
        Oracle Cloud Infrastructure Subscription Type.

        Allowed values for this property are: "ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The subscription_type of this CloudServiceProviderMetadataItem.
        :rtype: str
        """
        return self._subscription_type

    @subscription_type.setter
    def subscription_type(self, subscription_type):
        """
        Sets the subscription_type of this CloudServiceProviderMetadataItem.
        Oracle Cloud Infrastructure Subscription Type.


        :param subscription_type: The subscription_type of this CloudServiceProviderMetadataItem.
        :type: str
        """
        allowed_values = ["ORACLEDBATAZURE", "ORACLEDBATGOOGLE", "ORACLEDBATAWS"]
        if not value_allowed_none_or_none_sentinel(subscription_type, allowed_values):
            subscription_type = 'UNKNOWN_ENUM_VALUE'
        self._subscription_type = subscription_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
