# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudServiceProviderNetworkMetadataItem(object):
    """
    Cloud Service Provider metadata item.
    Warning - In future this object can change to generic object with future Cloud Service Provider based on
    CloudServiceProvider field. This can be one of CSP provider type Azure, GCP and AWS
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CloudServiceProviderNetworkMetadataItem object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param region:
            The value to assign to the region property of this CloudServiceProviderNetworkMetadataItem.
        :type region: str

        :param odb_network_id:
            The value to assign to the odb_network_id property of this CloudServiceProviderNetworkMetadataItem.
        :type odb_network_id: str

        :param cidr_blocks:
            The value to assign to the cidr_blocks property of this CloudServiceProviderNetworkMetadataItem.
        :type cidr_blocks: list[str]

        :param network_anchor_uri:
            The value to assign to the network_anchor_uri property of this CloudServiceProviderNetworkMetadataItem.
        :type network_anchor_uri: str

        :param dns_forwarding_config:
            The value to assign to the dns_forwarding_config property of this CloudServiceProviderNetworkMetadataItem.
        :type dns_forwarding_config: list[dict(str, str)]

        """
        self.swagger_types = {
            'region': 'str',
            'odb_network_id': 'str',
            'cidr_blocks': 'list[str]',
            'network_anchor_uri': 'str',
            'dns_forwarding_config': 'list[dict(str, str)]'
        }
        self.attribute_map = {
            'region': 'region',
            'odb_network_id': 'odbNetworkId',
            'cidr_blocks': 'cidrBlocks',
            'network_anchor_uri': 'networkAnchorUri',
            'dns_forwarding_config': 'dnsForwardingConfig'
        }
        self._region = None
        self._odb_network_id = None
        self._cidr_blocks = None
        self._network_anchor_uri = None
        self._dns_forwarding_config = None

    @property
    def region(self):
        """
        **[Required]** Gets the region of this CloudServiceProviderNetworkMetadataItem.
        Azure/GCP/AWS region


        :return: The region of this CloudServiceProviderNetworkMetadataItem.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this CloudServiceProviderNetworkMetadataItem.
        Azure/GCP/AWS region


        :param region: The region of this CloudServiceProviderNetworkMetadataItem.
        :type: str
        """
        self._region = region

    @property
    def odb_network_id(self):
        """
        **[Required]** Gets the odb_network_id of this CloudServiceProviderNetworkMetadataItem.
        CSP oracle database network anchor unique ID/name


        :return: The odb_network_id of this CloudServiceProviderNetworkMetadataItem.
        :rtype: str
        """
        return self._odb_network_id

    @odb_network_id.setter
    def odb_network_id(self, odb_network_id):
        """
        Sets the odb_network_id of this CloudServiceProviderNetworkMetadataItem.
        CSP oracle database network anchor unique ID/name


        :param odb_network_id: The odb_network_id of this CloudServiceProviderNetworkMetadataItem.
        :type: str
        """
        self._odb_network_id = odb_network_id

    @property
    def cidr_blocks(self):
        """
        Gets the cidr_blocks of this CloudServiceProviderNetworkMetadataItem.
        An Azure/GCP/AWS cidrBlocks


        :return: The cidr_blocks of this CloudServiceProviderNetworkMetadataItem.
        :rtype: list[str]
        """
        return self._cidr_blocks

    @cidr_blocks.setter
    def cidr_blocks(self, cidr_blocks):
        """
        Sets the cidr_blocks of this CloudServiceProviderNetworkMetadataItem.
        An Azure/GCP/AWS cidrBlocks


        :param cidr_blocks: The cidr_blocks of this CloudServiceProviderNetworkMetadataItem.
        :type: list[str]
        """
        self._cidr_blocks = cidr_blocks

    @property
    def network_anchor_uri(self):
        """
        Gets the network_anchor_uri of this CloudServiceProviderNetworkMetadataItem.
        CSP network anchor Uri


        :return: The network_anchor_uri of this CloudServiceProviderNetworkMetadataItem.
        :rtype: str
        """
        return self._network_anchor_uri

    @network_anchor_uri.setter
    def network_anchor_uri(self, network_anchor_uri):
        """
        Sets the network_anchor_uri of this CloudServiceProviderNetworkMetadataItem.
        CSP network anchor Uri


        :param network_anchor_uri: The network_anchor_uri of this CloudServiceProviderNetworkMetadataItem.
        :type: str
        """
        self._network_anchor_uri = network_anchor_uri

    @property
    def dns_forwarding_config(self):
        """
        Gets the dns_forwarding_config of this CloudServiceProviderNetworkMetadataItem.
        DNS domain ip mapping forwarding configuration


        :return: The dns_forwarding_config of this CloudServiceProviderNetworkMetadataItem.
        :rtype: list[dict(str, str)]
        """
        return self._dns_forwarding_config

    @dns_forwarding_config.setter
    def dns_forwarding_config(self, dns_forwarding_config):
        """
        Sets the dns_forwarding_config of this CloudServiceProviderNetworkMetadataItem.
        DNS domain ip mapping forwarding configuration


        :param dns_forwarding_config: The dns_forwarding_config of this CloudServiceProviderNetworkMetadataItem.
        :type: list[dict(str, str)]
        """
        self._dns_forwarding_config = dns_forwarding_config

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
