# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExternalLocationSummary(object):
    """
    External location for CSP Region
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExternalLocationSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param csp_region:
            The value to assign to the csp_region property of this ExternalLocationSummary.
        :type csp_region: str

        :param csp_region_display_name:
            The value to assign to the csp_region_display_name property of this ExternalLocationSummary.
        :type csp_region_display_name: str

        """
        self.swagger_types = {
            'csp_region': 'str',
            'csp_region_display_name': 'str'
        }
        self.attribute_map = {
            'csp_region': 'cspRegion',
            'csp_region_display_name': 'cspRegionDisplayName'
        }
        self._csp_region = None
        self._csp_region_display_name = None

    @property
    def csp_region(self):
        """
        **[Required]** Gets the csp_region of this ExternalLocationSummary.
        CSP region corresponding to the given OCI region


        :return: The csp_region of this ExternalLocationSummary.
        :rtype: str
        """
        return self._csp_region

    @csp_region.setter
    def csp_region(self, csp_region):
        """
        Sets the csp_region of this ExternalLocationSummary.
        CSP region corresponding to the given OCI region


        :param csp_region: The csp_region of this ExternalLocationSummary.
        :type: str
        """
        self._csp_region = csp_region

    @property
    def csp_region_display_name(self):
        """
        **[Required]** Gets the csp_region_display_name of this ExternalLocationSummary.
        CSP region display Name corresponding to the given OCI region


        :return: The csp_region_display_name of this ExternalLocationSummary.
        :rtype: str
        """
        return self._csp_region_display_name

    @csp_region_display_name.setter
    def csp_region_display_name(self, csp_region_display_name):
        """
        Sets the csp_region_display_name of this ExternalLocationSummary.
        CSP region display Name corresponding to the given OCI region


        :param csp_region_display_name: The csp_region_display_name of this ExternalLocationSummary.
        :type: str
        """
        self._csp_region_display_name = csp_region_display_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
