# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciVcn(object):
    """
    Oracle Cloud Infrastructure VCN basic information object. It is optional and planned to used for future for network anchor
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OciVcn object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vcn_id:
            The value to assign to the vcn_id property of this OciVcn.
        :type vcn_id: str

        :param cidr_blocks:
            The value to assign to the cidr_blocks property of this OciVcn.
        :type cidr_blocks: list[str]

        :param backup_cidr_blocks:
            The value to assign to the backup_cidr_blocks property of this OciVcn.
        :type backup_cidr_blocks: list[str]

        :param dns_label:
            The value to assign to the dns_label property of this OciVcn.
        :type dns_label: str

        """
        self.swagger_types = {
            'vcn_id': 'str',
            'cidr_blocks': 'list[str]',
            'backup_cidr_blocks': 'list[str]',
            'dns_label': 'str'
        }
        self.attribute_map = {
            'vcn_id': 'vcnId',
            'cidr_blocks': 'cidrBlocks',
            'backup_cidr_blocks': 'backupCidrBlocks',
            'dns_label': 'dnsLabel'
        }
        self._vcn_id = None
        self._cidr_blocks = None
        self._backup_cidr_blocks = None
        self._dns_label = None

    @property
    def vcn_id(self):
        """
        Gets the vcn_id of this OciVcn.
        Oracle Cloud Infrastructure VCN OCID. CSP can not set this property.


        :return: The vcn_id of this OciVcn.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this OciVcn.
        Oracle Cloud Infrastructure VCN OCID. CSP can not set this property.


        :param vcn_id: The vcn_id of this OciVcn.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def cidr_blocks(self):
        """
        Gets the cidr_blocks of this OciVcn.
        Oracle Cloud Infrastructure primary cidr block. CSP can set this property
        It's optional only if disconnect anchor is allowed
        IPv4 CIDR blocks for the VCN that meet the following criteria
        Type: [string (length: 1\u201332), ...]
        The CIDR blocks must be valid.
        They must not overlap with each other or with the on-premises network CIDR block.


        :return: The cidr_blocks of this OciVcn.
        :rtype: list[str]
        """
        return self._cidr_blocks

    @cidr_blocks.setter
    def cidr_blocks(self, cidr_blocks):
        """
        Sets the cidr_blocks of this OciVcn.
        Oracle Cloud Infrastructure primary cidr block. CSP can set this property
        It's optional only if disconnect anchor is allowed
        IPv4 CIDR blocks for the VCN that meet the following criteria
        Type: [string (length: 1\u201332), ...]
        The CIDR blocks must be valid.
        They must not overlap with each other or with the on-premises network CIDR block.


        :param cidr_blocks: The cidr_blocks of this OciVcn.
        :type: list[str]
        """
        self._cidr_blocks = cidr_blocks

    @property
    def backup_cidr_blocks(self):
        """
        Gets the backup_cidr_blocks of this OciVcn.
        Oracle Cloud Infrastructure backup cidr block. CSP can set this property
        It's optional only if disconnect anchor is allowed.
        IPv4 CIDR blocks for the VCN that meet the following criteria
        Type: [string (length: 1\u201332), ...]
        The CIDR blocks must be valid.
        They must not overlap with each other or with the on-premises network CIDR block.


        :return: The backup_cidr_blocks of this OciVcn.
        :rtype: list[str]
        """
        return self._backup_cidr_blocks

    @backup_cidr_blocks.setter
    def backup_cidr_blocks(self, backup_cidr_blocks):
        """
        Sets the backup_cidr_blocks of this OciVcn.
        Oracle Cloud Infrastructure backup cidr block. CSP can set this property
        It's optional only if disconnect anchor is allowed.
        IPv4 CIDR blocks for the VCN that meet the following criteria
        Type: [string (length: 1\u201332), ...]
        The CIDR blocks must be valid.
        They must not overlap with each other or with the on-premises network CIDR block.


        :param backup_cidr_blocks: The backup_cidr_blocks of this OciVcn.
        :type: list[str]
        """
        self._backup_cidr_blocks = backup_cidr_blocks

    @property
    def dns_label(self):
        """
        Gets the dns_label of this OciVcn.
        Oracle Cloud Infrastructure DNS label. This is optional if DNS config is provided.


        :return: The dns_label of this OciVcn.
        :rtype: str
        """
        return self._dns_label

    @dns_label.setter
    def dns_label(self, dns_label):
        """
        Sets the dns_label of this OciVcn.
        Oracle Cloud Infrastructure DNS label. This is optional if DNS config is provided.


        :param dns_label: The dns_label of this OciVcn.
        :type: str
        """
        self._dns_label = dns_label

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
