# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .host_performance_metric_group import HostPerformanceMetricGroup
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostGpuProcesses(HostPerformanceMetricGroup):
    """
    GPU processes metrics, processes using GPUs.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HostGpuProcesses object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.HostGpuProcesses.metric_name` attribute
        of this class is ``HOST_GPU_PROCESSES`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_name:
            The value to assign to the metric_name property of this HostGpuProcesses.
            Allowed values for this property are: "HOST_CPU_USAGE", "HOST_MEMORY_USAGE", "HOST_NETWORK_ACTIVITY_SUMMARY", "HOST_TOP_PROCESSES", "HOST_FILESYSTEM_USAGE", "HOST_GPU_USAGE", "HOST_GPU_PROCESSES", "HOST_IO_USAGE"
        :type metric_name: str

        :param time_collected:
            The value to assign to the time_collected property of this HostGpuProcesses.
        :type time_collected: datetime

        :param gpu_id:
            The value to assign to the gpu_id property of this HostGpuProcesses.
        :type gpu_id: int

        :param pid:
            The value to assign to the pid property of this HostGpuProcesses.
        :type pid: int

        :param process_name:
            The value to assign to the process_name property of this HostGpuProcesses.
        :type process_name: str

        :param elapsed_time:
            The value to assign to the elapsed_time property of this HostGpuProcesses.
        :type elapsed_time: float

        :param gpu_memory_usage:
            The value to assign to the gpu_memory_usage property of this HostGpuProcesses.
        :type gpu_memory_usage: float

        """
        self.swagger_types = {
            'metric_name': 'str',
            'time_collected': 'datetime',
            'gpu_id': 'int',
            'pid': 'int',
            'process_name': 'str',
            'elapsed_time': 'float',
            'gpu_memory_usage': 'float'
        }
        self.attribute_map = {
            'metric_name': 'metricName',
            'time_collected': 'timeCollected',
            'gpu_id': 'gpuId',
            'pid': 'pid',
            'process_name': 'processName',
            'elapsed_time': 'elapsedTime',
            'gpu_memory_usage': 'gpuMemoryUsage'
        }
        self._metric_name = None
        self._time_collected = None
        self._gpu_id = None
        self._pid = None
        self._process_name = None
        self._elapsed_time = None
        self._gpu_memory_usage = None
        self._metric_name = 'HOST_GPU_PROCESSES'

    @property
    def gpu_id(self):
        """
        Gets the gpu_id of this HostGpuProcesses.
        GPU Identifier


        :return: The gpu_id of this HostGpuProcesses.
        :rtype: int
        """
        return self._gpu_id

    @gpu_id.setter
    def gpu_id(self, gpu_id):
        """
        Sets the gpu_id of this HostGpuProcesses.
        GPU Identifier


        :param gpu_id: The gpu_id of this HostGpuProcesses.
        :type: int
        """
        self._gpu_id = gpu_id

    @property
    def pid(self):
        """
        Gets the pid of this HostGpuProcesses.
        Process Identifier


        :return: The pid of this HostGpuProcesses.
        :rtype: int
        """
        return self._pid

    @pid.setter
    def pid(self, pid):
        """
        Sets the pid of this HostGpuProcesses.
        Process Identifier


        :param pid: The pid of this HostGpuProcesses.
        :type: int
        """
        self._pid = pid

    @property
    def process_name(self):
        """
        Gets the process_name of this HostGpuProcesses.
        Process Name (process using GPU)


        :return: The process_name of this HostGpuProcesses.
        :rtype: str
        """
        return self._process_name

    @process_name.setter
    def process_name(self, process_name):
        """
        Sets the process_name of this HostGpuProcesses.
        Process Name (process using GPU)


        :param process_name: The process_name of this HostGpuProcesses.
        :type: str
        """
        self._process_name = process_name

    @property
    def elapsed_time(self):
        """
        Gets the elapsed_time of this HostGpuProcesses.
        Process elapsed time


        :return: The elapsed_time of this HostGpuProcesses.
        :rtype: float
        """
        return self._elapsed_time

    @elapsed_time.setter
    def elapsed_time(self, elapsed_time):
        """
        Sets the elapsed_time of this HostGpuProcesses.
        Process elapsed time


        :param elapsed_time: The elapsed_time of this HostGpuProcesses.
        :type: float
        """
        self._elapsed_time = elapsed_time

    @property
    def gpu_memory_usage(self):
        """
        Gets the gpu_memory_usage of this HostGpuProcesses.
        Memory Used by Process in MBs


        :return: The gpu_memory_usage of this HostGpuProcesses.
        :rtype: float
        """
        return self._gpu_memory_usage

    @gpu_memory_usage.setter
    def gpu_memory_usage(self, gpu_memory_usage):
        """
        Sets the gpu_memory_usage of this HostGpuProcesses.
        Memory Used by Process in MBs


        :param gpu_memory_usage: The gpu_memory_usage of this HostGpuProcesses.
        :type: float
        """
        self._gpu_memory_usage = gpu_memory_usage

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
