# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbSystem(object):
    """
    Information about a database system.
    """

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a DbSystem.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the system_type property of a DbSystem.
    #: This constant has a value of "OCI_OPTIMIZED_STORAGE"
    SYSTEM_TYPE_OCI_OPTIMIZED_STORAGE = "OCI_OPTIMIZED_STORAGE"

    def __init__(self, **kwargs):
        """
        Initializes a new DbSystem object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DbSystem.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this DbSystem.
        :type display_name: str

        :param description:
            The value to assign to the description property of this DbSystem.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DbSystem.
        :type compartment_id: str

        :param time_created:
            The value to assign to the time_created property of this DbSystem.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DbSystem.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DbSystem.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this DbSystem.
        :type lifecycle_details: str

        :param admin_username:
            The value to assign to the admin_username property of this DbSystem.
        :type admin_username: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DbSystem.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DbSystem.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this DbSystem.
        :type system_tags: dict(str, dict(str, object))

        :param system_type:
            The value to assign to the system_type property of this DbSystem.
            Allowed values for this property are: "OCI_OPTIMIZED_STORAGE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type system_type: str

        :param db_version:
            The value to assign to the db_version property of this DbSystem.
        :type db_version: str

        :param config_id:
            The value to assign to the config_id property of this DbSystem.
        :type config_id: str

        :param shape:
            The value to assign to the shape property of this DbSystem.
        :type shape: str

        :param instance_ocpu_count:
            The value to assign to the instance_ocpu_count property of this DbSystem.
        :type instance_ocpu_count: int

        :param instance_memory_size_in_gbs:
            The value to assign to the instance_memory_size_in_gbs property of this DbSystem.
        :type instance_memory_size_in_gbs: int

        :param instance_count:
            The value to assign to the instance_count property of this DbSystem.
        :type instance_count: int

        :param instances:
            The value to assign to the instances property of this DbSystem.
        :type instances: list[oci.psql.models.DbInstance]

        :param storage_details:
            The value to assign to the storage_details property of this DbSystem.
        :type storage_details: oci.psql.models.StorageDetails

        :param network_details:
            The value to assign to the network_details property of this DbSystem.
        :type network_details: oci.psql.models.NetworkDetails

        :param management_policy:
            The value to assign to the management_policy property of this DbSystem.
        :type management_policy: oci.psql.models.ManagementPolicy

        :param source:
            The value to assign to the source property of this DbSystem.
        :type source: oci.psql.models.SourceDetails

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'admin_username': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'system_type': 'str',
            'db_version': 'str',
            'config_id': 'str',
            'shape': 'str',
            'instance_ocpu_count': 'int',
            'instance_memory_size_in_gbs': 'int',
            'instance_count': 'int',
            'instances': 'list[DbInstance]',
            'storage_details': 'StorageDetails',
            'network_details': 'NetworkDetails',
            'management_policy': 'ManagementPolicy',
            'source': 'SourceDetails'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'admin_username': 'adminUsername',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'system_type': 'systemType',
            'db_version': 'dbVersion',
            'config_id': 'configId',
            'shape': 'shape',
            'instance_ocpu_count': 'instanceOcpuCount',
            'instance_memory_size_in_gbs': 'instanceMemorySizeInGBs',
            'instance_count': 'instanceCount',
            'instances': 'instances',
            'storage_details': 'storageDetails',
            'network_details': 'networkDetails',
            'management_policy': 'managementPolicy',
            'source': 'source'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._admin_username = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._system_type = None
        self._db_version = None
        self._config_id = None
        self._shape = None
        self._instance_ocpu_count = None
        self._instance_memory_size_in_gbs = None
        self._instance_count = None
        self._instances = None
        self._storage_details = None
        self._network_details = None
        self._management_policy = None
        self._source = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DbSystem.
        A unique identifier for the database system. Immutable on creation.


        :return: The id of this DbSystem.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DbSystem.
        A unique identifier for the database system. Immutable on creation.


        :param id: The id of this DbSystem.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DbSystem.
        A user-friendly display name for the database system. Avoid entering confidential information.


        :return: The display_name of this DbSystem.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DbSystem.
        A user-friendly display name for the database system. Avoid entering confidential information.


        :param display_name: The display_name of this DbSystem.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this DbSystem.
        A description of the database system.


        :return: The description of this DbSystem.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DbSystem.
        A description of the database system.


        :param description: The description of this DbSystem.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DbSystem.
        The `OCID`__ of the compartment that contains the database system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this DbSystem.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DbSystem.
        The `OCID`__ of the compartment that contains the database system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this DbSystem.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DbSystem.
        The date and time that the database system was created, expressed in
        `RFC 3339`__ timestamp format.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this DbSystem.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DbSystem.
        The date and time that the database system was created, expressed in
        `RFC 3339`__ timestamp format.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this DbSystem.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this DbSystem.
        The date and time that the database system was updated, expressed in
        `RFC 3339`__ timestamp format.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_updated of this DbSystem.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DbSystem.
        The date and time that the database system was updated, expressed in
        `RFC 3339`__ timestamp format.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_updated: The time_updated of this DbSystem.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DbSystem.
        The current state of the database system.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DbSystem.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DbSystem.
        The current state of the database system.


        :param lifecycle_state: The lifecycle_state of this DbSystem.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this DbSystem.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this DbSystem.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this DbSystem.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this DbSystem.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def admin_username(self):
        """
        Gets the admin_username of this DbSystem.
        The database system administrator username.


        :return: The admin_username of this DbSystem.
        :rtype: str
        """
        return self._admin_username

    @admin_username.setter
    def admin_username(self, admin_username):
        """
        Sets the admin_username of this DbSystem.
        The database system administrator username.


        :param admin_username: The admin_username of this DbSystem.
        :type: str
        """
        self._admin_username = admin_username

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DbSystem.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this DbSystem.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DbSystem.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this DbSystem.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DbSystem.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this DbSystem.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DbSystem.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this DbSystem.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DbSystem.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DbSystem.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DbSystem.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DbSystem.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def system_type(self):
        """
        **[Required]** Gets the system_type of this DbSystem.
        Type of the database system.

        Allowed values for this property are: "OCI_OPTIMIZED_STORAGE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The system_type of this DbSystem.
        :rtype: str
        """
        return self._system_type

    @system_type.setter
    def system_type(self, system_type):
        """
        Sets the system_type of this DbSystem.
        Type of the database system.


        :param system_type: The system_type of this DbSystem.
        :type: str
        """
        allowed_values = ["OCI_OPTIMIZED_STORAGE"]
        if not value_allowed_none_or_none_sentinel(system_type, allowed_values):
            system_type = 'UNKNOWN_ENUM_VALUE'
        self._system_type = system_type

    @property
    def db_version(self):
        """
        **[Required]** Gets the db_version of this DbSystem.
        The major and minor versions of the database system software.


        :return: The db_version of this DbSystem.
        :rtype: str
        """
        return self._db_version

    @db_version.setter
    def db_version(self, db_version):
        """
        Sets the db_version of this DbSystem.
        The major and minor versions of the database system software.


        :param db_version: The db_version of this DbSystem.
        :type: str
        """
        self._db_version = db_version

    @property
    def config_id(self):
        """
        Gets the config_id of this DbSystem.
        The `OCID`__ of the configuration associated with the database system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The config_id of this DbSystem.
        :rtype: str
        """
        return self._config_id

    @config_id.setter
    def config_id(self, config_id):
        """
        Sets the config_id of this DbSystem.
        The `OCID`__ of the configuration associated with the database system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param config_id: The config_id of this DbSystem.
        :type: str
        """
        self._config_id = config_id

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this DbSystem.
        The name of the shape for the database instance.
        Example: `VM.Standard.E4.Flex`


        :return: The shape of this DbSystem.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this DbSystem.
        The name of the shape for the database instance.
        Example: `VM.Standard.E4.Flex`


        :param shape: The shape of this DbSystem.
        :type: str
        """
        self._shape = shape

    @property
    def instance_ocpu_count(self):
        """
        **[Required]** Gets the instance_ocpu_count of this DbSystem.
        The total number of OCPUs available to each database instance node.


        :return: The instance_ocpu_count of this DbSystem.
        :rtype: int
        """
        return self._instance_ocpu_count

    @instance_ocpu_count.setter
    def instance_ocpu_count(self, instance_ocpu_count):
        """
        Sets the instance_ocpu_count of this DbSystem.
        The total number of OCPUs available to each database instance node.


        :param instance_ocpu_count: The instance_ocpu_count of this DbSystem.
        :type: int
        """
        self._instance_ocpu_count = instance_ocpu_count

    @property
    def instance_memory_size_in_gbs(self):
        """
        **[Required]** Gets the instance_memory_size_in_gbs of this DbSystem.
        The total amount of memory available to each database instance node, in gigabytes.


        :return: The instance_memory_size_in_gbs of this DbSystem.
        :rtype: int
        """
        return self._instance_memory_size_in_gbs

    @instance_memory_size_in_gbs.setter
    def instance_memory_size_in_gbs(self, instance_memory_size_in_gbs):
        """
        Sets the instance_memory_size_in_gbs of this DbSystem.
        The total amount of memory available to each database instance node, in gigabytes.


        :param instance_memory_size_in_gbs: The instance_memory_size_in_gbs of this DbSystem.
        :type: int
        """
        self._instance_memory_size_in_gbs = instance_memory_size_in_gbs

    @property
    def instance_count(self):
        """
        Gets the instance_count of this DbSystem.
        Count of instances, or nodes, in the database system.


        :return: The instance_count of this DbSystem.
        :rtype: int
        """
        return self._instance_count

    @instance_count.setter
    def instance_count(self, instance_count):
        """
        Sets the instance_count of this DbSystem.
        Count of instances, or nodes, in the database system.


        :param instance_count: The instance_count of this DbSystem.
        :type: int
        """
        self._instance_count = instance_count

    @property
    def instances(self):
        """
        Gets the instances of this DbSystem.
        The list of instances, or nodes, in the database system.


        :return: The instances of this DbSystem.
        :rtype: list[oci.psql.models.DbInstance]
        """
        return self._instances

    @instances.setter
    def instances(self, instances):
        """
        Sets the instances of this DbSystem.
        The list of instances, or nodes, in the database system.


        :param instances: The instances of this DbSystem.
        :type: list[oci.psql.models.DbInstance]
        """
        self._instances = instances

    @property
    def storage_details(self):
        """
        **[Required]** Gets the storage_details of this DbSystem.

        :return: The storage_details of this DbSystem.
        :rtype: oci.psql.models.StorageDetails
        """
        return self._storage_details

    @storage_details.setter
    def storage_details(self, storage_details):
        """
        Sets the storage_details of this DbSystem.

        :param storage_details: The storage_details of this DbSystem.
        :type: oci.psql.models.StorageDetails
        """
        self._storage_details = storage_details

    @property
    def network_details(self):
        """
        **[Required]** Gets the network_details of this DbSystem.

        :return: The network_details of this DbSystem.
        :rtype: oci.psql.models.NetworkDetails
        """
        return self._network_details

    @network_details.setter
    def network_details(self, network_details):
        """
        Sets the network_details of this DbSystem.

        :param network_details: The network_details of this DbSystem.
        :type: oci.psql.models.NetworkDetails
        """
        self._network_details = network_details

    @property
    def management_policy(self):
        """
        **[Required]** Gets the management_policy of this DbSystem.

        :return: The management_policy of this DbSystem.
        :rtype: oci.psql.models.ManagementPolicy
        """
        return self._management_policy

    @management_policy.setter
    def management_policy(self, management_policy):
        """
        Sets the management_policy of this DbSystem.

        :param management_policy: The management_policy of this DbSystem.
        :type: oci.psql.models.ManagementPolicy
        """
        self._management_policy = management_policy

    @property
    def source(self):
        """
        Gets the source of this DbSystem.

        :return: The source of this DbSystem.
        :rtype: oci.psql.models.SourceDetails
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this DbSystem.

        :param source: The source of this DbSystem.
        :type: oci.psql.models.SourceDetails
        """
        self._source = source

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
