# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RedisCluster(object):
    """
    An OCI Cache cluster is a memory-based storage solution. For more information, see `OCI Cache`__.

    __ https://docs.cloud.oracle.com/iaas/Content/ocicache/home.htm
    """

    #: A constant which can be used with the lifecycle_state property of a RedisCluster.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a RedisCluster.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a RedisCluster.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a RedisCluster.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a RedisCluster.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a RedisCluster.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the software_version property of a RedisCluster.
    #: This constant has a value of "V7_0_5"
    SOFTWARE_VERSION_V7_0_5 = "V7_0_5"

    #: A constant which can be used with the software_version property of a RedisCluster.
    #: This constant has a value of "REDIS_7_0"
    SOFTWARE_VERSION_REDIS_7_0 = "REDIS_7_0"

    #: A constant which can be used with the software_version property of a RedisCluster.
    #: This constant has a value of "VALKEY_7_2"
    SOFTWARE_VERSION_VALKEY_7_2 = "VALKEY_7_2"

    #: A constant which can be used with the cluster_mode property of a RedisCluster.
    #: This constant has a value of "SHARDED"
    CLUSTER_MODE_SHARDED = "SHARDED"

    #: A constant which can be used with the cluster_mode property of a RedisCluster.
    #: This constant has a value of "NONSHARDED"
    CLUSTER_MODE_NONSHARDED = "NONSHARDED"

    def __init__(self, **kwargs):
        """
        Initializes a new RedisCluster object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this RedisCluster.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this RedisCluster.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this RedisCluster.
        :type compartment_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this RedisCluster.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this RedisCluster.
        :type lifecycle_details: str

        :param node_count:
            The value to assign to the node_count property of this RedisCluster.
        :type node_count: int

        :param node_memory_in_gbs:
            The value to assign to the node_memory_in_gbs property of this RedisCluster.
        :type node_memory_in_gbs: float

        :param primary_fqdn:
            The value to assign to the primary_fqdn property of this RedisCluster.
        :type primary_fqdn: str

        :param primary_endpoint_ip_address:
            The value to assign to the primary_endpoint_ip_address property of this RedisCluster.
        :type primary_endpoint_ip_address: str

        :param replicas_fqdn:
            The value to assign to the replicas_fqdn property of this RedisCluster.
        :type replicas_fqdn: str

        :param replicas_endpoint_ip_address:
            The value to assign to the replicas_endpoint_ip_address property of this RedisCluster.
        :type replicas_endpoint_ip_address: str

        :param discovery_fqdn:
            The value to assign to the discovery_fqdn property of this RedisCluster.
        :type discovery_fqdn: str

        :param discovery_endpoint_ip_address:
            The value to assign to the discovery_endpoint_ip_address property of this RedisCluster.
        :type discovery_endpoint_ip_address: str

        :param software_version:
            The value to assign to the software_version property of this RedisCluster.
            Allowed values for this property are: "V7_0_5", "REDIS_7_0", "VALKEY_7_2", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type software_version: str

        :param subnet_id:
            The value to assign to the subnet_id property of this RedisCluster.
        :type subnet_id: str

        :param time_created:
            The value to assign to the time_created property of this RedisCluster.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this RedisCluster.
        :type time_updated: datetime

        :param node_collection:
            The value to assign to the node_collection property of this RedisCluster.
        :type node_collection: oci.redis.models.NodeCollection

        :param oci_cache_config_set_id:
            The value to assign to the oci_cache_config_set_id property of this RedisCluster.
        :type oci_cache_config_set_id: str

        :param cluster_mode:
            The value to assign to the cluster_mode property of this RedisCluster.
            Allowed values for this property are: "SHARDED", "NONSHARDED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type cluster_mode: str

        :param shard_count:
            The value to assign to the shard_count property of this RedisCluster.
        :type shard_count: int

        :param nsg_ids:
            The value to assign to the nsg_ids property of this RedisCluster.
        :type nsg_ids: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this RedisCluster.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this RedisCluster.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this RedisCluster.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'node_count': 'int',
            'node_memory_in_gbs': 'float',
            'primary_fqdn': 'str',
            'primary_endpoint_ip_address': 'str',
            'replicas_fqdn': 'str',
            'replicas_endpoint_ip_address': 'str',
            'discovery_fqdn': 'str',
            'discovery_endpoint_ip_address': 'str',
            'software_version': 'str',
            'subnet_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'node_collection': 'NodeCollection',
            'oci_cache_config_set_id': 'str',
            'cluster_mode': 'str',
            'shard_count': 'int',
            'nsg_ids': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'node_count': 'nodeCount',
            'node_memory_in_gbs': 'nodeMemoryInGBs',
            'primary_fqdn': 'primaryFqdn',
            'primary_endpoint_ip_address': 'primaryEndpointIpAddress',
            'replicas_fqdn': 'replicasFqdn',
            'replicas_endpoint_ip_address': 'replicasEndpointIpAddress',
            'discovery_fqdn': 'discoveryFqdn',
            'discovery_endpoint_ip_address': 'discoveryEndpointIpAddress',
            'software_version': 'softwareVersion',
            'subnet_id': 'subnetId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'node_collection': 'nodeCollection',
            'oci_cache_config_set_id': 'ociCacheConfigSetId',
            'cluster_mode': 'clusterMode',
            'shard_count': 'shardCount',
            'nsg_ids': 'nsgIds',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._node_count = None
        self._node_memory_in_gbs = None
        self._primary_fqdn = None
        self._primary_endpoint_ip_address = None
        self._replicas_fqdn = None
        self._replicas_endpoint_ip_address = None
        self._discovery_fqdn = None
        self._discovery_endpoint_ip_address = None
        self._software_version = None
        self._subnet_id = None
        self._time_created = None
        self._time_updated = None
        self._node_collection = None
        self._oci_cache_config_set_id = None
        self._cluster_mode = None
        self._shard_count = None
        self._nsg_ids = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this RedisCluster.
        The `OCID`__ of the cluster.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :return: The id of this RedisCluster.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this RedisCluster.
        The `OCID`__ of the cluster.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :param id: The id of this RedisCluster.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this RedisCluster.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this RedisCluster.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this RedisCluster.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this RedisCluster.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this RedisCluster.
        The `OCID`__ of the compartment that contains the cluster.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :return: The compartment_id of this RedisCluster.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this RedisCluster.
        The `OCID`__ of the compartment that contains the cluster.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :param compartment_id: The compartment_id of this RedisCluster.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this RedisCluster.
        The current state of the cluster.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this RedisCluster.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this RedisCluster.
        The current state of the cluster.


        :param lifecycle_state: The lifecycle_state of this RedisCluster.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this RedisCluster.
        A message describing the current state in more detail. For example, the message might provide actionable information for a resource in `FAILED` state.


        :return: The lifecycle_details of this RedisCluster.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this RedisCluster.
        A message describing the current state in more detail. For example, the message might provide actionable information for a resource in `FAILED` state.


        :param lifecycle_details: The lifecycle_details of this RedisCluster.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def node_count(self):
        """
        **[Required]** Gets the node_count of this RedisCluster.
        The number of nodes per shard in the cluster when clusterMode is SHARDED. This is the total number of nodes when clusterMode is NONSHARDED.


        :return: The node_count of this RedisCluster.
        :rtype: int
        """
        return self._node_count

    @node_count.setter
    def node_count(self, node_count):
        """
        Sets the node_count of this RedisCluster.
        The number of nodes per shard in the cluster when clusterMode is SHARDED. This is the total number of nodes when clusterMode is NONSHARDED.


        :param node_count: The node_count of this RedisCluster.
        :type: int
        """
        self._node_count = node_count

    @property
    def node_memory_in_gbs(self):
        """
        **[Required]** Gets the node_memory_in_gbs of this RedisCluster.
        The amount of memory allocated to the cluster's nodes, in gigabytes.


        :return: The node_memory_in_gbs of this RedisCluster.
        :rtype: float
        """
        return self._node_memory_in_gbs

    @node_memory_in_gbs.setter
    def node_memory_in_gbs(self, node_memory_in_gbs):
        """
        Sets the node_memory_in_gbs of this RedisCluster.
        The amount of memory allocated to the cluster's nodes, in gigabytes.


        :param node_memory_in_gbs: The node_memory_in_gbs of this RedisCluster.
        :type: float
        """
        self._node_memory_in_gbs = node_memory_in_gbs

    @property
    def primary_fqdn(self):
        """
        **[Required]** Gets the primary_fqdn of this RedisCluster.
        The fully qualified domain name (FQDN) of the API endpoint for the cluster's primary node.


        :return: The primary_fqdn of this RedisCluster.
        :rtype: str
        """
        return self._primary_fqdn

    @primary_fqdn.setter
    def primary_fqdn(self, primary_fqdn):
        """
        Sets the primary_fqdn of this RedisCluster.
        The fully qualified domain name (FQDN) of the API endpoint for the cluster's primary node.


        :param primary_fqdn: The primary_fqdn of this RedisCluster.
        :type: str
        """
        self._primary_fqdn = primary_fqdn

    @property
    def primary_endpoint_ip_address(self):
        """
        **[Required]** Gets the primary_endpoint_ip_address of this RedisCluster.
        The private IP address of the API endpoint for the cluster's primary node.


        :return: The primary_endpoint_ip_address of this RedisCluster.
        :rtype: str
        """
        return self._primary_endpoint_ip_address

    @primary_endpoint_ip_address.setter
    def primary_endpoint_ip_address(self, primary_endpoint_ip_address):
        """
        Sets the primary_endpoint_ip_address of this RedisCluster.
        The private IP address of the API endpoint for the cluster's primary node.


        :param primary_endpoint_ip_address: The primary_endpoint_ip_address of this RedisCluster.
        :type: str
        """
        self._primary_endpoint_ip_address = primary_endpoint_ip_address

    @property
    def replicas_fqdn(self):
        """
        **[Required]** Gets the replicas_fqdn of this RedisCluster.
        The fully qualified domain name (FQDN) of the API endpoint for the cluster's replica nodes.


        :return: The replicas_fqdn of this RedisCluster.
        :rtype: str
        """
        return self._replicas_fqdn

    @replicas_fqdn.setter
    def replicas_fqdn(self, replicas_fqdn):
        """
        Sets the replicas_fqdn of this RedisCluster.
        The fully qualified domain name (FQDN) of the API endpoint for the cluster's replica nodes.


        :param replicas_fqdn: The replicas_fqdn of this RedisCluster.
        :type: str
        """
        self._replicas_fqdn = replicas_fqdn

    @property
    def replicas_endpoint_ip_address(self):
        """
        **[Required]** Gets the replicas_endpoint_ip_address of this RedisCluster.
        The private IP address of the API endpoint for the cluster's replica nodes.


        :return: The replicas_endpoint_ip_address of this RedisCluster.
        :rtype: str
        """
        return self._replicas_endpoint_ip_address

    @replicas_endpoint_ip_address.setter
    def replicas_endpoint_ip_address(self, replicas_endpoint_ip_address):
        """
        Sets the replicas_endpoint_ip_address of this RedisCluster.
        The private IP address of the API endpoint for the cluster's replica nodes.


        :param replicas_endpoint_ip_address: The replicas_endpoint_ip_address of this RedisCluster.
        :type: str
        """
        self._replicas_endpoint_ip_address = replicas_endpoint_ip_address

    @property
    def discovery_fqdn(self):
        """
        Gets the discovery_fqdn of this RedisCluster.
        The fully qualified domain name (FQDN) of the API endpoint for sharded cluster discovery.


        :return: The discovery_fqdn of this RedisCluster.
        :rtype: str
        """
        return self._discovery_fqdn

    @discovery_fqdn.setter
    def discovery_fqdn(self, discovery_fqdn):
        """
        Sets the discovery_fqdn of this RedisCluster.
        The fully qualified domain name (FQDN) of the API endpoint for sharded cluster discovery.


        :param discovery_fqdn: The discovery_fqdn of this RedisCluster.
        :type: str
        """
        self._discovery_fqdn = discovery_fqdn

    @property
    def discovery_endpoint_ip_address(self):
        """
        Gets the discovery_endpoint_ip_address of this RedisCluster.
        The private IP address of the API endpoint for sharded cluster discovery.


        :return: The discovery_endpoint_ip_address of this RedisCluster.
        :rtype: str
        """
        return self._discovery_endpoint_ip_address

    @discovery_endpoint_ip_address.setter
    def discovery_endpoint_ip_address(self, discovery_endpoint_ip_address):
        """
        Sets the discovery_endpoint_ip_address of this RedisCluster.
        The private IP address of the API endpoint for sharded cluster discovery.


        :param discovery_endpoint_ip_address: The discovery_endpoint_ip_address of this RedisCluster.
        :type: str
        """
        self._discovery_endpoint_ip_address = discovery_endpoint_ip_address

    @property
    def software_version(self):
        """
        **[Required]** Gets the software_version of this RedisCluster.
        The OCI Cache engine version that the cluster is running.

        Allowed values for this property are: "V7_0_5", "REDIS_7_0", "VALKEY_7_2", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The software_version of this RedisCluster.
        :rtype: str
        """
        return self._software_version

    @software_version.setter
    def software_version(self, software_version):
        """
        Sets the software_version of this RedisCluster.
        The OCI Cache engine version that the cluster is running.


        :param software_version: The software_version of this RedisCluster.
        :type: str
        """
        allowed_values = ["V7_0_5", "REDIS_7_0", "VALKEY_7_2"]
        if not value_allowed_none_or_none_sentinel(software_version, allowed_values):
            software_version = 'UNKNOWN_ENUM_VALUE'
        self._software_version = software_version

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this RedisCluster.
        The `OCID`__ of the cluster's subnet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :return: The subnet_id of this RedisCluster.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this RedisCluster.
        The `OCID`__ of the cluster's subnet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :param subnet_id: The subnet_id of this RedisCluster.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def time_created(self):
        """
        Gets the time_created of this RedisCluster.
        The date and time the cluster was created. An `RFC3339`__ formatted datetime string.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_created of this RedisCluster.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this RedisCluster.
        The date and time the cluster was created. An `RFC3339`__ formatted datetime string.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_created: The time_created of this RedisCluster.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this RedisCluster.
        The date and time the cluster was updated. An `RFC3339`__ formatted datetime string.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_updated of this RedisCluster.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this RedisCluster.
        The date and time the cluster was updated. An `RFC3339`__ formatted datetime string.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_updated: The time_updated of this RedisCluster.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def node_collection(self):
        """
        **[Required]** Gets the node_collection of this RedisCluster.

        :return: The node_collection of this RedisCluster.
        :rtype: oci.redis.models.NodeCollection
        """
        return self._node_collection

    @node_collection.setter
    def node_collection(self, node_collection):
        """
        Sets the node_collection of this RedisCluster.

        :param node_collection: The node_collection of this RedisCluster.
        :type: oci.redis.models.NodeCollection
        """
        self._node_collection = node_collection

    @property
    def oci_cache_config_set_id(self):
        """
        Gets the oci_cache_config_set_id of this RedisCluster.
        The ID of the corresponding OCI Cache Config Set for the cluster.


        :return: The oci_cache_config_set_id of this RedisCluster.
        :rtype: str
        """
        return self._oci_cache_config_set_id

    @oci_cache_config_set_id.setter
    def oci_cache_config_set_id(self, oci_cache_config_set_id):
        """
        Sets the oci_cache_config_set_id of this RedisCluster.
        The ID of the corresponding OCI Cache Config Set for the cluster.


        :param oci_cache_config_set_id: The oci_cache_config_set_id of this RedisCluster.
        :type: str
        """
        self._oci_cache_config_set_id = oci_cache_config_set_id

    @property
    def cluster_mode(self):
        """
        Gets the cluster_mode of this RedisCluster.
        Specifies whether the cluster is sharded or non-sharded.

        Allowed values for this property are: "SHARDED", "NONSHARDED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The cluster_mode of this RedisCluster.
        :rtype: str
        """
        return self._cluster_mode

    @cluster_mode.setter
    def cluster_mode(self, cluster_mode):
        """
        Sets the cluster_mode of this RedisCluster.
        Specifies whether the cluster is sharded or non-sharded.


        :param cluster_mode: The cluster_mode of this RedisCluster.
        :type: str
        """
        allowed_values = ["SHARDED", "NONSHARDED"]
        if not value_allowed_none_or_none_sentinel(cluster_mode, allowed_values):
            cluster_mode = 'UNKNOWN_ENUM_VALUE'
        self._cluster_mode = cluster_mode

    @property
    def shard_count(self):
        """
        Gets the shard_count of this RedisCluster.
        The number of shards in a sharded cluster. Only applicable when clusterMode is SHARDED.


        :return: The shard_count of this RedisCluster.
        :rtype: int
        """
        return self._shard_count

    @shard_count.setter
    def shard_count(self, shard_count):
        """
        Sets the shard_count of this RedisCluster.
        The number of shards in a sharded cluster. Only applicable when clusterMode is SHARDED.


        :param shard_count: The shard_count of this RedisCluster.
        :type: int
        """
        self._shard_count = shard_count

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this RedisCluster.
        A list of Network Security Group (NSG) `OCIDs`__
        associated with this cluster. For more information,
        see `Using an NSG for Clusters`__.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/iaas/Content/ocicache/connecttocluster.htm#connecttocluster__networksecuritygroup


        :return: The nsg_ids of this RedisCluster.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this RedisCluster.
        A list of Network Security Group (NSG) `OCIDs`__
        associated with this cluster. For more information,
        see `Using an NSG for Clusters`__.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/iaas/Content/ocicache/connecttocluster.htm#connecttocluster__networksecuritygroup


        :param nsg_ids: The nsg_ids of this RedisCluster.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this RedisCluster.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this RedisCluster.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this RedisCluster.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this RedisCluster.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this RedisCluster.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this RedisCluster.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this RedisCluster.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this RedisCluster.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this RedisCluster.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this RedisCluster.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this RedisCluster.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this RedisCluster.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
