# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateTenancyAttachmentDetails(object):
    """
    The data to create a TenancyAttachment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateTenancyAttachmentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this CreateTenancyAttachmentDetails.
        :type description: str

        :param resource_analytics_instance_id:
            The value to assign to the resource_analytics_instance_id property of this CreateTenancyAttachmentDetails.
        :type resource_analytics_instance_id: str

        :param tenancy_id:
            The value to assign to the tenancy_id property of this CreateTenancyAttachmentDetails.
        :type tenancy_id: str

        """
        self.swagger_types = {
            'description': 'str',
            'resource_analytics_instance_id': 'str',
            'tenancy_id': 'str'
        }
        self.attribute_map = {
            'description': 'description',
            'resource_analytics_instance_id': 'resourceAnalyticsInstanceId',
            'tenancy_id': 'tenancyId'
        }
        self._description = None
        self._resource_analytics_instance_id = None
        self._tenancy_id = None

    @property
    def description(self):
        """
        Gets the description of this CreateTenancyAttachmentDetails.
        A description of the tenancy.


        :return: The description of this CreateTenancyAttachmentDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateTenancyAttachmentDetails.
        A description of the tenancy.


        :param description: The description of this CreateTenancyAttachmentDetails.
        :type: str
        """
        self._description = description

    @property
    def resource_analytics_instance_id(self):
        """
        **[Required]** Gets the resource_analytics_instance_id of this CreateTenancyAttachmentDetails.
        The `OCID`__ of the ResourceAnalyticsInstance associated with this TenancyAttachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The resource_analytics_instance_id of this CreateTenancyAttachmentDetails.
        :rtype: str
        """
        return self._resource_analytics_instance_id

    @resource_analytics_instance_id.setter
    def resource_analytics_instance_id(self, resource_analytics_instance_id):
        """
        Sets the resource_analytics_instance_id of this CreateTenancyAttachmentDetails.
        The `OCID`__ of the ResourceAnalyticsInstance associated with this TenancyAttachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param resource_analytics_instance_id: The resource_analytics_instance_id of this CreateTenancyAttachmentDetails.
        :type: str
        """
        self._resource_analytics_instance_id = resource_analytics_instance_id

    @property
    def tenancy_id(self):
        """
        **[Required]** Gets the tenancy_id of this CreateTenancyAttachmentDetails.
        The `OCID`__ of the tenancy associated with this TenancyAttachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The tenancy_id of this CreateTenancyAttachmentDetails.
        :rtype: str
        """
        return self._tenancy_id

    @tenancy_id.setter
    def tenancy_id(self, tenancy_id):
        """
        Sets the tenancy_id of this CreateTenancyAttachmentDetails.
        The `OCID`__ of the tenancy associated with this TenancyAttachment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param tenancy_id: The tenancy_id of this CreateTenancyAttachmentDetails.
        :type: str
        """
        self._tenancy_id = tenancy_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
