# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240430

from .resource_filter import ResourceFilter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DefinedTagsResourceFilter(ResourceFilter):
    """
    This is a resource filter for filtering resource based on a defined tag.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DefinedTagsResourceFilter object with values from keyword arguments. The default value of the :py:attr:`~oci.resource_scheduler.models.DefinedTagsResourceFilter.attribute` attribute
        of this class is ``DEFINED_TAGS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param attribute:
            The value to assign to the attribute property of this DefinedTagsResourceFilter.
            Allowed values for this property are: "COMPARTMENT_ID", "RESOURCE_TYPE", "DEFINED_TAGS", "TIME_CREATED", "LIFECYCLE_STATE"
        :type attribute: str

        :param value:
            The value to assign to the value property of this DefinedTagsResourceFilter.
        :type value: list[oci.resource_scheduler.models.DefinedTagFilterValue]

        """
        self.swagger_types = {
            'attribute': 'str',
            'value': 'list[DefinedTagFilterValue]'
        }
        self.attribute_map = {
            'attribute': 'attribute',
            'value': 'value'
        }
        self._attribute = None
        self._value = None
        self._attribute = 'DEFINED_TAGS'

    @property
    def value(self):
        """
        Gets the value of this DefinedTagsResourceFilter.
        This is a defined tag filter value.


        :return: The value of this DefinedTagsResourceFilter.
        :rtype: list[oci.resource_scheduler.models.DefinedTagFilterValue]
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this DefinedTagsResourceFilter.
        This is a defined tag filter value.


        :param value: The value of this DefinedTagsResourceFilter.
        :type: list[oci.resource_scheduler.models.DefinedTagFilterValue]
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
