# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetricData(object):
    """
    Metric Details
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MetricData object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param dimensions:
            The value to assign to the dimensions property of this MetricData.
        :type dimensions: dict(str, str)

        :param training_data_points:
            The value to assign to the training_data_points property of this MetricData.
        :type training_data_points: list[oci.stack_monitoring.models.DataPoint]

        :param evaluation_data_points:
            The value to assign to the evaluation_data_points property of this MetricData.
        :type evaluation_data_points: list[oci.stack_monitoring.models.DataPoint]

        """
        self.swagger_types = {
            'dimensions': 'dict(str, str)',
            'training_data_points': 'list[DataPoint]',
            'evaluation_data_points': 'list[DataPoint]'
        }
        self.attribute_map = {
            'dimensions': 'dimensions',
            'training_data_points': 'trainingDataPoints',
            'evaluation_data_points': 'evaluationDataPoints'
        }
        self._dimensions = None
        self._training_data_points = None
        self._evaluation_data_points = None

    @property
    def dimensions(self):
        """
        Gets the dimensions of this MetricData.
        list of dimensions for the metric


        :return: The dimensions of this MetricData.
        :rtype: dict(str, str)
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this MetricData.
        list of dimensions for the metric


        :param dimensions: The dimensions of this MetricData.
        :type: dict(str, str)
        """
        self._dimensions = dimensions

    @property
    def training_data_points(self):
        """
        **[Required]** Gets the training_data_points of this MetricData.
        list of data points for the metric for training of baseline


        :return: The training_data_points of this MetricData.
        :rtype: list[oci.stack_monitoring.models.DataPoint]
        """
        return self._training_data_points

    @training_data_points.setter
    def training_data_points(self, training_data_points):
        """
        Sets the training_data_points of this MetricData.
        list of data points for the metric for training of baseline


        :param training_data_points: The training_data_points of this MetricData.
        :type: list[oci.stack_monitoring.models.DataPoint]
        """
        self._training_data_points = training_data_points

    @property
    def evaluation_data_points(self):
        """
        **[Required]** Gets the evaluation_data_points of this MetricData.
        list of data points for the metric for evaluation of anomalies


        :return: The evaluation_data_points of this MetricData.
        :rtype: list[oci.stack_monitoring.models.DataPoint]
        """
        return self._evaluation_data_points

    @evaluation_data_points.setter
    def evaluation_data_points(self, evaluation_data_points):
        """
        Sets the evaluation_data_points of this MetricData.
        list of data points for the metric for evaluation of anomalies


        :param evaluation_data_points: The evaluation_data_points of this MetricData.
        :type: list[oci.stack_monitoring.models.DataPoint]
        """
        self._evaluation_data_points = evaluation_data_points

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
