# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MonitoredResourceDetails(object):
    """
    Details of the Resource that are part of the Maintenance Window.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MonitoredResourceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param resource_id:
            The value to assign to the resource_id property of this MonitoredResourceDetails.
        :type resource_id: str

        :param name:
            The value to assign to the name property of this MonitoredResourceDetails.
        :type name: str

        :param type:
            The value to assign to the type property of this MonitoredResourceDetails.
        :type type: str

        :param number_of_members:
            The value to assign to the number_of_members property of this MonitoredResourceDetails.
        :type number_of_members: int

        """
        self.swagger_types = {
            'resource_id': 'str',
            'name': 'str',
            'type': 'str',
            'number_of_members': 'int'
        }
        self.attribute_map = {
            'resource_id': 'resourceId',
            'name': 'name',
            'type': 'type',
            'number_of_members': 'numberOfMembers'
        }
        self._resource_id = None
        self._name = None
        self._type = None
        self._number_of_members = None

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this MonitoredResourceDetails.
        The `OCID`__ of monitored resource
        part of the Maintenance window.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The resource_id of this MonitoredResourceDetails.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this MonitoredResourceDetails.
        The `OCID`__ of monitored resource
        part of the Maintenance window.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param resource_id: The resource_id of this MonitoredResourceDetails.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this MonitoredResourceDetails.
        Name of the monitored resource


        :return: The name of this MonitoredResourceDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this MonitoredResourceDetails.
        Name of the monitored resource


        :param name: The name of this MonitoredResourceDetails.
        :type: str
        """
        self._name = name

    @property
    def type(self):
        """
        **[Required]** Gets the type of this MonitoredResourceDetails.
        Type of the monitored resource


        :return: The type of this MonitoredResourceDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this MonitoredResourceDetails.
        Type of the monitored resource


        :param type: The type of this MonitoredResourceDetails.
        :type: str
        """
        self._type = type

    @property
    def number_of_members(self):
        """
        Gets the number_of_members of this MonitoredResourceDetails.
        Number of members of the resource


        :return: The number_of_members of this MonitoredResourceDetails.
        :rtype: int
        """
        return self._number_of_members

    @number_of_members.setter
    def number_of_members(self, number_of_members):
        """
        Sets the number_of_members of this MonitoredResourceDetails.
        Number of members of the resource


        :param number_of_members: The number_of_members of this MonitoredResourceDetails.
        :type: int
        """
        self._number_of_members = number_of_members

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
