# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostVulnerabilitySummary(object):
    """
    Summary of a host scan vulnerability
    """

    #: A constant which can be used with the severity property of a HostVulnerabilitySummary.
    #: This constant has a value of "NONE"
    SEVERITY_NONE = "NONE"

    #: A constant which can be used with the severity property of a HostVulnerabilitySummary.
    #: This constant has a value of "LOW"
    SEVERITY_LOW = "LOW"

    #: A constant which can be used with the severity property of a HostVulnerabilitySummary.
    #: This constant has a value of "MEDIUM"
    SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the severity property of a HostVulnerabilitySummary.
    #: This constant has a value of "HIGH"
    SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the severity property of a HostVulnerabilitySummary.
    #: This constant has a value of "CRITICAL"
    SEVERITY_CRITICAL = "CRITICAL"

    #: A constant which can be used with the state property of a HostVulnerabilitySummary.
    #: This constant has a value of "OPEN"
    STATE_OPEN = "OPEN"

    #: A constant which can be used with the state property of a HostVulnerabilitySummary.
    #: This constant has a value of "FIXED"
    STATE_FIXED = "FIXED"

    #: A constant which can be used with the state property of a HostVulnerabilitySummary.
    #: This constant has a value of "NOT_APPLICABLE"
    STATE_NOT_APPLICABLE = "NOT_APPLICABLE"

    #: A constant which can be used with the vulnerability_type property of a HostVulnerabilitySummary.
    #: This constant has a value of "CVE"
    VULNERABILITY_TYPE_CVE = "CVE"

    #: A constant which can be used with the vulnerability_type property of a HostVulnerabilitySummary.
    #: This constant has a value of "PROBLEM"
    VULNERABILITY_TYPE_PROBLEM = "PROBLEM"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerabilitySummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerabilitySummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerabilitySummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerabilitySummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerabilitySummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerabilitySummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new HostVulnerabilitySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this HostVulnerabilitySummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this HostVulnerabilitySummary.
        :type compartment_id: str

        :param cve_reference:
            The value to assign to the cve_reference property of this HostVulnerabilitySummary.
        :type cve_reference: str

        :param severity:
            The value to assign to the severity property of this HostVulnerabilitySummary.
            Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        :param state:
            The value to assign to the state property of this HostVulnerabilitySummary.
            Allowed values for this property are: "OPEN", "FIXED", "NOT_APPLICABLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type state: str

        :param name:
            The value to assign to the name property of this HostVulnerabilitySummary.
        :type name: str

        :param time_last_detected:
            The value to assign to the time_last_detected property of this HostVulnerabilitySummary.
        :type time_last_detected: datetime

        :param time_first_detected:
            The value to assign to the time_first_detected property of this HostVulnerabilitySummary.
        :type time_first_detected: datetime

        :param host_count:
            The value to assign to the host_count property of this HostVulnerabilitySummary.
        :type host_count: int

        :param vulnerability_type:
            The value to assign to the vulnerability_type property of this HostVulnerabilitySummary.
            Allowed values for this property are: "CVE", "PROBLEM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type vulnerability_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this HostVulnerabilitySummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'cve_reference': 'str',
            'severity': 'str',
            'state': 'str',
            'name': 'str',
            'time_last_detected': 'datetime',
            'time_first_detected': 'datetime',
            'host_count': 'int',
            'vulnerability_type': 'str',
            'lifecycle_state': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'cve_reference': 'cveReference',
            'severity': 'severity',
            'state': 'state',
            'name': 'name',
            'time_last_detected': 'timeLastDetected',
            'time_first_detected': 'timeFirstDetected',
            'host_count': 'hostCount',
            'vulnerability_type': 'vulnerabilityType',
            'lifecycle_state': 'lifecycleState'
        }
        self._id = None
        self._compartment_id = None
        self._cve_reference = None
        self._severity = None
        self._state = None
        self._name = None
        self._time_last_detected = None
        self._time_first_detected = None
        self._host_count = None
        self._vulnerability_type = None
        self._lifecycle_state = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this HostVulnerabilitySummary.
        ID of the vulnerability


        :return: The id of this HostVulnerabilitySummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this HostVulnerabilitySummary.
        ID of the vulnerability


        :param id: The id of this HostVulnerabilitySummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this HostVulnerabilitySummary.
        Compartment ID of the vulnerability. Vulnerabilities with identical CVEs can exist in different compartments.


        :return: The compartment_id of this HostVulnerabilitySummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this HostVulnerabilitySummary.
        Compartment ID of the vulnerability. Vulnerabilities with identical CVEs can exist in different compartments.


        :param compartment_id: The compartment_id of this HostVulnerabilitySummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def cve_reference(self):
        """
        Gets the cve_reference of this HostVulnerabilitySummary.
        Reference to MITRE CVE ID


        :return: The cve_reference of this HostVulnerabilitySummary.
        :rtype: str
        """
        return self._cve_reference

    @cve_reference.setter
    def cve_reference(self, cve_reference):
        """
        Sets the cve_reference of this HostVulnerabilitySummary.
        Reference to MITRE CVE ID


        :param cve_reference: The cve_reference of this HostVulnerabilitySummary.
        :type: str
        """
        self._cve_reference = cve_reference

    @property
    def severity(self):
        """
        **[Required]** Gets the severity of this HostVulnerabilitySummary.
        Severity of the vulnerability

        Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this HostVulnerabilitySummary.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this HostVulnerabilitySummary.
        Severity of the vulnerability


        :param severity: The severity of this HostVulnerabilitySummary.
        :type: str
        """
        allowed_values = ["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    @property
    def state(self):
        """
        Gets the state of this HostVulnerabilitySummary.
        State of the vulnerability

        Allowed values for this property are: "OPEN", "FIXED", "NOT_APPLICABLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The state of this HostVulnerabilitySummary.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this HostVulnerabilitySummary.
        State of the vulnerability


        :param state: The state of this HostVulnerabilitySummary.
        :type: str
        """
        allowed_values = ["OPEN", "FIXED", "NOT_APPLICABLE"]
        if not value_allowed_none_or_none_sentinel(state, allowed_values):
            state = 'UNKNOWN_ENUM_VALUE'
        self._state = state

    @property
    def name(self):
        """
        **[Required]** Gets the name of this HostVulnerabilitySummary.
        Vulnerability name


        :return: The name of this HostVulnerabilitySummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this HostVulnerabilitySummary.
        Vulnerability name


        :param name: The name of this HostVulnerabilitySummary.
        :type: str
        """
        self._name = name

    @property
    def time_last_detected(self):
        """
        **[Required]** Gets the time_last_detected of this HostVulnerabilitySummary.
        Date of scan result that most recently reported the vulnerability


        :return: The time_last_detected of this HostVulnerabilitySummary.
        :rtype: datetime
        """
        return self._time_last_detected

    @time_last_detected.setter
    def time_last_detected(self, time_last_detected):
        """
        Sets the time_last_detected of this HostVulnerabilitySummary.
        Date of scan result that most recently reported the vulnerability


        :param time_last_detected: The time_last_detected of this HostVulnerabilitySummary.
        :type: datetime
        """
        self._time_last_detected = time_last_detected

    @property
    def time_first_detected(self):
        """
        **[Required]** Gets the time_first_detected of this HostVulnerabilitySummary.
        Date of scan result that first reported the vulnerability


        :return: The time_first_detected of this HostVulnerabilitySummary.
        :rtype: datetime
        """
        return self._time_first_detected

    @time_first_detected.setter
    def time_first_detected(self, time_first_detected):
        """
        Sets the time_first_detected of this HostVulnerabilitySummary.
        Date of scan result that first reported the vulnerability


        :param time_first_detected: The time_first_detected of this HostVulnerabilitySummary.
        :type: datetime
        """
        self._time_first_detected = time_first_detected

    @property
    def host_count(self):
        """
        **[Required]** Gets the host_count of this HostVulnerabilitySummary.
        Number of scanned hosts in this compartment whose scan results currently report this vulnerability


        :return: The host_count of this HostVulnerabilitySummary.
        :rtype: int
        """
        return self._host_count

    @host_count.setter
    def host_count(self, host_count):
        """
        Sets the host_count of this HostVulnerabilitySummary.
        Number of scanned hosts in this compartment whose scan results currently report this vulnerability


        :param host_count: The host_count of this HostVulnerabilitySummary.
        :type: int
        """
        self._host_count = host_count

    @property
    def vulnerability_type(self):
        """
        **[Required]** Gets the vulnerability_type of this HostVulnerabilitySummary.
        Specifies the type of Vulnerability

        Allowed values for this property are: "CVE", "PROBLEM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The vulnerability_type of this HostVulnerabilitySummary.
        :rtype: str
        """
        return self._vulnerability_type

    @vulnerability_type.setter
    def vulnerability_type(self, vulnerability_type):
        """
        Sets the vulnerability_type of this HostVulnerabilitySummary.
        Specifies the type of Vulnerability


        :param vulnerability_type: The vulnerability_type of this HostVulnerabilitySummary.
        :type: str
        """
        allowed_values = ["CVE", "PROBLEM"]
        if not value_allowed_none_or_none_sentinel(vulnerability_type, allowed_values):
            vulnerability_type = 'UNKNOWN_ENUM_VALUE'
        self._vulnerability_type = vulnerability_type

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this HostVulnerabilitySummary.
        The current state of the resource.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this HostVulnerabilitySummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this HostVulnerabilitySummary.
        The current state of the resource.


        :param lifecycle_state: The lifecycle_state of this HostVulnerabilitySummary.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
