# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstallLatestPatchesOnWlsDomainDetails(object):
    """
    The configuration details for the install latest patches to WebLogic domain operation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InstallLatestPatchesOnWlsDomainDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_force_servers_shutdown:
            The value to assign to the is_force_servers_shutdown property of this InstallLatestPatchesOnWlsDomainDetails.
        :type is_force_servers_shutdown: bool

        :param must_include_domains_sharing_middleware:
            The value to assign to the must_include_domains_sharing_middleware property of this InstallLatestPatchesOnWlsDomainDetails.
        :type must_include_domains_sharing_middleware: bool

        """
        self.swagger_types = {
            'is_force_servers_shutdown': 'bool',
            'must_include_domains_sharing_middleware': 'bool'
        }
        self.attribute_map = {
            'is_force_servers_shutdown': 'isForceServersShutdown',
            'must_include_domains_sharing_middleware': 'mustIncludeDomainsSharingMiddleware'
        }
        self._is_force_servers_shutdown = None
        self._must_include_domains_sharing_middleware = None

    @property
    def is_force_servers_shutdown(self):
        """
        Gets the is_force_servers_shutdown of this InstallLatestPatchesOnWlsDomainDetails.
        When installing or uninstalling patches, forces shutdown of the servers if they have not shutdown after a period of time. The timeout can be configured in the WebLogic domain configuration.


        :return: The is_force_servers_shutdown of this InstallLatestPatchesOnWlsDomainDetails.
        :rtype: bool
        """
        return self._is_force_servers_shutdown

    @is_force_servers_shutdown.setter
    def is_force_servers_shutdown(self, is_force_servers_shutdown):
        """
        Sets the is_force_servers_shutdown of this InstallLatestPatchesOnWlsDomainDetails.
        When installing or uninstalling patches, forces shutdown of the servers if they have not shutdown after a period of time. The timeout can be configured in the WebLogic domain configuration.


        :param is_force_servers_shutdown: The is_force_servers_shutdown of this InstallLatestPatchesOnWlsDomainDetails.
        :type: bool
        """
        self._is_force_servers_shutdown = is_force_servers_shutdown

    @property
    def must_include_domains_sharing_middleware(self):
        """
        Gets the must_include_domains_sharing_middleware of this InstallLatestPatchesOnWlsDomainDetails.
        When installing or uninstalling patches, allows the operation to proceed on all domains that share the same middleware. If not set to true, the installation or uninstallation will fail if there is any other domain using the same middleware.


        :return: The must_include_domains_sharing_middleware of this InstallLatestPatchesOnWlsDomainDetails.
        :rtype: bool
        """
        return self._must_include_domains_sharing_middleware

    @must_include_domains_sharing_middleware.setter
    def must_include_domains_sharing_middleware(self, must_include_domains_sharing_middleware):
        """
        Sets the must_include_domains_sharing_middleware of this InstallLatestPatchesOnWlsDomainDetails.
        When installing or uninstalling patches, allows the operation to proceed on all domains that share the same middleware. If not set to true, the installation or uninstallation will fail if there is any other domain using the same middleware.


        :param must_include_domains_sharing_middleware: The must_include_domains_sharing_middleware of this InstallLatestPatchesOnWlsDomainDetails.
        :type: bool
        """
        self._must_include_domains_sharing_middleware = must_include_domains_sharing_middleware

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
